# Import Berkas Audit

Sistem ini digunakan untuk mengimport data berkas audit dari file Excel ke dalam database.

## Fitur

1. **Upload File Excel** - Mendukung format .xlsx, .xls, dan .csv
2. **Deteksi Otomatis** - Sistem otomatis mendeteksi apakah data termasuk sub_elemen atau sub_sub_elemen
3. **Validasi Data** - Memastikan kode sub elemen atau sub sub elemen ada di database
4. **Preview Hasil** - Menampilkan detail hasil import (berhasil, dilewati, error)

## Struktur File Excel

Kolom yang diperlukan dalam file Excel:

- **Kolom A**: Nomor urut (opsional)
- **Kolom B**: Kriteria/nama elemen (opsional)
- **Kolom C**: Kode Sub Elemen (contoh: I.1, II.1, dll) - WAJIB jika tidak ada sub sub elemen
- **Kolom D**: Kode Sub Sub Elemen - diprioritaskan jika diisi
- **Kolom E-G**: Metode Audit (opsional)
- **Kolom H**: Sample/Catatan Khusus/Dokumen yang dibutuhkan - WAJIB

## Cara Penggunaan

1. Pilih audit yang akan diimport datanya
2. Download template Excel jika diperlukan
3. Siapkan data sesuai template
4. Upload file Excel melalui form
5. Sistem akan memproses dan menampilkan hasilnya

## Logika Deteksi

- Jika kolom D (kode_sub_sub_elemen) ada → data akan disimpan ke tabel `sub_sub_elemen_berkas`
- Jika kolom D kosong dan kolom C (kode_sub_elemen) ada → data akan disimpan ke tabel `sub_elemen_berkas`
- Sistem akan mengecek kode di database untuk memastikan validitasnya

## Kebutuhan Sistem

- PHP 7.4+
- MySQL/MariaDB
- PhpSpreadsheet library
- Bootstrap 5
- jQuery (opsional)
