-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Waktu pembuatan: 09 Nov 2025 pada 17.05
-- Versi server: 11.4.8-MariaDB-cll-lve
-- Versi PHP: 8.4.14

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `audj8427_audit`
--

DELIMITER $$
--
-- Prosedur
--
CREATE DEFINER=`audj8427`@`localhost` PROCEDURE `sp_calculate_audit_score_silent` (IN `p_audit_id` INT)   BEGIN
    DECLARE v_total_score DECIMAL(5,2);
    
    
    SELECT SUM(
        CASE 
            WHEN (sk_total.total + ssk_total.total) > 0 
            THEN ((sk_score.score + ssk_score.score) / (sk_total.total + ssk_total.total)) * k.persentase_bobot
            ELSE 0 
        END
    ) INTO v_total_score
    FROM kriteria k
    LEFT JOIN (
        SELECT sk.kriteria_id, COALESCE(SUM(sk.poin_maksimal), 0) as total
        FROM sub_kriteria sk
        WHERE sk.status = 'aktif' 
        AND NOT EXISTS (
            SELECT 1 FROM sub_sub_kriteria ssk 
            WHERE ssk.sub_kriteria_id = sk.id AND ssk.status = 'aktif'
        )
        GROUP BY sk.kriteria_id
    ) sk_total ON k.id = sk_total.kriteria_id
    LEFT JOIN (
        SELECT sk.kriteria_id, COALESCE(SUM(ssk.poin_maksimal), 0) as total
        FROM sub_sub_kriteria ssk
        JOIN sub_kriteria sk ON ssk.sub_kriteria_id = sk.id
        WHERE sk.status = 'aktif' AND ssk.status = 'aktif'
        GROUP BY sk.kriteria_id
    ) ssk_total ON k.id = ssk_total.kriteria_id
    LEFT JOIN (
        SELECT sk.kriteria_id, COALESCE(SUM(psk.nilai), 0) as score
        FROM penilaian_sub_kriteria psk
        JOIN sub_kriteria sk ON psk.sub_kriteria_id = sk.id
        GROUP BY sk.kriteria_id
    ) sk_score ON k.id = sk_score.kriteria_id
    LEFT JOIN (
        SELECT sk.kriteria_id, COALESCE(SUM(pssk.nilai), 0) as score
        FROM penilaian_sub_sub_kriteria pssk
        JOIN sub_sub_kriteria ssk ON pssk.sub_sub_kriteria_id = ssk.id
        JOIN sub_kriteria sk ON ssk.sub_kriteria_id = sk.id
        GROUP BY sk.kriteria_id
    ) ssk_score ON k.id = ssk_score.kriteria_id
    WHERE k.audit_id = p_audit_id AND k.status = 'aktif';
    
    
    UPDATE audit 
    SET total_score = COALESCE(v_total_score, 0),
        last_updated = NOW()
    WHERE id = p_audit_id;
    
    
END$$

--
-- Fungsi
--
CREATE DEFINER=`audj8427`@`localhost` FUNCTION `f_generate_session_token` (`p_user_id` INT) RETURNS VARCHAR(255) CHARSET latin1 COLLATE latin1_swedish_ci DETERMINISTIC READS SQL DATA BEGIN
    DECLARE new_token VARCHAR(255);
    DECLARE token_exists INT DEFAULT 1;
    
    WHILE token_exists > 0 DO
        SET new_token = CONCAT('AI_', p_user_id, '_', UNIX_TIMESTAMP(), '_', FLOOR(RAND() * 10000));
        
        SELECT COUNT(*) INTO token_exists
        FROM ai_learning_sessions 
        WHERE session_token = new_token;
    END WHILE;
    
    RETURN new_token;
END$$

CREATE DEFINER=`audj8427`@`localhost` FUNCTION `f_get_available_gemini_key` () RETURNS INT(11) DETERMINISTIC READS SQL DATA BEGIN
    DECLARE available_key_id INT DEFAULT NULL;
    
    -- Cari API key yang masih memiliki quota dan aktif
    SELECT id INTO available_key_id
    FROM gemini_api_keys 
    WHERE is_active = TRUE 
    AND quota_terpakai < quota_harian
    AND (last_reset_quota IS NULL OR last_reset_quota < CURDATE())
    ORDER BY quota_terpakai ASC, RAND()
    LIMIT 1;
    
    -- Reset quota jika tanggal berbeda
    IF available_key_id IS NOT NULL THEN
        UPDATE gemini_api_keys 
        SET quota_terpakai = 0, last_reset_quota = CURDATE()
        WHERE id = available_key_id AND (last_reset_quota IS NULL OR last_reset_quota < CURDATE());
    END IF;
    
    RETURN available_key_id;
END$$

CREATE DEFINER=`audj8427`@`localhost` FUNCTION `f_hitung_nilai_kriteria` (`p_kriteria_id` INT, `p_departemen_id` INT) RETURNS DECIMAL(5,2) DETERMINISTIC READS SQL DATA BEGIN
    DECLARE total_poin_tercapai INT DEFAULT 0;
    DECLARE total_poin_maksimal INT DEFAULT 0;
    DECLARE hasil_persentase DECIMAL(5,2) DEFAULT 0.00;
    
    -- Hitung dari semua sub kriteria
    SELECT 
        COALESCE(SUM(f_hitung_poin_sub_kriteria(sk.id, p_departemen_id)), 0),
        COALESCE(SUM(sk.poin_maksimal), 0)
    INTO total_poin_tercapai, total_poin_maksimal
    FROM sub_kriteria sk 
    WHERE sk.kriteria_id = p_kriteria_id AND sk.status = 'aktif';
    
    -- Hitung persentase
    IF total_poin_maksimal > 0 THEN
        SET hasil_persentase = (total_poin_tercapai / total_poin_maksimal) * 100;
    END IF;
    
    RETURN ROUND(hasil_persentase, 2);
END$$

CREATE DEFINER=`audj8427`@`localhost` FUNCTION `f_hitung_nilai_otomatis` (`p_audit_id` INT, `p_departemen_id` INT) RETURNS DECIMAL(5,2) DETERMINISTIC READS SQL DATA BEGIN
    DECLARE total_persentase DECIMAL(5,2) DEFAULT 0.00;
    DECLARE total_bobot DECIMAL(5,2) DEFAULT 0.00;
    
    -- Cursor untuk iterasi semua kriteria
    DECLARE done INT DEFAULT FALSE;
    DECLARE v_kriteria_id INT;
    DECLARE v_persentase_bobot DECIMAL(5,2);
    DECLARE v_nilai_kriteria DECIMAL(5,2);
    
    DECLARE cur_kriteria CURSOR FOR 
        SELECT k.id, k.persentase_bobot 
        FROM kriteria k 
        WHERE k.audit_id = p_audit_id AND k.status = 'aktif';
    
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
    
    -- Iterasi setiap kriteria
    OPEN cur_kriteria;
    read_loop: LOOP
        FETCH cur_kriteria INTO v_kriteria_id, v_persentase_bobot;
        IF done THEN
            LEAVE read_loop;
        END IF;
        
        -- Hitung nilai kriteria ini
        SET v_nilai_kriteria = f_hitung_nilai_kriteria(v_kriteria_id, p_departemen_id);
        
        -- Tambahkan ke total dengan pembobotan
        SET total_persentase = total_persentase + (v_nilai_kriteria * v_persentase_bobot / 100);
        SET total_bobot = total_bobot + v_persentase_bobot;
    END LOOP;
    
    CLOSE cur_kriteria;
    
    -- Return persentase final
    IF total_bobot > 0 THEN
        RETURN ROUND(total_persentase, 2);
    ELSE
        RETURN 0.00;
    END IF;
END$$

CREATE DEFINER=`audj8427`@`localhost` FUNCTION `f_hitung_poin_sub_kriteria` (`p_sub_kriteria_id` INT, `p_departemen_id` INT) RETURNS INT(11) DETERMINISTIC READS SQL DATA BEGIN
    DECLARE poin_tercapai INT DEFAULT 0;
    DECLARE poin_maksimal INT DEFAULT 0;
    DECLARE ada_sub_sub BOOLEAN DEFAULT FALSE;
    
    -- Cek apakah ada sub sub kriteria
    SELECT COUNT(*) > 0 INTO ada_sub_sub
    FROM sub_sub_kriteria ssk 
    WHERE ssk.sub_kriteria_id = p_sub_kriteria_id AND ssk.status = 'aktif';
    
    IF ada_sub_sub THEN
        -- Hitung dari sub sub kriteria
        SELECT 
            COALESCE(SUM(f_hitung_poin_sub_sub_kriteria(ssk.id, p_departemen_id)), 0)
        INTO poin_tercapai
        FROM sub_sub_kriteria ssk 
        WHERE ssk.sub_kriteria_id = p_sub_kriteria_id AND ssk.status = 'aktif';
    ELSE
        -- Hitung langsung dari upload sub kriteria
        SELECT 
            sk.poin_maksimal,
            COALESCE(f_hitung_poin_upload_sub_kriteria(p_sub_kriteria_id, p_departemen_id), 0)
        INTO poin_maksimal, poin_tercapai
        FROM sub_kriteria sk 
        WHERE sk.id = p_sub_kriteria_id;
    END IF;
    
    RETURN poin_tercapai;
END$$

CREATE DEFINER=`audj8427`@`localhost` FUNCTION `f_hitung_poin_sub_sub_kriteria` (`p_sub_sub_kriteria_id` INT, `p_departemen_id` INT) RETURNS INT(11) DETERMINISTIC READS SQL DATA BEGIN
    DECLARE poin_tercapai INT DEFAULT 0;
    DECLARE poin_maksimal INT DEFAULT 0;
    DECLARE berkas_wajib INT DEFAULT 0;
    DECLARE berkas_uploaded INT DEFAULT 0;
    
    -- Ambil poin maksimal dan hitung berkas utama
    SELECT 
        ssk.poin_maksimal,
        COUNT(sskb.id),
        COUNT(CASE WHEN u.id IS NOT NULL AND u.status_verifikasi_kantor = 'approved' THEN 1 END)
    INTO poin_maksimal, berkas_wajib, berkas_uploaded
    FROM sub_sub_kriteria ssk
    LEFT JOIN sub_sub_kriteria_berkas sskb ON ssk.id = sskb.sub_sub_kriteria_id
    LEFT JOIN upload_sub_sub_kriteria u ON sskb.id = u.sub_sub_kriteria_berkas_id 
        AND u.uploaded_by IN (SELECT id FROM users WHERE departemen_id = p_departemen_id)
    WHERE ssk.id = p_sub_sub_kriteria_id
    GROUP BY ssk.id, ssk.poin_maksimal;
    
    -- Hitung poin tercapai
    IF berkas_wajib > 0 THEN
        SET poin_tercapai = ROUND((berkas_uploaded / berkas_wajib) * poin_maksimal);
    END IF;
    
    RETURN poin_tercapai;
END$$

CREATE DEFINER=`audj8427`@`localhost` FUNCTION `f_hitung_poin_upload_sub_kriteria` (`p_sub_kriteria_id` INT, `p_departemen_id` INT) RETURNS INT(11) DETERMINISTIC READS SQL DATA BEGIN
    DECLARE poin_tercapai INT DEFAULT 0;
    DECLARE poin_maksimal INT DEFAULT 0;
    DECLARE berkas_wajib INT DEFAULT 0;
    DECLARE berkas_uploaded INT DEFAULT 0;
    
    -- Ambil poin maksimal dan hitung berkas utama
    SELECT 
        sk.poin_maksimal,
        COUNT(skb.id),
        COUNT(CASE WHEN u.id IS NOT NULL AND u.status_verifikasi_kantor = 'approved' THEN 1 END)
    INTO poin_maksimal, berkas_wajib, berkas_uploaded
    FROM sub_kriteria sk
    LEFT JOIN sub_kriteria_berkas skb ON sk.id = skb.sub_kriteria_id
    LEFT JOIN upload_sub_kriteria u ON skb.id = u.sub_kriteria_berkas_id 
        AND u.uploaded_by IN (SELECT id FROM users WHERE departemen_id = p_departemen_id)
    WHERE sk.id = p_sub_kriteria_id
    GROUP BY sk.id, sk.poin_maksimal;
    
    -- Hitung poin tercapai
    IF berkas_wajib > 0 THEN
        SET poin_tercapai = ROUND((berkas_uploaded / berkas_wajib) * poin_maksimal);
    END IF;
    
    RETURN poin_tercapai;
END$$

CREATE DEFINER=`audj8427`@`localhost` FUNCTION `f_update_gemini_usage` (`p_api_key_id` INT) RETURNS TINYINT(1) DETERMINISTIC READS SQL DATA BEGIN
    DECLARE usage_updated BOOLEAN DEFAULT FALSE;
    
    UPDATE gemini_api_keys 
    SET quota_terpakai = quota_terpakai + 1,
        last_used_at = CURRENT_TIMESTAMP
    WHERE id = p_api_key_id AND quota_terpakai < quota_harian;
    
    IF ROW_COUNT() > 0 THEN
        SET usage_updated = TRUE;
    END IF;
    
    RETURN usage_updated;
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Struktur dari tabel `activity_log`
--

CREATE TABLE `activity_log` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `action` varchar(100) NOT NULL,
  `table_name` varchar(50) NOT NULL,
  `record_id` int(11) NOT NULL,
  `old_values` longtext DEFAULT NULL CHECK (json_valid(`old_values`)),
  `new_values` longtext DEFAULT NULL CHECK (json_valid(`new_values`)),
  `description` mediumtext DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data untuk tabel `activity_log`
--

INSERT INTO `activity_log` (`id`, `user_id`, `action`, `table_name`, `record_id`, `old_values`, `new_values`, `description`, `ip_address`, `user_agent`, `created_at`) VALUES
(1, 2, 'api_config', 'gemini_api_keys', 0, NULL, NULL, 'Test API key berhasil: Primary API Key', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-08 21:08:29'),
(2, 2, 'api_config', 'gemini_api_keys', 0, NULL, NULL, 'Test API key berhasil: Primary API Key', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-08 21:18:38'),
(3, 2, 'elemen_created', 'elemen', 1, NULL, NULL, 'Elemen \'as\' berhasil dibuat', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-08 22:33:25'),
(4, 2, 'sub_elemen_created', 'elemen', 1, NULL, NULL, 'Sub elemen \'q\' berhasil dibuat', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-08 22:33:43'),
(5, 2, 'sub_sub_elemen_created', 'elemen', 1, NULL, NULL, 'Sub sub elemen \'1\' berhasil dibuat', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-08 22:33:52'),
(6, 2, 'sub_sub_elemen_updated', 'elemen', 1, NULL, NULL, 'Sub sub elemen \'1\' berhasil diupdate', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-08 22:40:09'),
(7, 2, 'sub_sub_elemen_updated', 'elemen', 1, NULL, NULL, 'Sub sub elemen \'1222\' berhasil diupdate', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-08 22:40:15'),
(8, 2, 'sub_sub_elemen_deleted', 'elemen', 1, NULL, NULL, 'Sub sub elemen \'1222\' berhasil dihapus', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-08 22:49:39'),
(9, 2, 'sub_elemen_deleted', 'elemen', 1, NULL, NULL, 'Sub elemen \'q\' berhasil dihapus', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-08 22:50:55'),
(10, 2, 'elemen_created', 'elemen', 2, NULL, NULL, 'Elemen \'sdads\' berhasil dibuat', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-08 22:52:09'),
(11, 2, 'sub_elemen_created', 'elemen', 2, NULL, NULL, 'Sub elemen \'11\' berhasil dibuat', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-08 22:52:17'),
(12, 2, 'sub_elemen_deleted', 'elemen', 2, NULL, NULL, 'Sub elemen \'11\' berhasil dihapus', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-08 22:56:26'),
(13, 2, 'elemen_updated', 'elemen', 2, NULL, NULL, 'Elemen \'232323\' berhasil diupdate', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-08 22:57:10'),
(15, 2, 'elemen_created', 'elemen', 3, NULL, NULL, 'Elemen \'KEBIJAKAN\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:16:30'),
(16, 2, 'sub_elemen_created', 'elemen', 3, NULL, NULL, 'Sub elemen \'Penyusunan Kebijakan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:17:20'),
(17, 2, 'elemen_created', 'elemen', 4, NULL, NULL, 'Elemen \'PERENCANAAN\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:18:01'),
(18, 2, 'sub_elemen_created', 'elemen', 4, NULL, NULL, 'Sub elemen \'Penelaahan Awal\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:18:28'),
(19, 2, 'sub_elemen_created', 'elemen', 5, NULL, NULL, 'Sub elemen \'Manajemen Risiko\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:19:16'),
(20, 2, 'sub_sub_elemen_created', 'elemen', 2, NULL, NULL, 'Sub sub elemen \'Komunikasi dan konsultasi risiko\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:19:45'),
(21, 2, 'sub_elemen_created', 'elemen', 6, NULL, NULL, 'Sub elemen \'lsi  Kebiiakan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:21:42'),
(22, 2, 'sub_elemen_created', 'elemen', 7, NULL, NULL, 'Sub elemen \'Penetapan Kebijakan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:22:15'),
(23, 2, 'sub_elemen_created', 'elemen', 8, NULL, NULL, 'Sub elemen \'Komunikasi Kebijakan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:22:38'),
(24, 2, 'sub_elemen_created', 'elemen', 9, NULL, NULL, 'Sub elemen \'Tinjauan Kebijakan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:23:04'),
(25, 2, 'sub_sub_elemen_created', 'elemen', 3, NULL, NULL, 'Sub sub elemen \'Penetapan konteks risiko\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:23:40'),
(26, 2, 'sub_sub_elemen_created', 'elemen', 4, NULL, NULL, 'Sub sub elemen \'Identifikasi bahaya\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:24:25'),
(27, 2, 'sub_sub_elemen_created', 'elemen', 5, NULL, NULL, 'Sub sub elemen \'Penilaian dan pengendalian risiko		\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:24:45'),
(28, 2, 'sub_sub_elemen_created', 'elemen', 6, NULL, NULL, 'Sub sub elemen \'Pemantauan dan peninjauan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:25:12'),
(29, 2, 'sub_elemen_created', 'elemen', 10, NULL, NULL, 'Sub elemen \'Identifikasi dan Kepatuhan Terhadap Ketentuan Peraturan Perundang-undangan dan Persyaratan Lainnya yang Terkait\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:25:54'),
(30, 2, 'sub_elemen_created', 'elemen', 11, NULL, NULL, 'Sub elemen \'Penetapan Tujuan, Sasaran, dan Program\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:26:26'),
(31, 2, 'sub_elemen_created', 'elemen', 12, NULL, NULL, 'Sub elemen \'Rencana Kerja dan Anggaran Keselamatan Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:26:48'),
(32, 2, 'elemen_created', 'elemen', 5, NULL, NULL, 'Elemen \'ORGANISASI DAN PERSONEL\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:27:41'),
(33, 2, 'sub_elemen_created', 'elemen', 13, NULL, NULL, 'Sub elemen \'Penyusunan dan Penetapan Struktur Organisasi, Tugas, Tanggung Jawab, dan Wewenang\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:28:21'),
(34, 2, 'sub_elemen_created', 'elemen', 14, NULL, NULL, 'Sub elemen \'Penunjukan KTT, Kepala Tambang Bawah Tanah, dan/atau Kepala Kapal Keruk untuk Perusahaan Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:31:28'),
(35, 2, 'sub_elemen_updated', 'elemen', 14, NULL, NULL, 'Sub elemen \'Penunjukan KTT, Kepala Tambang Bawah Tanah, dan/atau Kepala Kapal Keruk untuk Perusahaan Pertambangan\' berhasil diupdate', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:31:37'),
(36, 2, 'sub_sub_elemen_created', 'elemen', 7, NULL, NULL, 'Sub sub elemen \'Penunjukan KTT\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:32:06'),
(37, 2, 'sub_sub_elemen_created', 'elemen', 8, NULL, NULL, 'Sub sub elemen \'Penunjukan Kepala Tambang Bawah Tanah\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:32:31'),
(38, 2, 'sub_sub_elemen_created', 'elemen', 9, NULL, NULL, 'Sub sub elemen \'Penunjukan Kepala Kapal Keruk\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:32:57'),
(39, 2, 'sub_elemen_created', 'elemen', 15, NULL, NULL, 'Sub elemen \'Penunjukan PJO Untuk Perusahaan Jasa Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:33:27'),
(40, 2, 'sub_elemen_created', 'elemen', 16, NULL, NULL, 'Sub elemen \'Pembentukan dan Penetapan Bagian K3 Pertambangan dan KO Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:34:39'),
(41, 2, 'sub_elemen_created', 'elemen', 17, NULL, NULL, 'Sub elemen \'Penunjukan Pengawas Operasional dan Pengawas Teknik\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:35:17'),
(42, 2, 'sub_elemen_created', 'elemen', 18, NULL, NULL, 'Sub elemen \'Penunjukan Tenaga Teknik Khusus Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:35:44'),
(43, 2, 'sub_elemen_created', 'elemen', 19, NULL, NULL, 'Sub elemen \'Pembentukan dan Penetapan Komite Keselamatan Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:36:12'),
(44, 2, 'sub_elemen_created', 'elemen', 20, NULL, NULL, 'Sub elemen \'Penunjukan Tim Tanggap Darurat\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:36:32'),
(45, 2, 'sub_elemen_created', 'elemen', 21, NULL, NULL, 'Sub elemen \'Seleksi dan Penempatan Personel\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:37:07'),
(46, 2, 'sub_elemen_created', 'elemen', 22, NULL, NULL, 'Sub elemen \'Penyelenggaraan dan Pelaksanaan Pendidikan dan Pelatihan Serta Kompetensi Kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:37:35'),
(47, 2, 'sub_sub_elemen_created', 'elemen', 10, NULL, NULL, 'Sub sub elemen \'III.10.1\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:38:20'),
(48, 2, 'sub_sub_elemen_created', 'elemen', 11, NULL, NULL, 'Sub sub elemen \'Kompetensi Kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:39:24'),
(49, 2, 'sub_elemen_created', 'elemen', 23, NULL, NULL, 'Sub elemen \'Penyusunan, Penetapan, dan Penerapan Komunikasi Keselamatan Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:40:52'),
(50, 2, 'sub_elemen_created', 'elemen', 24, NULL, NULL, 'Sub elemen \'Pengelolaan Administrasi Keselamatan Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:41:29'),
(51, 2, 'sub_elemen_updated', 'elemen', 24, NULL, NULL, 'Sub elemen \'Pengelolaan Administrasi Keselamatan Pertambangan\' berhasil diupdate', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:42:08'),
(52, 2, 'sub_sub_elemen_created', 'elemen', 12, NULL, NULL, 'Sub sub elemen \'Buku tambang\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:42:36'),
(53, 2, 'sub_sub_elemen_created', 'elemen', 13, NULL, NULL, 'Sub sub elemen \'Buku daftar kecelakaan tambang\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:43:01'),
(54, 2, 'sub_sub_elemen_created', 'elemen', 14, NULL, NULL, 'Sub sub elemen \'Pelaporan pengelolaan Keselamatan Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:43:26'),
(55, 2, 'sub_sub_elemen_created', 'elemen', 15, NULL, NULL, 'Sub sub elemen \'Dokumentasi Kejadian Berbahaya, kejadian akibat penyakit tenaga kerja dan penyakit akibat kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:43:47'),
(56, 2, 'sub_sub_elemen_created', 'elemen', 16, NULL, NULL, 'Sub sub elemen \'Dokumen dan Laporan Pemenuhan Kompetensi dan Persyaratan Lainnya\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:44:18'),
(57, 2, 'sub_elemen_created', 'elemen', 25, NULL, NULL, 'Sub elemen \'Penyusunan, Penerapan, dan Pendokumentasian Prosedur Partisipasi, Konsultasi, Motivasi, dan Kesadaran Penerapan SMKP Minerba\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:44:59'),
(58, 2, 'elemen_created', 'elemen', 6, NULL, NULL, 'Elemen \'IMPLEMENTASI\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:45:37'),
(59, 2, 'sub_elemen_created', 'elemen', 26, NULL, NULL, 'Sub elemen \'Pelaksanaan Pengelolaan Operasional\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:46:15'),
(60, 2, 'sub_sub_elemen_created', 'elemen', 17, NULL, NULL, 'Sub sub elemen \'Penyusunan, Penetapan, Penerapan, Pendokumentasian, dan Evaluasi Prosedur Operasi / Kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:46:46'),
(61, 2, 'sub_sub_elemen_created', 'elemen', 18, NULL, NULL, 'Sub sub elemen \'Penyusunan, Penetapan, Penerapan, Pendokumentasian, dan Evaluasi Izin kerja khusus\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:47:07'),
(62, 2, 'sub_sub_elemen_created', 'elemen', 19, NULL, NULL, 'Sub sub elemen \'Penyusunan, Penetapan, Penerapan, Pendokumentasian, dan Evaluasi Prosedur Operasi / Kerja Alat pelindung diri dan alat keselamatan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:47:32'),
(63, 2, 'sub_elemen_created', 'elemen', 27, NULL, NULL, 'Sub elemen \'Pelaksanaan Pengelolaan Lingkungan Kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:48:14'),
(64, 2, 'sub_sub_elemen_created', 'elemen', 20, NULL, NULL, 'Sub sub elemen \'Pelaksanaan pengelolaan Bahaya Debu\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:48:39'),
(65, 2, 'sub_sub_elemen_created', 'elemen', 21, NULL, NULL, 'Sub sub elemen \'Pelaksanaan pengelolaan Bahaya Kebisingan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:49:18'),
(66, 2, 'sub_sub_elemen_created', 'elemen', 22, NULL, NULL, 'Sub sub elemen \'Pelaksanaan pengelolaan Bahaya Getaran\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:49:49'),
(67, 2, 'sub_sub_elemen_created', 'elemen', 23, NULL, NULL, 'Sub sub elemen \'Pelaksanaan pengelolaan Bahaya Pencahayaan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:50:29'),
(68, 2, 'sub_sub_elemen_created', 'elemen', 24, NULL, NULL, 'Sub sub elemen \'Pelaksanaan pengelolaan Kuantitas dan Kualitas Udara Kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:50:56'),
(69, 2, 'sub_sub_elemen_created', 'elemen', 25, NULL, NULL, 'Sub sub elemen \'Pelaksanaan pengelolaan Iklim Kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:51:20'),
(70, 2, 'sub_sub_elemen_created', 'elemen', 26, NULL, NULL, 'Sub sub elemen \'Pelaksanaan pengelolaan Bahaya Radiasi\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:51:43'),
(71, 2, 'sub_sub_elemen_created', 'elemen', 27, NULL, NULL, 'Sub sub elemen \'Pelaksanaan pengelolaan Faktor Kimia\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:52:04'),
(72, 2, 'sub_sub_elemen_created', 'elemen', 28, NULL, NULL, 'Sub sub elemen \'Pelaksanaan pengelolaan Faktor Biologi\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:52:24'),
(73, 2, 'sub_sub_elemen_created', 'elemen', 29, NULL, NULL, 'Sub sub elemen \'Pelaksanaan Kebersihan Lingkungan Kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:52:43'),
(74, 2, 'sub_elemen_created', 'elemen', 28, NULL, NULL, 'Sub elemen \'Pelaksanaan Pengelolaan Kesehatan Kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:54:18'),
(75, 2, 'sub_sub_elemen_created', 'elemen', 30, NULL, NULL, 'Sub sub elemen \'Pemeriksaan Kesehatan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:54:45'),
(76, 2, 'sub_sub_elemen_created', 'elemen', 31, NULL, NULL, 'Sub sub elemen \'Pelayanan Kesehatan Kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:55:11'),
(77, 2, 'sub_sub_elemen_created', 'elemen', 32, NULL, NULL, 'Sub sub elemen \'Pertolongan Pertama pada Kecelakaan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:55:32'),
(78, 2, 'sub_sub_elemen_created', 'elemen', 33, NULL, NULL, 'Sub sub elemen \'Pengelolaan Kelelahan Kerja (Fatigue)\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:56:00'),
(79, 2, 'sub_sub_elemen_created', 'elemen', 34, NULL, NULL, 'Sub sub elemen \'Pengelolaan Pekerja pada Tempat yang Memiliki Risiko Kesehatan Tinggi\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:56:29'),
(80, 2, 'sub_sub_elemen_created', 'elemen', 35, NULL, NULL, 'Sub sub elemen \'Pengelolaan Rekaman Data Kesehatan Kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:56:58'),
(81, 2, 'sub_sub_elemen_created', 'elemen', 36, NULL, NULL, 'Sub sub elemen \'Pengelolaan Higiene dan Sanitasi\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:58:12'),
(82, 2, 'sub_sub_elemen_created', 'elemen', 37, NULL, NULL, 'Sub sub elemen \'Pengelolaan Ergonomi\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:58:41'),
(83, 2, 'sub_sub_elemen_created', 'elemen', 38, NULL, NULL, 'Sub sub elemen \'Pengelolaan Makanan, Minuman dan Gizi Pekerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:59:15'),
(84, 2, 'sub_sub_elemen_created', 'elemen', 39, NULL, NULL, 'Sub sub elemen \'Diagnosis dan Pemeriksaan Penyakit Akibat Kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-08 23:59:55'),
(85, 2, 'sub_elemen_created', 'elemen', 29, NULL, NULL, 'Sub elemen \'Pelaksanaan Pengelolaan KO Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:00:23'),
(86, 2, 'sub_sub_elemen_created', 'elemen', 40, NULL, NULL, 'Sub sub elemen \'Sistem dan pelaksanaan pemeliharaan / perawatan sarana, prasarana, instalasi, dan peralatan pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:00:47'),
(87, 2, 'sub_sub_elemen_created', 'elemen', 41, NULL, NULL, 'Sub sub elemen \'Pengamanan instalasi\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:01:11'),
(88, 2, 'sub_sub_elemen_created', 'elemen', 42, NULL, NULL, 'Sub sub elemen \'Kelayakan sarana, prasarana, instalasi, dan peralatan pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:01:36'),
(89, 2, 'sub_sub_elemen_created', 'elemen', 43, NULL, NULL, 'Sub sub elemen \'Kompetensi tenaga teknik\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:03:15'),
(90, 2, 'sub_sub_elemen_created', 'elemen', 44, NULL, NULL, 'Sub sub elemen \'Evaluasi Laporan Hasil Kajian Teknis Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:03:39'),
(91, 2, 'sub_elemen_created', 'elemen', 30, NULL, NULL, 'Sub elemen \'Pelaksanaan Pengelolaan Bahan Peledak dan Peledakan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:04:39'),
(92, 2, 'sub_sub_elemen_created', 'elemen', 45, NULL, NULL, 'Sub sub elemen \'Gudang bahan peledak\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:05:14'),
(93, 2, 'sub_sub_elemen_created', 'elemen', 46, NULL, NULL, 'Sub sub elemen \'Penyimpanan bahan peledak\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:05:36'),
(94, 2, 'sub_sub_elemen_created', 'elemen', 47, NULL, NULL, 'Sub sub elemen \'Pengangkutan bahan peledak\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:06:00'),
(95, 2, 'sub_sub_elemen_created', 'elemen', 48, NULL, NULL, 'Sub sub elemen \'Pekerjaan peledakan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:06:24'),
(96, 2, 'sub_elemen_created', 'elemen', 31, NULL, NULL, 'Sub elemen \'Penetapan Sistem Perancangan dan Rekayasa\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:07:05'),
(97, 2, 'sub_sub_elemen_created', 'elemen', 49, NULL, NULL, 'Sub sub elemen \'Perancangan dan rekayasa\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:09:19'),
(98, 2, 'sub_sub_elemen_created', 'elemen', 50, NULL, NULL, 'Sub sub elemen \'Perubahan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:09:40'),
(99, 2, 'sub_elemen_created', 'elemen', 32, NULL, NULL, 'Sub elemen \'Penetapan Sistem Pembelian\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:10:27'),
(100, 2, 'sub_elemen_created', 'elemen', 33, NULL, NULL, 'Sub elemen \'Pemantauan dan Pengelolaan Perusahaan Jasa Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:11:05'),
(101, 2, 'sub_sub_elemen_created', 'elemen', 51, NULL, NULL, 'Sub sub elemen \'Persyaratan, seleksi dan penetapan perusahaan jasa pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:11:38'),
(102, 2, 'sub_sub_elemen_created', 'elemen', 52, NULL, NULL, 'Sub sub elemen \'Tanggung jawab, pemantauan dan pelaporan perusahaan jasa pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:12:00'),
(103, 2, 'sub_sub_elemen_created', 'elemen', 53, NULL, NULL, 'Sub sub elemen \'Evaluasi perusahaan jasa pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:12:24'),
(104, 2, 'sub_elemen_created', 'elemen', 34, NULL, NULL, 'Sub elemen \'Pengelolaan Keadaan Darurat\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:13:12'),
(105, 2, 'sub_elemen_created', 'elemen', 35, NULL, NULL, 'Sub elemen \'Penyediaan dan Penyiapan P3K\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:13:38'),
(106, 2, 'sub_elemen_created', 'elemen', 36, NULL, NULL, 'Sub elemen \'Pelaksanaan keselamatan di luar pekerjaan (off the job safety)\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:14:04'),
(107, 2, 'elemen_created', 'elemen', 7, NULL, NULL, 'Elemen \'PEMANTAUAN, EVALUASI DAN TINDAK LANJUT\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:14:36'),
(108, 2, 'sub_elemen_created', 'elemen', 37, NULL, NULL, 'Sub elemen \'Pemantauan dan pengukuran kinerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:15:08'),
(109, 2, 'sub_sub_elemen_created', 'elemen', 54, NULL, NULL, 'Sub sub elemen \'Pemantauan dan Pengukuran Pencapaian Tujuan, Sasaran, dan program Keselamatan Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:15:37'),
(110, 2, 'sub_sub_elemen_created', 'elemen', 55, NULL, NULL, 'Sub sub elemen \'Pemantauan dan Pengukuran Kinerja Pengelolaan lingkungan kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:16:07'),
(111, 2, 'sub_sub_elemen_created', 'elemen', 56, NULL, NULL, 'Sub sub elemen \'Pemantauan dan Pengukuran Kinerja Pengelolaan kesehatan kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:16:31'),
(112, 2, 'sub_sub_elemen_created', 'elemen', 57, NULL, NULL, 'Sub sub elemen \'Pemantauan dan Pengukuran Kinerja Pengelolaan Keselamatan Operasi pertambangan	\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:16:57'),
(113, 2, 'sub_sub_elemen_created', 'elemen', 58, NULL, NULL, 'Sub sub elemen \'Pemantauan dan Pengukuran Kinerja Pengelolaan Bahan Peledak dan Peledakan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:17:24'),
(114, 2, 'sub_elemen_created', 'elemen', 38, NULL, NULL, 'Sub elemen \'Inspeksi Pelaksanaan Keselamatan Pertambangan	\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:18:16'),
(115, 2, 'sub_elemen_created', 'elemen', 39, NULL, NULL, 'Sub elemen \'Evaluasi kepatuhan Terhadap Ketentuan Peraturan Perundang-Undangan dan Persyaratan Lainnya Yang Terkait\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:18:48'),
(116, 2, 'sub_elemen_created', 'elemen', 40, NULL, NULL, 'Sub elemen \'Penyelidikan Kecelakaan, Kejadian Berbahaya, dan Penyakit Akibat Kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:19:21'),
(117, 2, 'sub_elemen_created', 'elemen', 41, NULL, NULL, 'Sub elemen \'Evaluasi Pengelolaan Administrasi Keselamatan Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:20:04'),
(118, 2, 'sub_sub_elemen_created', 'elemen', 59, NULL, NULL, 'Sub sub elemen \'Buku tambang\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:20:32'),
(119, 2, 'sub_sub_elemen_created', 'elemen', 60, NULL, NULL, 'Sub sub elemen \'Buku daftar kecelakaan tambang\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:21:33'),
(120, 2, 'sub_sub_elemen_created', 'elemen', 61, NULL, NULL, 'Sub sub elemen \'Pelaporan pengelolaan keselamatan pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:22:22'),
(121, 2, 'sub_sub_elemen_created', 'elemen', 62, NULL, NULL, 'Sub sub elemen \'Dokumentasi Kejadian Berbahaya, kejadian akibat penyakit tenaga kerja dan penyakit akibat kerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:22:46'),
(122, 2, 'sub_sub_elemen_created', 'elemen', 63, NULL, NULL, 'Sub sub elemen \'Dokumentasi dan Laporan pemenuhan Kompetensi serta Persyaratan Lainnya\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:23:18'),
(123, 2, 'sub_elemen_created', 'elemen', 42, NULL, NULL, 'Sub elemen \'Audit Internal Penerapan SMKP Minerba atau SMKP Khusus untuk pengolahan dan/ atau pemurnian\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:23:43'),
(124, 2, 'sub_elemen_created', 'elemen', 43, NULL, NULL, 'Sub elemen \'Rencana Perbaikan dan Tindak Lanjut\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:24:08'),
(125, 2, 'elemen_created', 'elemen', 8, NULL, NULL, 'Elemen \'DOKUMENTASI\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:24:38'),
(126, 2, 'sub_elemen_created', 'elemen', 44, NULL, NULL, 'Sub elemen \'Penyusunan Penetapan dan Pendokumentasian Manual SMKP Minerba atau SMKP Khusus pada Pengolahan dan/atau Pemurnian	\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:25:08'),
(127, 2, 'sub_elemen_created', 'elemen', 45, NULL, NULL, 'Sub elemen \'Penyusunan Penetapan, Penerapan dan Pendokumentasian Prosedur pengendalian Dokumen Keselamatan Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:25:35'),
(128, 2, 'sub_elemen_created', 'elemen', 46, NULL, NULL, 'Sub elemen \'Penyusunan Penetapan, Penerapan dan Pendokumentasian Prosedur pengendalian Rekaman Keselamatan Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:25:57'),
(129, 2, 'sub_elemen_created', 'elemen', 47, NULL, NULL, 'Sub elemen \'Penetapan Jenis Dokumen dan Rekaman\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:26:19'),
(130, 2, 'elemen_created', 'elemen', 9, NULL, NULL, 'Elemen \'TINJAUAN MANAJEMEN DAN PENINGKATAN KINERJA\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:26:44'),
(131, 2, 'sub_elemen_created', 'elemen', 48, NULL, NULL, 'Sub elemen \'Pelaksanaan Tinjauan Manajemen Penerapan SMKP Minerba atau SMKP Khusus pada pengolahan dan/atau Pemurnian oleh Manajemen Tertinggi Perusahaan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:27:12'),
(132, 2, 'sub_elemen_created', 'elemen', 49, NULL, NULL, 'Sub elemen \'Pendokumentasian Catatan Hasil Tinjauan Manajemen\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:27:37'),
(133, 2, 'sub_elemen_created', 'elemen', 50, NULL, NULL, 'Sub elemen \'Keluaran dari Tinjauan Manajemen Keselamatan Pertambangan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:28:24'),
(134, 2, 'sub_elemen_created', 'elemen', 51, NULL, NULL, 'Sub elemen \'Pencatatan, Pendokumentasian, dan Pelaporan Hasil Tinjauan Manajemen\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:28:55'),
(135, 2, 'sub_elemen_created', 'elemen', 52, NULL, NULL, 'Sub elemen \'Pelaksanaan Peningkatan Kinerja\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:29:21'),
(136, 2, 'sub_elemen_created', 'elemen', 53, NULL, NULL, 'Sub elemen \'Penggunaan Tinjauan Hasil dari Tindak Lanjut Rencana Perbaikan dalam Penentuan Kebijakan\' berhasil dibuat', '[::1]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-09 00:29:47'),
(137, 2, 'audit_created', 'audit', 4, NULL, NULL, 'Audit \'SMKP-22\' berhasil dibuat', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 08:46:37'),
(138, 2, 'elemen_created', 'elemen', 10, NULL, NULL, 'Elemen \'Kebijakan\' berhasil dibuat', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 08:47:19'),
(139, 2, 'sub_elemen_created', 'elemen', 54, NULL, NULL, 'Sub elemen \'Penyusunan Kebijakan\' berhasil dibuat', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 08:47:59'),
(140, 2, 'sub_sub_elemen_created', 'elemen', 64, NULL, NULL, 'Sub sub elemen \'Penyusunan Kebijakan Awal\' berhasil dibuat', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 08:48:23'),
(141, 2, 'sub_sub_elemen_updated', 'elemen', 64, NULL, NULL, 'Sub sub elemen \'Penyusunan Kebijakan Awal 2\' berhasil diupdate', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 08:48:43'),
(142, 2, 'sub_sub_elemen_updated', 'elemen', 64, NULL, NULL, 'Sub sub elemen \'Penyusunan Kebijakan Awal 2\' berhasil diupdate', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 08:50:06'),
(143, 2, 'sub_sub_elemen_updated', 'elemen', 64, NULL, NULL, 'Sub sub elemen \'Penyusunan Kebijakan Awal 2\' berhasil diupdate', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 08:50:23'),
(148, 1, 'create', 'jenis_berkas', 1, NULL, NULL, 'Membuat jenis berkas: Laporan A', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 15:25:44'),
(149, 1, 'create', 'sub_elemen_berkas', 1, NULL, NULL, 'Menambahkan requirement berkas untuk sub_elemen ID: 6', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 15:34:44'),
(150, 1, 'upload', 'upload_sub_elemen', 1, NULL, '{\"file_name\": \"01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx\", \"file_size\": 44484}', 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', NULL, NULL, '2025-08-09 15:55:01'),
(151, 1, 'upload', 'upload_sub_elemen', 1, NULL, NULL, 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 15:55:01'),
(152, 1, 'upload', 'upload_sub_elemen', 2, NULL, '{\"file_name\": \"01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx\", \"file_size\": 44484}', 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', NULL, NULL, '2025-08-09 15:55:15'),
(153, 1, 'upload', 'upload_sub_elemen', 2, NULL, NULL, 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 15:55:15'),
(154, 1, 'upload', 'upload_sub_elemen', 3, NULL, '{\"file_name\": \"01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx\", \"file_size\": 44484}', 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', NULL, NULL, '2025-08-09 15:55:27'),
(155, 1, 'upload', 'upload_sub_elemen', 3, NULL, NULL, 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 15:55:27'),
(156, 1, 'create', 'sub_elemen_berkas', 2, NULL, NULL, 'Menambahkan requirement berkas untuk sub_elemen ID: 3', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 16:20:04'),
(157, 1, 'create', 'sub_elemen_berkas', 3, NULL, NULL, 'Menambahkan requirement berkas untuk sub_elemen ID: 7', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 16:24:52'),
(158, 1, 'create', 'sub_sub_elemen_berkas', 1, NULL, NULL, 'Menambahkan requirement berkas untuk sub_sub_elemen ID: 17', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 16:30:09'),
(159, 1, 'upload', 'upload_sub_elemen', 4, NULL, '{\"file_name\": \"01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx\", \"file_size\": 44484}', 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', NULL, NULL, '2025-08-09 17:34:21'),
(160, 1, 'upload', 'upload_sub_elemen', 4, NULL, NULL, 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 17:34:21'),
(161, 1, 'upload', 'upload_sub_elemen', 5, NULL, '{\"file_name\": \"01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx\", \"file_size\": 44484}', 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', NULL, NULL, '2025-08-09 17:34:38'),
(162, 1, 'upload', 'upload_sub_elemen', 5, NULL, NULL, 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 17:34:38'),
(163, 1, 'upload', 'upload_sub_elemen', 6, NULL, '{\"file_name\": \"01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx\", \"file_size\": 44484}', 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', NULL, NULL, '2025-08-09 17:34:48'),
(164, 1, 'upload', 'upload_sub_elemen', 6, NULL, NULL, 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 17:34:48'),
(165, 1, 'upload', 'upload_sub_elemen', 7, NULL, '{\"file_name\": \"01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx\", \"file_size\": 44484}', 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', NULL, NULL, '2025-08-09 19:19:20'),
(166, 1, 'upload', 'upload_sub_elemen', 7, NULL, NULL, 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 19:19:20'),
(167, 1, 'upload', 'berkas_pendukung_sub_elemen', 1, NULL, '{\"file_name\": \"01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx\", \"file_size\": 44484}', 'Upload berkas pendukung: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', NULL, NULL, '2025-08-09 19:33:53'),
(168, 1, 'upload', 'berkas_pendukung_sub_elemen', 1, NULL, NULL, 'Upload berkas pendukung: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 19:33:53'),
(169, 1, 'create', 'jenis_berkas', 2, NULL, NULL, 'Membuat jenis berkas: Laporan AB', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-09 19:40:05'),
(170, 1, 'create', 'sub_elemen_berkas', 4, NULL, NULL, 'Menambahkan requirement berkas untuk sub_elemen ID: 13', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 00:48:06'),
(171, 1, 'upload', 'upload_sub_elemen', 8, NULL, '{\"file_name\": \"01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx\", \"file_size\": 44484}', 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', NULL, NULL, '2025-08-10 00:52:20'),
(172, 1, 'upload', 'upload_sub_elemen', 8, NULL, NULL, 'Upload berkas: 01. Scoresheet Audit SMKP KPP AGMR Des  2024_Update (2).xlsx', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 00:52:20'),
(173, 1, 'verify', 'upload_sub_elemen', 8, NULL, NULL, 'Verifikasi berkas: menyetujui', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 02:13:21'),
(174, 1, 'upload', 'berkas_pendukung_sub_elemen', 2, NULL, '{\"file_name\": \"Tambahkan subjudul.pdf\", \"file_size\": 38572}', 'Upload berkas pendukung: Tambahkan subjudul.pdf', NULL, NULL, '2025-08-10 02:14:42'),
(175, 1, 'upload', 'berkas_pendukung_sub_elemen', 2, NULL, NULL, 'Upload berkas pendukung: Tambahkan subjudul.pdf', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 02:14:42'),
(176, 1, 'create', 'sub_elemen_berkas', 7, NULL, NULL, 'Menambahkan requirement berkas untuk sub_elemen ID: 13', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 02:23:18'),
(177, 1, 'upload', 'upload_sub_elemen', 9, NULL, '{\"file_name\": \"Tambahkan subjudul.pdf\", \"file_size\": 38572}', 'Upload berkas: Tambahkan subjudul.pdf', NULL, NULL, '2025-08-10 02:23:53'),
(178, 1, 'upload', 'upload_sub_elemen', 9, NULL, NULL, 'Upload berkas: Tambahkan subjudul.pdf', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 02:23:53'),
(179, 1, 'verify', 'upload_sub_elemen', 9, NULL, NULL, 'Verifikasi berkas: menyetujui', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 02:57:37'),
(180, 1, 'create', 'sub_elemen_berkas', 15, NULL, NULL, 'Menambahkan requirement berkas untuk sub_elemen ID: 13', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 03:34:41'),
(181, 1, 'upload', 'upload_sub_elemen', 10, NULL, '{\"file_name\": \"Tambahkan subjudul.pdf\", \"file_size\": 38572}', 'Upload berkas: Tambahkan subjudul.pdf', NULL, NULL, '2025-08-10 03:34:57'),
(182, 1, 'upload', 'upload_sub_elemen', 10, NULL, NULL, 'Upload berkas: Tambahkan subjudul.pdf', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 03:34:57'),
(183, 1, 'create', 'jenis_berkas', 3, NULL, NULL, 'Membuat jenis berkas: Laporan ABC', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 05:07:32'),
(184, 1, 'create', 'jenis_berkas', 4, NULL, NULL, 'Membuat jenis berkas: Laporan ABCD', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 05:09:59'),
(185, 1, 'update', 'jenis_berkas', 1, NULL, NULL, 'Updated jenis berkas: Laporan Ahh', NULL, NULL, '2025-08-10 05:35:47');
INSERT INTO `activity_log` (`id`, `user_id`, `action`, `table_name`, `record_id`, `old_values`, `new_values`, `description`, `ip_address`, `user_agent`, `created_at`) VALUES
(186, 1, 'delete', 'jenis_berkas', 4, NULL, NULL, 'Deleted jenis berkas: Laporan ABCD', NULL, NULL, '2025-08-10 05:36:09'),
(187, 1, 'delete', 'jenis_berkas', 3, NULL, NULL, 'Deleted jenis berkas: Laporan ABC', NULL, NULL, '2025-08-10 05:36:13'),
(188, 1, 'user_created', 'users', 3, NULL, NULL, 'User \'departemen\' berhasil dibuat dengan role AuditSteeringCommittee', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 09:29:58'),
(189, 2, 'user_created', 'users', 4, NULL, NULL, 'User \'pegawai\' berhasil dibuat dengan role AuditCommittee', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 09:31:19'),
(190, 2, 'create', 'jenis_berkas', 5, NULL, NULL, 'Membuat jenis berkas: Berkas PDF dan Foto', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 09:55:20'),
(191, 2, 'create', 'sub_elemen_berkas', 16, NULL, NULL, 'Menambahkan requirement berkas untuk sub_elemen ID: 3', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 09:56:20'),
(192, 2, 'upload', 'upload_sub_elemen', 11, NULL, '{\"file_name\": \"Tambahkan subjudul.pdf\", \"file_size\": 38572}', 'Upload berkas: Tambahkan subjudul.pdf', NULL, NULL, '2025-08-10 09:57:02'),
(193, 2, 'upload', 'upload_sub_elemen', 11, NULL, NULL, 'Upload berkas: Tambahkan subjudul.pdf', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 09:57:02'),
(194, 2, 'verify', 'upload_sub_elemen', 11, NULL, NULL, 'Verifikasi berkas: menyetujui', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 09:58:06'),
(195, 2, 'create', 'sub_elemen_berkas', 17, NULL, NULL, 'Menambahkan requirement berkas untuk sub_elemen ID: 7', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 10:00:09'),
(196, 2, 'upload', 'upload_sub_elemen', 12, NULL, '{\"file_name\": \"Tambahkan subjudul.pdf\", \"file_size\": 38572}', 'Upload berkas: Tambahkan subjudul.pdf', NULL, NULL, '2025-08-10 10:00:54'),
(197, 2, 'upload', 'upload_sub_elemen', 12, NULL, NULL, 'Upload berkas: Tambahkan subjudul.pdf', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 10:00:54'),
(198, 3, 'create', 'sub_elemen_berkas', 18, NULL, NULL, 'Menambahkan requirement berkas untuk sub_elemen ID: 3', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 10:23:47'),
(199, 3, 'upload', 'upload_sub_elemen', 13, NULL, '{\"file_name\": \"Akta Pendirian 2019.pdf\", \"file_size\": 4851577}', 'Upload berkas: Akta Pendirian 2019.pdf', NULL, NULL, '2025-08-10 10:24:16'),
(200, 3, 'upload', 'upload_sub_elemen', 13, NULL, NULL, 'Upload berkas: Akta Pendirian 2019.pdf', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-10 10:24:16'),
(201, 2, 'verify', 'upload_sub_elemen', 13, NULL, NULL, 'Verifikasi berkas: menyetujui (final)', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 04:49:02'),
(203, 2, 'verify', 'upload_sub_elemen', 12, NULL, NULL, 'Verifikasi berkas: menyetujui (final)', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 07:06:37'),
(209, 2, 'audit_created', 'audit', 9, NULL, NULL, 'Audit \'SMKP KPP AGMR\' berhasil dibuat', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 08:27:21'),
(210, 2, 'audit_permanent_deleted', 'audit', 0, NULL, NULL, 'Audit \'SMKP KPP AGMR\' (ID: 8) dihapus permanen oleh Programmer', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 08:27:47'),
(211, 2, 'elemen_generated', 'audit', 9, NULL, NULL, 'Generate elemen dari audit \'ISO 45001\' ke audit \'SMKP KPP AGMR\': 7 elemen, 51 sub elemen, 62 sub sub elemen', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 08:29:47'),
(212, 2, 'audit_permanent_deleted', 'audit', 0, NULL, NULL, 'Audit \'ISO 14001\' (ID: 6) dihapus permanen oleh Programmer', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 08:30:13'),
(213, 2, 'audit_permanent_deleted', 'audit', 0, NULL, NULL, 'Audit \'ISO 45001\' (ID: 5) dihapus permanen oleh Programmer', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 08:30:22'),
(214, 2, 'elemen_updated', 'elemen', 32, NULL, NULL, 'Elemen \'KEBIJAKANS\' berhasil diupdate', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 08:45:11'),
(215, 2, 'elemen_updated', 'elemen', 32, NULL, NULL, 'Elemen \'KEBIJAKAN\' berhasil diupdate', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 08:45:16'),
(216, 2, 'audit_created', 'audit', 10, NULL, NULL, 'Audit \'ISO 45001\' berhasil dibuat', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 08:49:08'),
(217, 2, 'ai_session_started', 'ai_learning_sessions', 6, NULL, NULL, 'AI learning session dimulai', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 09:03:38'),
(218, 2, 'ai_session_ended', 'ai_learning_sessions', 6, NULL, NULL, 'AI learning session diakhiri', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 09:21:41'),
(219, 2, 'ai_session_started', 'ai_learning_sessions', 9, NULL, NULL, 'AI learning session dimulai', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 09:56:41'),
(220, 2, 'ai_session_started', 'ai_learning_sessions', 77, NULL, NULL, 'AI learning session dimulai', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 11:37:22'),
(221, 2, 'ai_session_started', 'ai_learning_sessions', 78, NULL, NULL, 'AI learning session dimulai', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 11:38:58'),
(222, 2, 'ai_session_started', 'ai_learning_sessions', 79, NULL, NULL, 'AI learning session dimulai', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 11:43:49'),
(223, 2, 'ai_session_ended', 'ai_learning_sessions', 79, NULL, NULL, 'AI learning session diakhiri', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 11:44:10'),
(224, 2, 'ai_session_started', 'ai_learning_sessions', 80, NULL, NULL, 'AI learning session dimulai', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 11:44:11'),
(225, 2, 'ai_session_started', 'ai_learning_sessions', 81, NULL, NULL, 'AI learning session dimulai', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 11:45:40'),
(226, 2, 'ai_session_started', 'ai_learning_sessions', 82, NULL, NULL, 'AI learning session dimulai', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 12:20:58'),
(227, 2, 'ai_session_started', 'ai_learning_sessions', 84, NULL, NULL, 'AI learning session dimulai', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-11 12:33:20'),
(228, 2, 'create', 'sub_elemen_berkas', 19, NULL, NULL, 'Menambahkan requirement berkas untuk sub_elemen ID: 208', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-12 02:45:39'),
(229, 2, 'upload', 'upload_sub_elemen', 14, NULL, '{\"file_name\": \"Tambahkan subjudul.pdf\", \"file_size\": 38572}', 'Upload berkas: Tambahkan subjudul.pdf', NULL, NULL, '2025-08-12 02:46:04'),
(230, 2, 'upload', 'upload_sub_elemen', 14, NULL, NULL, 'Upload berkas: Tambahkan subjudul.pdf', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-12 02:46:04'),
(231, 2, 'create', 'sub_elemen_berkas', 20, NULL, NULL, 'Menambahkan requirement berkas untuk sub_elemen ID: 208', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-12 02:46:32'),
(232, 2, 'upload', 'upload_sub_elemen', 15, NULL, '{\"file_name\": \"Tambahkan subjudul.pdf\", \"file_size\": 38572}', 'Upload berkas: Tambahkan subjudul.pdf', NULL, NULL, '2025-08-12 02:46:41'),
(233, 2, 'upload', 'upload_sub_elemen', 15, NULL, NULL, 'Upload berkas: Tambahkan subjudul.pdf', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-12 02:46:41'),
(234, 2, 'create', 'sub_elemen_berkas', 21, NULL, NULL, 'Menambahkan requirement berkas untuk sub_elemen ID: 208', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-12 04:10:59'),
(235, 2, 'upload', 'upload_sub_elemen', 16, NULL, '{\"file_name\": \"Tambahkan subjudul.pdf\", \"file_size\": 38572}', 'Upload berkas: Tambahkan subjudul.pdf', NULL, NULL, '2025-08-12 04:11:08'),
(236, 2, 'upload', 'upload_sub_elemen', 16, NULL, NULL, 'Upload berkas: Tambahkan subjudul.pdf', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-12 04:11:08'),
(237, 2, 'verify', 'upload_sub_elemen', 16, NULL, NULL, 'Verifikasi berkas: menolak', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-12 04:11:37'),
(240, 2, 'ai_session_started', 'ai_learning_sessions', 86, NULL, NULL, 'AI learning session dimulai', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-12 12:21:19'),
(246, 1, 'departemen_updated', 'departemen', 2, NULL, NULL, 'Departemen berhasil diupdate', '36.75.67.219', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-13 06:43:30'),
(247, 1, 'departemen_updated', 'departemen', 1, NULL, NULL, 'Departemen berhasil diupdate', '36.75.67.219', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-13 06:44:00'),
(248, 1, 'departemen_updated', 'departemen', 1, NULL, NULL, 'Departemen berhasil diupdate', '36.75.67.219', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-13 06:45:28'),
(249, 1, 'departemen_updated', 'departemen', 3, NULL, NULL, 'Departemen berhasil diupdate', '36.75.67.219', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-13 06:46:22'),
(250, 1, 'departemen_updated', 'departemen', 3, NULL, NULL, 'Departemen berhasil diupdate', '36.75.67.219', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-13 06:49:36'),
(251, 1, 'departemen_updated', 'departemen', 4, NULL, NULL, 'Departemen berhasil diupdate', '36.75.67.219', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-13 06:50:21'),
(252, 1, 'departemen_updated', 'departemen', 1, NULL, NULL, 'Departemen berhasil diupdate', '36.75.67.219', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-13 06:52:24'),
(253, 1, 'departemen_created', 'departemen', 6, NULL, NULL, 'Departemen \'SAFETY HEALTH ENVIRONMENT\' berhasil dibuat', '36.75.67.219', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-13 06:53:57'),
(254, 1, 'departemen_updated', 'departemen', 1, NULL, NULL, 'Departemen berhasil diupdate', '36.75.67.219', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-13 06:55:08'),
(255, 1, 'departemen_updated', 'departemen', 1, NULL, NULL, 'Departemen berhasil diupdate', '36.75.67.219', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', '2025-08-13 06:55:41'),
(256, 2, 'update_audit_access', 'audit', 10, NULL, NULL, 'Updated access for audit ID: 10 to terbatas', '140.213.10.51', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-14 03:43:16'),
(257, 2, 'update_audit_access', 'audit', 10, NULL, NULL, 'Updated access for audit ID: 10 to umum', '140.213.10.51', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-14 03:43:23'),
(258, 2, 'upload', 'upload_sub_elemen', 17, NULL, '{\"file_name\": \"Tambahkan subjudul.pdf\", \"file_size\": 38572}', 'Upload berkas: Tambahkan subjudul.pdf', NULL, NULL, '2025-08-14 04:04:00'),
(259, 2, 'reupload', 'upload_sub_elemen', 17, NULL, NULL, 'Upload ulang berkas yang ditolak: Tambahkan subjudul.pdf (menggantikan upload ID: 16)', '140.213.10.51', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-14 04:04:00'),
(260, 2, 'audit_created', 'audit', 11, NULL, NULL, 'Audit \'SMKP KPP AGMR\' berhasil dibuat', '140.213.10.51', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-14 04:16:08'),
(261, 2, 'update_audit_access', 'audit', 11, NULL, NULL, 'Updated access for audit ID: 11 to terbatas', '140.213.10.51', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-14 04:16:46'),
(262, 2, 'update_audit_access', 'audit', 11, NULL, NULL, 'Updated access for audit ID: 11 to umum', '140.213.10.51', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-14 04:16:58'),
(263, 2, 'audit_completed', 'audit', 9, NULL, NULL, 'Audit \'SMKP KPP AGMR\' telah diselesaikan', '140.213.10.51', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-14 04:23:19'),
(264, 2, 'elemen_generated', 'audit', 11, NULL, NULL, 'Generate elemen dari audit \'SMKP KPP AGMR\' ke audit \'SMKP KPP AGMR\': 7 elemen, 51 sub elemen, 62 sub sub elemen', '140.213.10.51', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-14 04:24:16'),
(265, 2, 'ai_session_started', 'ai_learning_sessions', 88, NULL, NULL, 'AI learning session dimulai', '140.213.10.51', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-14 04:36:04'),
(266, 2, 'ai_session_started', 'ai_learning_sessions', 89, NULL, NULL, 'AI learning session dimulai', '140.213.10.51', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-14 04:36:15'),
(267, 2, 'audit_updated', 'audit', 11, NULL, NULL, 'Audit berhasil diupdate', '140.213.10.51', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-14 07:07:30'),
(268, 2, 'audit_status_changed', 'audit', 11, NULL, NULL, 'Audit \'SMKP AGMR\' berhasil dinonaktifkan', '140.213.10.49', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-15 05:53:58'),
(269, 2, 'audit_status_changed', 'audit', 11, NULL, NULL, 'Audit \'SMKP AGMR\' berhasil diaktifkan', '140.213.10.49', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-15 05:54:03'),
(270, 2, 'audit_updated', 'audit', 11, NULL, NULL, 'Audit berhasil diupdate', '103.129.151.93', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-15 12:20:57'),
(271, 2, 'create', 'sub_elemen_berkas', 22, NULL, NULL, 'Menambahkan requirement berkas untuk sub_elemen ID: 259', '103.129.151.93', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-15 12:35:49'),
(272, 2, 'upload', 'upload_sub_elemen', 18, NULL, '{\"file_name\": \"Tambahkan subjudul.pdf\", \"file_size\": 38572}', 'Upload berkas: Tambahkan subjudul.pdf', NULL, NULL, '2025-08-15 12:36:05'),
(273, 2, 'upload', 'upload_sub_elemen', 18, NULL, NULL, 'Upload berkas: Tambahkan subjudul.pdf', '103.129.151.93', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-15 12:36:05'),
(274, 1, 'audit_updated', 'audit', 11, NULL, NULL, 'Audit berhasil diupdate', '114.10.143.1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-15 13:16:04'),
(275, 1, 'update_audit_access', 'audit', 11, NULL, NULL, 'Updated access for audit ID: 11 to terbatas', '114.10.143.1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-15 13:23:32'),
(276, 1, 'audit_deleted', 'audit', 10, NULL, NULL, 'Audit \'ISO 45001\' berhasil dihapus', '114.10.143.58', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-15 20:56:06'),
(277, 1, 'user_updated', 'users', 4, NULL, NULL, 'User berhasil diupdate', '114.10.143.37', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 04:33:37'),
(278, 1, 'user_updated', 'users', 1, NULL, NULL, 'User berhasil diupdate', '114.10.143.37', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 04:33:57'),
(279, 1, 'ai_session_started', 'ai_learning_sessions', 91, NULL, NULL, 'AI learning session dimulai', '114.10.143.37', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-18 04:38:05'),
(280, 2, 'user_deleted', 'users', 4, NULL, NULL, 'Pengguna \'pegawai\' berhasil dihapus', '103.129.151.93', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 12:32:25'),
(281, 1, 'user_updated', 'users', 1, NULL, NULL, 'Pengguna berhasil diupdate', '114.10.143.50', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-19 12:37:49'),
(282, 1, 'audit_updated', 'audit', 11, NULL, NULL, 'Audit berhasil diupdate', '114.10.143.29', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 00:36:40'),
(283, 1, 'sub_elemen_updated', 'elemen', 265, NULL, NULL, 'Sub elemen \'Manajemen Risiko\' berhasil diupdate', '114.10.143.57', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 03:34:44'),
(284, 1, 'sub_elemen_updated', 'elemen', 265, NULL, NULL, 'Sub elemen \'Manajemen Risiko\' berhasil diupdate', '114.10.143.57', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 03:35:56'),
(285, 1, 'sub_sub_elemen_updated', 'elemen', 313, NULL, NULL, 'Sub sub elemen \'Komunikasi dan konsultasi risiko\' berhasil diupdate', '114.10.143.57', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 03:41:32'),
(286, 1, 'sub_sub_elemen_updated', 'elemen', 313, NULL, NULL, 'Sub sub elemen \'Komunikasi dan konsultasi risiko\' berhasil diupdate', '114.10.143.57', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 03:42:38'),
(287, 1, 'sub_elemen_updated', 'elemen', 264, NULL, NULL, 'Sub elemen \'Penelaahan Awal\' berhasil diupdate', '125.161.125.69', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 05:20:15'),
(288, 1, 'sub_elemen_updated', 'elemen', 264, NULL, NULL, 'Sub elemen \'Penelaahan Awal\' berhasil diupdate', '180.241.188.5', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 05:23:15'),
(289, 1, 'sub_sub_elemen_updated', 'elemen', 314, NULL, NULL, 'Sub sub elemen \'Penetapan konteks risiko\' berhasil diupdate', '180.241.188.5', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 05:33:49'),
(290, 1, 'update_audit_access', 'audit', 11, NULL, NULL, 'Updated access for audit ID: 11 to umum', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 05:49:37'),
(291, 1, 'sub_sub_elemen_updated', 'elemen', 315, NULL, NULL, 'Sub sub elemen \'Identifikasi bahaya\' berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 05:56:20'),
(292, 1, 'sub_sub_elemen_updated', 'elemen', 316, NULL, NULL, 'Sub sub elemen \'Penilaian dan pengendalian risiko		\' berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 06:04:21'),
(293, 1, 'sub_sub_elemen_updated', 'elemen', 317, NULL, NULL, 'Sub sub elemen \'Pemantauan dan peninjauan\' berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 06:17:51'),
(294, 1, 'sub_sub_elemen_updated', 'elemen', 317, NULL, NULL, 'Sub sub elemen \'Pemantauan dan peninjauan\' berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 06:44:34'),
(295, 2, 'user_created', 'users', 5, NULL, NULL, 'Pengguna \'pegawai\' berhasil dibuat dengan role AuditCommittee', '140.213.10.30', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:01:49'),
(296, 2, 'user_deleted', 'users', 5, NULL, NULL, 'Pengguna \'pegawai\' berhasil dihapus', '140.213.10.30', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:02:28'),
(297, 1, 'user_updated', 'users', 1, NULL, NULL, 'Pengguna berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:08:35'),
(298, 1, 'user_updated', 'users', 1, NULL, NULL, 'Pengguna berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:11:06'),
(299, 1, 'user_created', 'users', 6, NULL, NULL, 'Pengguna \'Tsana Febiska Alivy\' berhasil dibuat dengan role AuditCommittee', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:11:49'),
(300, 1, 'sub_elemen_updated', 'elemen', 266, NULL, NULL, 'Sub elemen \'Identifikasi dan Kepatuhan Terhadap Ketentuan Peraturan Perundang-undangan dan Persyaratan Lainnya yang Terkait\' berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:25:16'),
(301, 1, 'sub_elemen_updated', 'elemen', 266, NULL, NULL, 'Sub elemen \'Identifikasi dan Kepatuhan Terhadap Ketentuan Peraturan Perundang-undangan dan Persyaratan Lainnya yang Terkait\' berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:30:46'),
(302, 1, 'sub_elemen_updated', 'elemen', 267, NULL, NULL, 'Sub elemen \'Penetapan Tujuan, Sasaran, dan Program\' berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:36:17'),
(303, 1, 'sub_elemen_updated', 'elemen', 267, NULL, NULL, 'Sub elemen \'Penetapan Tujuan, Sasaran, dan Program\' berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:40:39'),
(304, 1, 'sub_elemen_updated', 'elemen', 268, NULL, NULL, 'Sub elemen \'Rencana Kerja dan Anggaran Keselamatan Pertambangan\' berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:42:30'),
(305, 1, 'sub_elemen_updated', 'elemen', 268, NULL, NULL, 'Sub elemen \'Rencana Kerja dan Anggaran Keselamatan Pertambangan\' berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:47:26'),
(306, 1, 'sub_elemen_updated', 'elemen', 268, NULL, NULL, 'Sub elemen \'Rencana Kerja dan Anggaran Keselamatan Pertambangan\' berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 07:56:40'),
(307, 1, 'sub_elemen_updated', 'elemen', 268, NULL, NULL, 'Sub elemen \'Rencana Kerja dan Anggaran Keselamatan Pertambangan\' berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 08:00:12'),
(308, 1, 'sub_elemen_updated', 'elemen', 297, NULL, NULL, 'Sub elemen \'Evaluasi Pengelolaan Administrasi Keselamatan Pertambangan\' berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 08:35:38'),
(309, 1, 'sub_sub_elemen_updated', 'elemen', 370, NULL, NULL, 'Sub sub elemen \'Buku tambang\' berhasil diupdate', '180.241.180.53', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-20 08:36:23'),
(310, 1, 'sub_sub_elemen_updated', 'elemen', 318, NULL, NULL, 'Sub sub elemen \'Penunjukan KTT\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:06:35'),
(311, 1, 'sub_sub_elemen_updated', 'elemen', 319, NULL, NULL, 'Sub sub elemen \'Penunjukan Kepala Tambang Bawah Tanah\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:06:45'),
(312, 1, 'sub_sub_elemen_updated', 'elemen', 320, NULL, NULL, 'Sub sub elemen \'Penunjukan Kepala Kapal Keruk\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:06:52'),
(313, 1, 'sub_sub_elemen_updated', 'elemen', 318, NULL, NULL, 'Sub sub elemen \'Penunjukan KTT\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:07:08'),
(314, 1, 'sub_sub_elemen_updated', 'elemen', 318, NULL, NULL, 'Sub sub elemen \'Penunjukan KTT\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:07:49'),
(315, 1, 'elemen_updated', 'elemen', 39, NULL, NULL, 'Elemen \'KEBIJAKAN\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:12:04'),
(316, 1, 'elemen_updated', 'elemen', 39, NULL, NULL, 'Elemen \'KEBIJAKAN\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:12:14'),
(317, 1, 'sub_elemen_updated', 'elemen', 259, NULL, NULL, 'Sub elemen \'Penyusunan Kebijakan\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:18:06'),
(318, 1, 'sub_elemen_updated', 'elemen', 260, NULL, NULL, 'Sub elemen \'lsi  Kebiiakan\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:30:19'),
(319, 1, 'sub_elemen_updated', 'elemen', 260, NULL, NULL, 'Sub elemen \'lsi  Kebiiakan\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:31:42'),
(320, 1, 'sub_elemen_updated', 'elemen', 261, NULL, NULL, 'Sub elemen \'Penetapan Kebijakan\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:33:30'),
(321, 1, 'sub_elemen_updated', 'elemen', 262, NULL, NULL, 'Sub elemen \'Komunikasi Kebijakan\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:36:29'),
(322, 1, 'sub_elemen_updated', 'elemen', 263, NULL, NULL, 'Sub elemen \'Tinjauan Kebijakan\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:39:27'),
(323, 1, 'elemen_updated', 'elemen', 41, NULL, NULL, 'Elemen \'ORGANISASI DAN PERSONEL\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:42:22'),
(324, 1, 'elemen_updated', 'elemen', 41, NULL, NULL, 'Elemen \'ORGANISASI DAN PERSONEL\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:51:04'),
(325, 1, 'elemen_updated', 'elemen', 41, NULL, NULL, 'Elemen \'ORGANISASI DAN PERSONEL\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:55:08'),
(326, 1, 'elemen_updated', 'elemen', 41, NULL, NULL, 'Elemen \'ORGANISASI DAN PERSONEL\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 09:59:11'),
(327, 1, 'elemen_updated', 'elemen', 41, NULL, NULL, 'Elemen \'ORGANISASI DAN PERSONEL\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 10:00:35'),
(328, 1, 'sub_elemen_updated', 'elemen', 269, NULL, NULL, 'Sub elemen \'Penyusunan dan Penetapan Struktur Organisasi, Tugas, Tanggung Jawab, dan Wewenang\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 10:04:54'),
(329, 1, 'sub_elemen_updated', 'elemen', 269, NULL, NULL, 'Sub elemen \'Penyusunan dan Penetapan Struktur Organisasi, Tugas, Tanggung Jawab, dan Wewenang\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 10:07:40'),
(330, 1, 'sub_elemen_updated', 'elemen', 271, NULL, NULL, 'Sub elemen \'Penunjukan PJO Untuk Perusahaan Jasa Pertambangan\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 10:15:38'),
(331, 1, 'sub_elemen_updated', 'elemen', 271, NULL, NULL, 'Sub elemen \'Penunjukan PJO Untuk Perusahaan Jasa Pertambangan\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 10:16:16'),
(332, 1, 'sub_elemen_updated', 'elemen', 271, NULL, NULL, 'Sub elemen \'Penunjukan PJO Untuk Perusahaan Jasa Pertambangan\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 10:16:54'),
(333, 1, 'sub_elemen_updated', 'elemen', 272, NULL, NULL, 'Sub elemen \'Pembentukan dan Penetapan Bagian K3 Pertambangan dan KO Pertambangan\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 10:20:29'),
(334, 1, 'sub_elemen_updated', 'elemen', 272, NULL, NULL, 'Sub elemen \'Pembentukan dan Penetapan Bagian K3 Pertambangan dan KO Pertambangan\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 10:22:59'),
(335, 2, 'sub_sub_elemen_updated', 'elemen', 320, NULL, NULL, 'Sub sub elemen \'Penunjukan Kepala Kapal Keruk\' berhasil diupdate', '103.129.151.93', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 11:08:01'),
(336, 2, 'sub_sub_elemen_updated', 'elemen', 319, NULL, NULL, 'Sub sub elemen \'Penunjukan Kepala Tambang Bawah Tanah\' berhasil diupdate', '103.129.151.93', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 11:08:13'),
(337, 2, 'sub_sub_elemen_updated', 'elemen', 318, NULL, NULL, 'Sub sub elemen \'Penunjukan KTT\' berhasil diupdate', '103.129.151.93', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 11:08:21'),
(338, 1, 'sub_sub_elemen_updated', 'elemen', 356, NULL, NULL, 'Sub sub elemen \'Gudang bahan peledak\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 11:50:42'),
(339, 1, 'sub_sub_elemen_updated', 'elemen', 356, NULL, NULL, 'Sub sub elemen \'Gudang bahan peledak\' berhasil diupdate', '114.10.142.148', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 11:55:59'),
(340, 9, 'sub_sub_elemen_updated', 'elemen', 356, NULL, NULL, 'Sub sub elemen \'Gudang bahan peledak\' berhasil diupdate', '2001:448a:60c0:8e29:bc58:230c:1dcd:8333', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 13:00:18'),
(341, 9, 'sub_sub_elemen_updated', 'elemen', 356, NULL, NULL, 'Sub sub elemen \'Gudang bahan peledak\' berhasil diupdate', '2001:448a:60c0:8e29:bc58:230c:1dcd:8333', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-24 13:03:52'),
(342, 9, 'sub_sub_elemen_updated', 'elemen', 357, NULL, NULL, 'Sub sub elemen \'Penyimpanan bahan peledak\' berhasil diupdate', '140.213.10.30', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-25 01:38:25'),
(343, 9, 'sub_sub_elemen_updated', 'elemen', 357, NULL, NULL, 'Sub sub elemen \'Penyimpanan bahan peledak\' berhasil diupdate', '140.213.10.30', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-25 01:38:39'),
(344, 1, 'sub_sub_elemen_updated', 'elemen', 356, NULL, NULL, 'Sub sub elemen \'Gudang bahan peledak\' berhasil diupdate', '114.10.142.143', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 08:34:36'),
(345, 1, 'sub_sub_elemen_updated', 'elemen', 357, NULL, NULL, 'Sub sub elemen \'Penyimpanan bahan peledak\' berhasil diupdate', '114.10.142.143', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 08:34:50'),
(346, 1, 'sub_sub_elemen_updated', 'elemen', 356, NULL, NULL, 'Sub sub elemen \'Gudang bahan peledak\' berhasil diupdate', '114.10.142.143', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 08:35:05'),
(347, 1, 'elemen_updated', 'elemen', 40, NULL, NULL, 'Elemen \'PERENCANAAN\' berhasil diupdate', '114.10.142.143', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 08:40:17'),
(348, 1, 'sub_elemen_updated', 'elemen', 273, NULL, NULL, 'Sub elemen \'Penunjukan Pengawas Operasional dan Pengawas Teknik\' berhasil diupdate', '114.10.142.143', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 08:46:56'),
(349, 1, 'sub_elemen_updated', 'elemen', 274, NULL, NULL, 'Sub elemen \'Penunjukan Tenaga Teknik Khusus Pertambangan\' berhasil diupdate', '114.10.142.143', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 08:51:25'),
(350, 1, 'sub_elemen_updated', 'elemen', 275, NULL, NULL, 'Sub elemen \'Pembentukan dan Penetapan Komite Keselamatan Pertambangan\' berhasil diupdate', '114.10.142.143', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 08:55:46'),
(351, 1, 'sub_elemen_updated', 'elemen', 275, NULL, NULL, 'Sub elemen \'Pembentukan dan Penetapan Komite Keselamatan Pertambangan\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 08:57:58'),
(352, 1, 'sub_elemen_updated', 'elemen', 276, NULL, NULL, 'Sub elemen \'Penunjukan Tim Tanggap Darurat\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 09:02:28'),
(353, 1, 'sub_elemen_updated', 'elemen', 276, NULL, NULL, 'Sub elemen \'Penunjukan Tim Tanggap Darurat\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 09:04:39'),
(354, 1, 'sub_elemen_updated', 'elemen', 277, NULL, NULL, 'Sub elemen \'Seleksi dan Penempatan Personel\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 09:07:20'),
(355, 1, 'sub_sub_elemen_updated', 'elemen', 321, NULL, NULL, 'Sub sub elemen \'III.10.1 Pendidikan dan Pelatihan Pekerja Tambang\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 09:10:59'),
(356, 1, 'sub_sub_elemen_updated', 'elemen', 321, NULL, NULL, 'Sub sub elemen \'III.10.1 Pendidikan dan Pelatihan Pekerja Tambang\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 09:13:06'),
(357, 1, 'sub_elemen_updated', 'elemen', 278, NULL, NULL, 'Sub elemen \'Penyelenggaraan dan Pelaksanaan Pendidikan dan Pelatihan Serta Kompetensi Kerja\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 09:14:44'),
(358, 1, 'sub_elemen_updated', 'elemen', 278, NULL, NULL, 'Sub elemen \'Penyelenggaraan dan Pelaksanaan Pendidikan dan Pelatihan Serta Kompetensi Kerja\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 09:17:30'),
(359, 1, 'sub_sub_elemen_updated', 'elemen', 321, NULL, NULL, 'Sub sub elemen \'III.10.1 Pendidikan dan Pelatihan Pekerja Tambang\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 09:31:21'),
(360, 1, 'sub_sub_elemen_updated', 'elemen', 321, NULL, NULL, 'Sub sub elemen \'Pendidikan dan Pelatihan Pekerja Tambang\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 09:32:51'),
(361, 1, 'sub_elemen_updated', 'elemen', 280, NULL, NULL, 'Sub elemen \'Pengelolaan Administrasi Keselamatan Pertambangan\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 10:07:09'),
(362, 1, 'sub_sub_elemen_deleted', 'elemen', 323, NULL, NULL, 'Sub sub elemen \'Buku tambang\' dihapus', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 10:10:33'),
(363, 1, 'sub_sub_elemen_deleted', 'elemen', 324, NULL, NULL, 'Sub sub elemen \'Buku daftar kecelakaan tambang\' dihapus', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 10:10:50'),
(364, 1, 'sub_elemen_updated', 'elemen', 280, NULL, NULL, 'Sub elemen \'Pengelolaan Administrasi Keselamatan Pertambangan\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 10:21:16'),
(365, 1, 'sub_elemen_updated', 'elemen', 281, NULL, NULL, 'Sub elemen \'Penyusunan, Penerapan, dan Pendokumentasian Prosedur Partisipasi, Konsultasi, Motivasi, dan Kesadaran Penerapan SMKP Minerba\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 10:22:41'),
(366, 1, 'sub_elemen_updated', 'elemen', 282, NULL, NULL, 'Sub elemen \'Pelaksanaan Pengelolaan Operasional\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 10:27:47'),
(367, 1, 'sub_elemen_updated', 'elemen', 282, NULL, NULL, 'Sub elemen \'Pelaksanaan Pengelolaan Operasional\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 10:37:20'),
(368, 1, 'sub_sub_elemen_updated', 'elemen', 328, NULL, NULL, 'Sub sub elemen \'Penyusunan, Penetapan, Penerapan, Pendokumentasian, dan Evaluasi Prosedur Operasi / Kerja\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 10:37:36'),
(369, 1, 'sub_sub_elemen_updated', 'elemen', 329, NULL, NULL, 'Sub sub elemen \'Penyusunan, Penetapan, Penerapan, Pendokumentasian, dan Evaluasi Izin kerja khusus\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 10:38:34'),
(370, 1, 'sub_sub_elemen_updated', 'elemen', 330, NULL, NULL, 'Sub sub elemen \'Penyusunan, Penetapan, Penerapan, Pendokumentasian, dan Evaluasi Prosedur Operasi / Kerja Alat pelindung diri dan alat keselamatan\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 10:40:21'),
(371, 1, 'sub_elemen_updated', 'elemen', 283, NULL, NULL, 'Sub elemen \'Pelaksanaan Pengelolaan Lingkungan Kerja\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 10:49:20'),
(372, 1, 'sub_elemen_updated', 'elemen', 284, NULL, NULL, 'Sub elemen \'Pelaksanaan Pengelolaan Kesehatan Kerja\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 10:53:56'),
(373, 1, 'sub_sub_elemen_updated', 'elemen', 342, NULL, NULL, 'Sub sub elemen \'Pelayanan Kesehatan Kerja\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 10:58:24'),
(374, 1, 'sub_sub_elemen_updated', 'elemen', 342, NULL, NULL, 'Sub sub elemen \'Pelayanan Kesehatan Kerja\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:04:09'),
(375, 1, 'sub_sub_elemen_updated', 'elemen', 342, NULL, NULL, 'Sub sub elemen \'Pelayanan Kesehatan Kerja\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:05:45'),
(376, 1, 'sub_sub_elemen_updated', 'elemen', 341, NULL, NULL, 'Sub sub elemen \'Pemeriksaan Kesehatan\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:06:08'),
(377, 1, 'sub_sub_elemen_updated', 'elemen', 342, NULL, NULL, 'Sub sub elemen \'Pelayanan Kesehatan Kerja\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:06:40'),
(378, 1, 'sub_sub_elemen_updated', 'elemen', 343, NULL, NULL, 'Sub sub elemen \'Pertolongan Pertama pada Kecelakaan\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:10:25'),
(379, 1, 'sub_sub_elemen_updated', 'elemen', 344, NULL, NULL, 'Sub sub elemen \'Pengelolaan Kelelahan Kerja (Fatigue)\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:11:56'),
(380, 1, 'sub_sub_elemen_updated', 'elemen', 345, NULL, NULL, 'Sub sub elemen \'Pengelolaan Pekerja pada Tempat yang Memiliki Risiko Kesehatan Tinggi\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:12:54'),
(381, 1, 'sub_sub_elemen_updated', 'elemen', 346, NULL, NULL, 'Sub sub elemen \'Pengelolaan Rekaman Data Kesehatan Kerja\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:15:38');
INSERT INTO `activity_log` (`id`, `user_id`, `action`, `table_name`, `record_id`, `old_values`, `new_values`, `description`, `ip_address`, `user_agent`, `created_at`) VALUES
(382, 1, 'sub_sub_elemen_updated', 'elemen', 347, NULL, NULL, 'Sub sub elemen \'Pengelolaan Higiene dan Sanitasi\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:21:50'),
(383, 1, 'sub_sub_elemen_updated', 'elemen', 348, NULL, NULL, 'Sub sub elemen \'Pengelolaan Ergonomi\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:22:40'),
(384, 1, 'sub_sub_elemen_updated', 'elemen', 349, NULL, NULL, 'Sub sub elemen \'Pengelolaan Makanan, Minuman dan Gizi Pekerja\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:24:19'),
(385, 1, 'sub_sub_elemen_updated', 'elemen', 350, NULL, NULL, 'Sub sub elemen \'Diagnosis dan Pemeriksaan Penyakit Akibat Kerja\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:27:28'),
(386, 1, 'sub_elemen_updated', 'elemen', 285, NULL, NULL, 'Sub elemen \'Pelaksanaan Pengelolaan KO Pertambangan\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:29:56'),
(387, 1, 'sub_sub_elemen_updated', 'elemen', 351, NULL, NULL, 'Sub sub elemen \'Sistem dan pelaksanaan pemeliharaan / perawatan sarana, prasarana, instalasi, dan peralatan pertambangan\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:31:49'),
(388, 1, 'sub_sub_elemen_updated', 'elemen', 352, NULL, NULL, 'Sub sub elemen \'Pengamanan instalasi\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:32:41'),
(389, 1, 'sub_sub_elemen_updated', 'elemen', 353, NULL, NULL, 'Sub sub elemen \'Kelayakan sarana, prasarana, instalasi, dan peralatan pertambangan\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:34:00'),
(390, 1, 'sub_sub_elemen_updated', 'elemen', 354, NULL, NULL, 'Sub sub elemen \'Kompetensi tenaga teknik\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:37:56'),
(391, 1, 'sub_sub_elemen_updated', 'elemen', 355, NULL, NULL, 'Sub sub elemen \'Evaluasi Laporan Hasil Kajian Teknis Pertambangan\' berhasil diupdate', '114.10.142.139', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:39:09'),
(392, 1, 'ai_session_started', 'ai_learning_sessions', 94, NULL, NULL, 'AI learning session dimulai', '103.206.240.18', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', '2025-09-17 09:14:28'),
(393, 1, 'user_deleted', 'users', 9, NULL, NULL, 'Pengguna \'SuperAdmin\' berhasil dihapus', '103.206.240.18', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', '2025-09-17 09:18:49'),
(394, 1, 'ai_session_started', 'ai_learning_sessions', 95, NULL, NULL, 'AI learning session dimulai', '103.206.240.18', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', '2025-10-08 23:40:12'),
(395, 1, 'ai_session_started', 'ai_learning_sessions', 96, NULL, NULL, 'AI learning session dimulai', '114.10.142.155', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', '2025-11-02 11:04:56'),
(396, 1, 'audit_updated', 'audit', 11, NULL, NULL, 'Audit berhasil diupdate', '114.10.142.155', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', '2025-11-02 11:45:39'),
(397, 2, 'ai_session_started', 'ai_learning_sessions', 98, NULL, NULL, 'AI learning session dimulai', '182.8.130.0', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', '2025-11-03 00:50:09'),
(398, 1, 'ai_session_started', 'ai_learning_sessions', 100, NULL, NULL, 'AI learning session dimulai', '103.206.240.18', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', '2025-11-03 04:54:30'),
(399, 1, 'ai_session_started', 'ai_learning_sessions', 102, NULL, NULL, 'AI learning session dimulai', '103.206.240.18', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36', '2025-11-03 05:15:11');

-- --------------------------------------------------------

--
-- Struktur dari tabel `ai_chat_messages`
--

CREATE TABLE `ai_chat_messages` (
  `id` int(11) NOT NULL,
  `session_id` varchar(100) NOT NULL,
  `message` text NOT NULL,
  `is_user` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1=user message, 0=AI response',
  `processing_time_ms` int(11) DEFAULT NULL,
  `api_key_used` varchar(100) DEFAULT NULL,
  `error_message` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `ai_chat_messages`
--

INSERT INTO `ai_chat_messages` (`id`, `session_id`, `message`, `is_user`, `processing_time_ms`, `api_key_used`, `error_message`, `created_at`) VALUES
(1, '86', 'Tampilkan daftar audit yang tersedia', 1, NULL, NULL, NULL, '2025-08-12 12:21:25'),
(2, '86', 'Berikut daftar audit yang tersedia untuk peran Anda:\n\n*   **SMKP KPP AGMR (2024 - tahunan)**: Audit Sistem Manajemen Keselamatan Pertambangan.', 0, 3785, '1', NULL, '2025-08-12 12:21:25'),
(3, '89', 'Saya ingin mempelajari audit ISO 9001', 1, NULL, NULL, NULL, '2025-08-14 04:36:20'),
(4, '89', 'Mohon maaf, audit ISO 9001 belum tersedia dalam daftar audit kami saat ini.\n\nAudit yang tersedia adalah:\n*   SMKP KPP AGMR (2024 - tahunan)\n\nApakah Anda ingin mempelajari audit SMKP KPP AGMR?', 0, 4679, '1', NULL, '2025-08-14 04:36:20'),
(5, '89', 'ya bantu saya mempelajari', 1, NULL, NULL, NULL, '2025-08-14 04:36:43'),
(6, '89', 'KEBIJAKAN (Bobot: 10.00%) - Elemen ini menilai apakah perusahaan memiliki komitmen keselamatan pertambangan yang jelas dan tertulis sebagai kebijakan resmi. Kebijakan tersebut harus mencerminkan visi dan tujuan keselamatan pertambangan yang ingin dicapai oleh manajemen. Penting untuk memastikan kebijakan ini dikomunikasikan secara efektif kepada seluruh personel dan pihak terkait. Bukti yang dicari adalah dokumen kebijakan yang ditandatangani dan tanggal penerbitannya.\n\nApakah Anda ingin melanjutkan ke elemen berikutnya?', 0, 2857, '1', NULL, '2025-08-14 04:36:43'),
(7, '89', 'ya', 1, NULL, NULL, NULL, '2025-08-14 04:37:03'),
(8, '89', 'Penilaian elemen KEBIJAKAN memeriksa kelengkapan dan efektivitas komitmen keselamatan pertambangan perusahaan. Auditor akan memverifikasi apakah kebijakan telah disusun dengan benar, mencakup isi yang relevan, disahkan secara resmi oleh manajemen puncak, dikomunikasikan secara luas kepada seluruh pihak terkait, serta ditinjau secara berkala untuk memastikan relevansi dan kesesuaiannya.\n\nSub Elemen yang akan dinilai meliputi:\n*   Penyusunan Kebijakan (4 poin)\n*   Isi Kebijakan (4 poin)\n*   Penetapan Kebijakan (3 poin)\n*   Komunikasi Kebijakan (4 poin)\n*   Tinjauan Kebijakan (4 poin)', 0, 4599, '3', NULL, '2025-08-14 04:37:03'),
(9, '91', 'kenapa gabisa uploa', 1, NULL, NULL, NULL, '2025-08-18 04:38:22'),
(10, '91', 'Mohon maaf atas kendala saat mengunggah. Untuk membantu, mohon pastikan:\n\n*   Anda telah memilih audit SMKP (2024 - tahunan) dan berada pada elemen audit yang memerlukan unggahan.\n*   Jenis dan ukuran berkas yang diunggah sesuai dengan ketentuan sistem.\n*   Jika kendala masih terjadi, mohon berikan detail lebih lanjut atau tangkapan layar halaman yang bermasalah.', 0, 7026, '1', NULL, '2025-08-18 04:38:22'),
(11, '92', 'Tampilkan elemen untuk audit ini', 1, NULL, NULL, NULL, '2025-08-20 00:18:23'),
(12, '92', 'Baik, Bapak/Ibu QualitySystemCommittee.\n\nAnda telah memilih audit **SMKP (2024 - tahunan)**. Berikut adalah elemen-elemen utama untuk audit tersebut:\n\n*   **Kebijakan:** Peninjauan komitmen manajemen terhadap keselamatan pertambangan.\n*   **Perencanaan:** Evaluasi perencanaan program dan sasaran keselamatan.\n*   **Organisasi dan Penunjukan Penanggung Jawab:** Pemeriksaan struktur organisasi dan penunjukan personel yang bertanggung jawab.\n*   **Implementasi:** Verifikasi pelaksanaan program keselamatan di lapangan.\n*   **Evaluasi dan Tindak Lanjut:** Penilaian terhadap evaluasi kinerja dan tindakan perbaikan.\n*   **Dokumentasi:** Peninjauan sistem pengelolaan dokumen dan rekaman.\n*   **Tinjauan Manajemen:** Evaluasi tinjauan berkala oleh manajemen puncak.', 0, 2829, '1', NULL, '2025-08-20 00:18:23'),
(13, '96', 'smkp', 1, NULL, NULL, NULL, '2025-11-02 11:05:04'),
(14, '96', 'Baik, Anda telah memilih audit **SMKP (2024 - tahunan)**.\n\nBerikut adalah elemen-elemen utama yang akan diaudit dalam Sistem Manajemen Keselamatan Pertambangan (SMKP):\n\n*   **Kebijakan:** Peninjauan kebijakan SMKP perusahaan.\n*   **Perencanaan:** Evaluasi perencanaan SMKP yang mencakup identifikasi bahaya dan penilaian risiko.\n*   **Organisasi & Personel:** Penilaian struktur organisasi, tanggung jawab, dan kompetensi personel.\n*   **Implementasi:** Pemeriksaan pelaksanaan operasi dan standar SMKP.\n*   **Evaluasi & Tindak Lanjut:** Peninjauan pemantauan, inspeksi, audit internal, dan pengelolaan ketidaksesuaian.\n*   **Tinjauan Manajemen:** Penilaian efektivitas tinjauan manajemen terhadap SMKP.', 0, 5367, '2', NULL, '2025-11-02 11:05:04'),
(15, '98', 'Saya ingin mempelajari audit ISO 9001', 1, NULL, NULL, NULL, '2025-11-03 00:50:11'),
(16, '98', 'Saya memahami Anda ingin mempelajari audit. Audit yang tersedia:\n\n• SMKP (2025 - tahunan)\n• SMKP (2024 - tahunan)\n\n\nAudit mana yang menarik perhatian Anda?', 0, 920, '2', NULL, '2025-11-03 00:50:11'),
(17, '100', 'Tampilkan daftar audit yang tersedia', 1, NULL, NULL, NULL, '2025-11-03 04:54:58'),
(18, '100', '📋 Berikut daftar audit yang tersedia untuk Anda:\n\n• SMKP (2025 - tahunan)\n• SMKP (2024 - tahunan)\n\n\nPilih audit yang ingin dipelajari dengan menyebutkan namanya atau kode auditnya.', 0, 905, '3', NULL, '2025-11-03 04:54:58'),
(19, '102', 'Apa saja elemen dalam audit?', 1, NULL, NULL, NULL, '2025-11-03 05:15:19'),
(20, '102', 'Saya memahami Anda ingin mempelajari audit. Audit yang tersedia:\n\n• SMKP (2025 - tahunan)\n• SMKP (2024 - tahunan)\n\n\nAudit mana yang menarik perhatian Anda?', 0, 899, '1', NULL, '2025-11-03 05:15:19'),
(21, '102', 'smkp 2024', 1, NULL, NULL, NULL, '2025-11-03 05:15:34'),
(22, '102', 'Saya memahami Anda ingin mempelajari audit. Audit yang tersedia:\n\n• SMKP (2025 - tahunan)\n• SMKP (2024 - tahunan)\n\n\nAudit mana yang menarik perhatian Anda?\n\nBerdasarkan percakapan kita sebelumnya:', 0, 2025, '1', NULL, '2025-11-03 05:15:34'),
(23, '102', 'SMKP 2024', 1, NULL, NULL, NULL, '2025-11-03 05:16:07'),
(24, '102', 'Saya memahami Anda ingin mempelajari audit. Audit yang tersedia:\n\n• SMKP (2025 - tahunan)\n• SMKP (2024 - tahunan)\n\n\nAudit mana yang menarik perhatian Anda?\n\nBerdasarkan percakapan kita sebelumnya:', 0, 896, '3', NULL, '2025-11-03 05:16:07');

-- --------------------------------------------------------

--
-- Struktur dari tabel `ai_chat_sessions`
--

CREATE TABLE `ai_chat_sessions` (
  `id` int(11) NOT NULL,
  `session_id` varchar(100) NOT NULL,
  `user_id` int(11) NOT NULL,
  `status` enum('active','completed','deleted') DEFAULT 'active',
  `context_data` text DEFAULT NULL,
  `current_step` varchar(50) DEFAULT NULL,
  `audit_id` int(11) DEFAULT NULL,
  `elemen_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `ai_chat_sessions`
--

INSERT INTO `ai_chat_sessions` (`id`, `session_id`, `user_id`, `status`, `context_data`, `current_step`, `audit_id`, `elemen_id`, `created_at`, `updated_at`) VALUES
(3, '86', 2, 'active', NULL, NULL, NULL, NULL, '2025-08-12 12:21:21', '2025-08-12 12:21:25'),
(4, '89', 2, 'active', NULL, NULL, NULL, NULL, '2025-08-14 04:36:15', '2025-08-14 04:37:03'),
(5, '91', 1, 'active', NULL, NULL, NULL, NULL, '2025-08-18 04:38:15', '2025-08-18 04:38:22'),
(6, '92', 1, 'active', NULL, NULL, NULL, NULL, '2025-08-20 00:18:20', '2025-08-20 00:18:23'),
(7, '96', 1, 'active', NULL, NULL, NULL, NULL, '2025-11-02 11:04:59', '2025-11-02 11:05:04'),
(8, '98', 2, 'active', NULL, NULL, NULL, NULL, '2025-11-03 00:50:10', '2025-11-03 00:50:11'),
(9, '100', 1, 'active', NULL, NULL, NULL, NULL, '2025-11-03 04:54:57', '2025-11-03 04:54:58'),
(10, '102', 1, 'active', NULL, NULL, NULL, NULL, '2025-11-03 05:15:18', '2025-11-03 05:16:07');

-- --------------------------------------------------------

--
-- Struktur dari tabel `ai_conversations`
--

CREATE TABLE `ai_conversations` (
  `id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `user_message` text DEFAULT NULL,
  `ai_response` text DEFAULT NULL,
  `gemini_api_key_id` int(11) NOT NULL,
  `prompt_template` mediumtext DEFAULT NULL,
  `response_metadata` longtext DEFAULT NULL CHECK (json_valid(`response_metadata`)),
  `processing_time_ms` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data untuk tabel `ai_conversations`
--

INSERT INTO `ai_conversations` (`id`, `session_id`, `user_message`, `ai_response`, `gemini_api_key_id`, `prompt_template`, `response_metadata`, `processing_time_ms`, `created_at`) VALUES
(1, 86, '[SESSION_STARTED]', 'Hi! 🚀 Siap belajar audit? Saya akan membantu step by step.\n\nSaya akan memandu Anda secara bertahap agar tidak overwhelming.\n\n🎯 **Langkah 1: Pilih Audit**\nMari mulai dengan memilih audit yang ingin dipelajari.\n\nAnda bisa:\n• Ketik \'daftar audit\' untuk melihat semua audit tersedia\n• Langsung sebutkan nama audit yang sudah Anda ketahui\n\nAudit mana yang ingin kita pelajari?', 2, 'welcome_template', NULL, NULL, '2025-08-12 12:21:19'),
(2, 87, 'Tampilkan daftar audit yang tersedia', 'Berikut daftar audit yang tersedia untuk peran Anda:\n\n*   **SMKP KPP AGMR (2024 - tahunan)**: Audit Sistem Manajemen Keselamatan Pertambangan.', 1, 'select_audit_template', NULL, 3785, '2025-08-12 12:21:25'),
(3, 88, '[SESSION_STARTED]', 'Halo! 👋 Saya AI Assistant siap membantu Anda mempelajari sistem audit.\n\nSaya akan memandu Anda secara bertahap agar tidak overwhelming.\n\n🎯 **Langkah 1: Pilih Audit**\nMari mulai dengan memilih audit yang ingin dipelajari.\n\nAnda bisa:\n• Ketik \'daftar audit\' untuk melihat semua audit tersedia\n• Langsung sebutkan nama audit yang sudah Anda ketahui\n\nAudit mana yang ingin kita pelajari?', 3, 'welcome_template', NULL, NULL, '2025-08-14 04:36:04'),
(4, 89, '[SESSION_STARTED]', 'Halo! 👋 Saya AI Assistant siap membantu Anda mempelajari sistem audit.\n\nSaya akan memandu Anda secara bertahap agar tidak overwhelming.\n\n🎯 **Langkah 1: Pilih Audit**\nMari mulai dengan memilih audit yang ingin dipelajari.\n\nAnda bisa:\n• Ketik \'daftar audit\' untuk melihat semua audit tersedia\n• Langsung sebutkan nama audit yang sudah Anda ketahui\n\nAudit mana yang ingin kita pelajari?', 3, 'welcome_template', NULL, NULL, '2025-08-14 04:36:15'),
(5, 90, 'Saya ingin mempelajari audit ISO 9001', 'Mohon maaf, audit ISO 9001 belum tersedia dalam daftar audit kami saat ini.\n\nAudit yang tersedia adalah:\n*   SMKP KPP AGMR (2024 - tahunan)\n\nApakah Anda ingin mempelajari audit SMKP KPP AGMR?', 1, 'select_audit_template', NULL, 4679, '2025-08-14 04:36:20'),
(6, 90, 'ya bantu saya mempelajari', 'KEBIJAKAN (Bobot: 10.00%) - Elemen ini menilai apakah perusahaan memiliki komitmen keselamatan pertambangan yang jelas dan tertulis sebagai kebijakan resmi. Kebijakan tersebut harus mencerminkan visi dan tujuan keselamatan pertambangan yang ingin dicapai oleh manajemen. Penting untuk memastikan kebijakan ini dikomunikasikan secara efektif kepada seluruh personel dan pihak terkait. Bukti yang dicari adalah dokumen kebijakan yang ditandatangani dan tanggal penerbitannya.\n\nApakah Anda ingin melanjutkan ke elemen berikutnya?', 1, 'select_elemen_template', NULL, 2857, '2025-08-14 04:36:43'),
(7, 90, 'ya', 'Penilaian elemen KEBIJAKAN memeriksa kelengkapan dan efektivitas komitmen keselamatan pertambangan perusahaan. Auditor akan memverifikasi apakah kebijakan telah disusun dengan benar, mencakup isi yang relevan, disahkan secara resmi oleh manajemen puncak, dikomunikasikan secara luas kepada seluruh pihak terkait, serta ditinjau secara berkala untuk memastikan relevansi dan kesesuaiannya.\n\nSub Elemen yang akan dinilai meliputi:\n*   Penyusunan Kebijakan (4 poin)\n*   Isi Kebijakan (4 poin)\n*   Penetapan Kebijakan (3 poin)\n*   Komunikasi Kebijakan (4 poin)\n*   Tinjauan Kebijakan (4 poin)', 3, 'explain_detail_template', NULL, 4599, '2025-08-14 04:37:03'),
(8, 91, '[SESSION_STARTED]', 'Hi! 🚀 Siap belajar audit? Saya akan membantu step by step.\n\nSaya akan memandu Anda secara bertahap agar tidak overwhelming.\n\n🎯 **Langkah 1: Pilih Audit**\nMari mulai dengan memilih audit yang ingin dipelajari.\n\nAnda bisa:\n• Ketik \'daftar audit\' untuk melihat semua audit tersedia\n• Langsung sebutkan nama audit yang sudah Anda ketahui\n\nAudit mana yang ingin kita pelajari?', 2, 'welcome_template', NULL, NULL, '2025-08-18 04:38:05'),
(9, 92, 'kenapa gabisa uploa', 'Mohon maaf atas kendala saat mengunggah. Untuk membantu, mohon pastikan:\n\n*   Anda telah memilih audit SMKP (2024 - tahunan) dan berada pada elemen audit yang memerlukan unggahan.\n*   Jenis dan ukuran berkas yang diunggah sesuai dengan ketentuan sistem.\n*   Jika kendala masih terjadi, mohon berikan detail lebih lanjut atau tangkapan layar halaman yang bermasalah.', 1, 'select_audit_template', NULL, 7026, '2025-08-18 04:38:22'),
(10, 93, 'Tampilkan elemen untuk audit ini', 'Baik, Bapak/Ibu QualitySystemCommittee.\n\nAnda telah memilih audit **SMKP (2024 - tahunan)**. Berikut adalah elemen-elemen utama untuk audit tersebut:\n\n*   **Kebijakan:** Peninjauan komitmen manajemen terhadap keselamatan pertambangan.\n*   **Perencanaan:** Evaluasi perencanaan program dan sasaran keselamatan.\n*   **Organisasi dan Penunjukan Penanggung Jawab:** Pemeriksaan struktur organisasi dan penunjukan personel yang bertanggung jawab.\n*   **Implementasi:** Verifikasi pelaksanaan program keselamatan di lapangan.\n*   **Evaluasi dan Tindak Lanjut:** Penilaian terhadap evaluasi kinerja dan tindakan perbaikan.\n*   **Dokumentasi:** Peninjauan sistem pengelolaan dokumen dan rekaman.\n*   **Tinjauan Manajemen:** Evaluasi tinjauan berkala oleh manajemen puncak.', 1, 'select_audit_template', NULL, 2829, '2025-08-20 00:18:23'),
(11, 94, '[SESSION_STARTED]', 'Halo! 👋 Saya AI Assistant siap membantu Anda mempelajari sistem audit.\n\nSaya akan memandu Anda secara bertahap agar tidak overwhelming.\n\n🎯 **Langkah 1: Pilih Audit**\nMari mulai dengan memilih audit yang ingin dipelajari.\n\nAnda bisa:\n• Ketik \'daftar audit\' untuk melihat semua audit tersedia\n• Langsung sebutkan nama audit yang sudah Anda ketahui\n\nAudit mana yang ingin kita pelajari?', 3, 'welcome_template', NULL, NULL, '2025-09-17 09:14:28'),
(12, 95, '[SESSION_STARTED]', 'Hi! 🚀 Siap belajar audit? Saya akan membantu step by step.\n\nSaya akan memandu Anda secara bertahap agar tidak overwhelming.\n\n🎯 **Langkah 1: Pilih Audit**\nMari mulai dengan memilih audit yang ingin dipelajari.\n\nAnda bisa:\n• Ketik \'daftar audit\' untuk melihat semua audit tersedia\n• Langsung sebutkan nama audit yang sudah Anda ketahui\n\nAudit mana yang ingin kita pelajari?', 2, 'welcome_template', NULL, NULL, '2025-10-08 23:40:12'),
(13, 96, '[SESSION_STARTED]', 'Hai! 🤖 Mari kita eksplorasi sistem audit bersama-sama.\n\nSaya akan memandu Anda secara bertahap agar tidak overwhelming.\n\n🎯 **Langkah 1: Pilih Audit**\nMari mulai dengan memilih audit yang ingin dipelajari.\n\nAnda bisa:\n• Ketik \'daftar audit\' untuk melihat semua audit tersedia\n• Langsung sebutkan nama audit yang sudah Anda ketahui\n\nAudit mana yang ingin kita pelajari?', 1, 'welcome_template', NULL, NULL, '2025-11-02 11:04:56'),
(14, 97, 'smkp', 'Baik, Anda telah memilih audit **SMKP (2024 - tahunan)**.\n\nBerikut adalah elemen-elemen utama yang akan diaudit dalam Sistem Manajemen Keselamatan Pertambangan (SMKP):\n\n*   **Kebijakan:** Peninjauan kebijakan SMKP perusahaan.\n*   **Perencanaan:** Evaluasi perencanaan SMKP yang mencakup identifikasi bahaya dan penilaian risiko.\n*   **Organisasi & Personel:** Penilaian struktur organisasi, tanggung jawab, dan kompetensi personel.\n*   **Implementasi:** Pemeriksaan pelaksanaan operasi dan standar SMKP.\n*   **Evaluasi & Tindak Lanjut:** Peninjauan pemantauan, inspeksi, audit internal, dan pengelolaan ketidaksesuaian.\n*   **Tinjauan Manajemen:** Penilaian efektivitas tinjauan manajemen terhadap SMKP.', 2, 'select_audit_template', NULL, 5367, '2025-11-02 11:05:04'),
(15, 98, '[SESSION_STARTED]', 'Hi! 🚀 Siap belajar audit? Saya akan membantu step by step.\n\nSaya akan memandu Anda secara bertahap agar tidak overwhelming.\n\n🎯 **Langkah 1: Pilih Audit**\nMari mulai dengan memilih audit yang ingin dipelajari.\n\nAnda bisa:\n• Ketik \'daftar audit\' untuk melihat semua audit tersedia\n• Langsung sebutkan nama audit yang sudah Anda ketahui\n\nAudit mana yang ingin kita pelajari?', 3, 'welcome_template', NULL, NULL, '2025-11-03 00:50:09'),
(16, 99, 'Saya ingin mempelajari audit ISO 9001', 'Saya memahami Anda ingin mempelajari audit. Audit yang tersedia:\n\n• SMKP (2025 - tahunan)\n• SMKP (2024 - tahunan)\n\n\nAudit mana yang menarik perhatian Anda?', 2, 'select_audit_template', NULL, 920, '2025-11-03 00:50:11'),
(17, 100, '[SESSION_STARTED]', 'Hello! ✨ Saya di sini untuk memandu Anda memahami audit dengan mudah.\n\nSaya akan memandu Anda secara bertahap agar tidak overwhelming.\n\n🎯 **Langkah 1: Pilih Audit**\nMari mulai dengan memilih audit yang ingin dipelajari.\n\nAnda bisa:\n• Ketik \'daftar audit\' untuk melihat semua audit tersedia\n• Langsung sebutkan nama audit yang sudah Anda ketahui\n\nAudit mana yang ingin kita pelajari?', 3, 'welcome_template', NULL, NULL, '2025-11-03 04:54:30'),
(18, 101, 'Tampilkan daftar audit yang tersedia', '📋 Berikut daftar audit yang tersedia untuk Anda:\n\n• SMKP (2025 - tahunan)\n• SMKP (2024 - tahunan)\n\n\nPilih audit yang ingin dipelajari dengan menyebutkan namanya atau kode auditnya.', 3, 'select_audit_template', NULL, 905, '2025-11-03 04:54:58'),
(19, 102, '[SESSION_STARTED]', 'Halo! 👋 Saya AI Assistant siap membantu Anda mempelajari sistem audit.\n\nSaya akan memandu Anda secara bertahap agar tidak overwhelming.\n\n🎯 **Langkah 1: Pilih Audit**\nMari mulai dengan memilih audit yang ingin dipelajari.\n\nAnda bisa:\n• Ketik \'daftar audit\' untuk melihat semua audit tersedia\n• Langsung sebutkan nama audit yang sudah Anda ketahui\n\nAudit mana yang ingin kita pelajari?', 1, 'welcome_template', NULL, NULL, '2025-11-03 05:15:11'),
(20, 103, 'Apa saja elemen dalam audit?', 'Saya memahami Anda ingin mempelajari audit. Audit yang tersedia:\n\n• SMKP (2025 - tahunan)\n• SMKP (2024 - tahunan)\n\n\nAudit mana yang menarik perhatian Anda?', 1, 'select_audit_template', NULL, 899, '2025-11-03 05:15:19'),
(21, 103, 'smkp 2024', 'Saya memahami Anda ingin mempelajari audit. Audit yang tersedia:\n\n• SMKP (2025 - tahunan)\n• SMKP (2024 - tahunan)\n\n\nAudit mana yang menarik perhatian Anda?\n\nBerdasarkan percakapan kita sebelumnya:', 1, 'select_audit_template', NULL, 2025, '2025-11-03 05:15:34'),
(22, 103, 'SMKP 2024', 'Saya memahami Anda ingin mempelajari audit. Audit yang tersedia:\n\n• SMKP (2025 - tahunan)\n• SMKP (2024 - tahunan)\n\n\nAudit mana yang menarik perhatian Anda?\n\nBerdasarkan percakapan kita sebelumnya:', 3, 'select_audit_template', NULL, 896, '2025-11-03 05:16:07');

-- --------------------------------------------------------

--
-- Struktur dari tabel `ai_knowledge_base`
--

CREATE TABLE `ai_knowledge_base` (
  `id` int(11) NOT NULL,
  `audit_id` int(11) DEFAULT NULL,
  `elemen_id` int(11) DEFAULT NULL,
  `sub_elemen_id` int(11) DEFAULT NULL,
  `sub_sub_elemen_id` int(11) DEFAULT NULL,
  `question_pattern` varchar(500) DEFAULT NULL,
  `cached_response` mediumtext NOT NULL,
  `usage_count` int(11) DEFAULT 0,
  `last_updated` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data untuk tabel `ai_knowledge_base`
--

INSERT INTO `ai_knowledge_base` (`id`, `audit_id`, `elemen_id`, `sub_elemen_id`, `sub_sub_elemen_id`, `question_pattern`, `cached_response`, `usage_count`, `last_updated`, `created_at`) VALUES
(1, NULL, NULL, NULL, NULL, 'apa itu audit|pengertian audit|definisi audit', 'Audit adalah proses sistematis untuk mengevaluasi dan memverifikasi kegiatan, proses, dan sistem dalam suatu organisasi. Dalam konteks sistem ini, audit dilakukan untuk memastikan bahwa semua departemen memenuhi standar dan elemen yang telah ditetapkan.', 0, '2025-08-09 01:51:44', '2025-08-09 01:51:44'),
(2, NULL, NULL, NULL, NULL, 'bagaimana sistem penilaian|cara menghitung nilai|scoring system', 'Sistem penilaian dalam aplikasi ini menggunakan dua metode:\r\n1. **Penilaian Otomatis**: Berdasarkan kelengkapan berkas utama yang diupload dan diverifikasi\r\n2. **Penilaian Manual**: Dilakukan oleh QualitySystemCommittee sebagai nilai final\r\n\r\nPenilaian otomatis dihitung real-time berdasarkan rumus: (berkas_utama_approved / total_berkas_utama) × poin_maksimal', 0, '2025-08-09 01:51:44', '2025-08-09 01:51:44'),
(3, NULL, NULL, NULL, NULL, 'perbedaan berkas utama dan pendukung|jenis berkas', '**Berkas Utama**: Berkas wajib yang mempengaruhi penilaian otomatis sistem. Jumlahnya tetap sesuai requirement AuditSteeringCommittee.\r\n\r\n**Berkas Pendukung**: Berkas tambahan yang dapat diupload sebanyak mungkin, tidak mempengaruhi penilaian otomatis, namun dapat memperkuat dokumentasi audit.', 0, '2025-08-09 01:51:44', '2025-08-09 01:51:44');

-- --------------------------------------------------------

--
-- Struktur dari tabel `ai_learning_sessions`
--

CREATE TABLE `ai_learning_sessions` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `session_token` varchar(255) NOT NULL,
  `current_step` enum('select_audit','select_elemen','explain_detail','qa_session','completed') DEFAULT 'select_audit',
  `audit_id` int(11) DEFAULT NULL,
  `elemen_id` int(11) DEFAULT NULL,
  `sub_elemen_id` int(11) DEFAULT NULL,
  `sub_sub_elemen_id` int(11) DEFAULT NULL,
  `learning_context` longtext DEFAULT NULL CHECK (json_valid(`learning_context`)),
  `is_active` tinyint(1) DEFAULT 1,
  `started_at` timestamp NULL DEFAULT current_timestamp(),
  `last_activity` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `completed_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data untuk tabel `ai_learning_sessions`
--

INSERT INTO `ai_learning_sessions` (`id`, `user_id`, `session_token`, `current_step`, `audit_id`, `elemen_id`, `sub_elemen_id`, `sub_sub_elemen_id`, `learning_context`, `is_active`, `started_at`, `last_activity`, `completed_at`) VALUES
(86, 2, 'AI_2_1755001279_5660', 'select_audit', NULL, NULL, NULL, NULL, '{}', 0, '2025-08-12 12:21:19', '2025-08-14 04:36:04', '2025-08-14 04:36:04'),
(87, 2, '86', 'select_elemen', 9, NULL, NULL, NULL, '{\"selected_audit\": {\"id\": 9, \"name\": \"SMKP KPP AGMR\"}}', 0, '2025-08-12 12:21:21', '2025-08-14 04:36:04', '2025-08-14 04:36:04'),
(88, 2, 'AI_2_1755146164_9107', 'select_audit', NULL, NULL, NULL, NULL, '{}', 0, '2025-08-14 04:36:04', '2025-08-14 04:36:15', '2025-08-14 04:36:15'),
(89, 2, 'AI_2_1755146175_8540', 'select_audit', NULL, NULL, NULL, NULL, '{}', 0, '2025-08-14 04:36:15', '2025-11-03 00:50:09', '2025-11-03 00:50:09'),
(90, 2, '89', 'qa_session', 9, 32, NULL, NULL, '{\"selected_audit\": {\"id\": 9, \"name\": \"SMKP KPP AGMR\"}, \"selected_elemen\": {\"id\": 32, \"name\": \"KEBIJAKAN\"}}', 0, '2025-08-14 04:36:15', '2025-11-03 00:50:09', '2025-11-03 00:50:09'),
(91, 1, 'AI_1_1755491885_1768', 'select_audit', NULL, NULL, NULL, NULL, '{}', 0, '2025-08-18 04:38:05', '2025-09-17 09:14:28', '2025-09-17 09:14:28'),
(92, 1, '91', 'select_elemen', 9, NULL, NULL, NULL, '{\"selected_audit\": {\"id\": 9, \"name\": \"SMKP\"}}', 0, '2025-08-18 04:38:15', '2025-09-17 09:14:28', '2025-09-17 09:14:28'),
(93, 1, '92', 'select_elemen', 9, NULL, NULL, NULL, '{\"selected_audit\": {\"id\": 9, \"name\": \"SMKP\"}}', 0, '2025-08-20 00:18:20', '2025-09-17 09:14:28', '2025-09-17 09:14:28'),
(94, 1, 'AI_1_1758100468_1275', 'select_audit', NULL, NULL, NULL, NULL, '{}', 0, '2025-09-17 09:14:28', '2025-10-08 23:40:12', '2025-10-08 23:40:12'),
(95, 1, 'AI_1_1759966812_8057', 'select_audit', NULL, NULL, NULL, NULL, '{}', 0, '2025-10-08 23:40:12', '2025-11-02 11:04:56', '2025-11-02 11:04:56'),
(96, 1, 'AI_1_1762081496_6217', 'select_audit', NULL, NULL, NULL, NULL, '{}', 0, '2025-11-02 11:04:56', '2025-11-03 04:54:30', '2025-11-03 04:54:30'),
(97, 1, '96', 'select_elemen', 9, NULL, NULL, NULL, '{\"selected_audit\": {\"id\": 9, \"name\": \"SMKP\"}}', 0, '2025-11-02 11:04:59', '2025-11-03 04:54:30', '2025-11-03 04:54:30'),
(98, 2, 'AI_2_1762131009_7930', 'select_audit', NULL, NULL, NULL, NULL, '{}', 1, '2025-11-03 00:50:09', '2025-11-03 00:50:09', NULL),
(99, 2, '98', 'select_audit', NULL, NULL, NULL, NULL, '{}', 1, '2025-11-03 00:50:10', '2025-11-03 00:50:11', NULL),
(100, 1, 'AI_1_1762145670_9055', 'select_audit', NULL, NULL, NULL, NULL, '{}', 0, '2025-11-03 04:54:30', '2025-11-03 05:15:11', '2025-11-03 05:15:11'),
(101, 1, '100', 'select_audit', NULL, NULL, NULL, NULL, '{}', 0, '2025-11-03 04:54:57', '2025-11-03 05:15:11', '2025-11-03 05:15:11'),
(102, 1, 'AI_1_1762146911_9906', 'select_audit', NULL, NULL, NULL, NULL, '{}', 1, '2025-11-03 05:15:11', '2025-11-03 05:15:11', NULL),
(103, 1, '102', 'select_audit', NULL, NULL, NULL, NULL, '{}', 1, '2025-11-03 05:15:18', '2025-11-03 05:16:07', NULL);

-- --------------------------------------------------------

--
-- Struktur dari tabel `ai_prompt_templates`
--

CREATE TABLE `ai_prompt_templates` (
  `id` int(11) NOT NULL,
  `nama_template` varchar(100) NOT NULL,
  `step_type` enum('select_audit','select_elemen','explain_detail','qa_session','general') NOT NULL,
  `prompt_template` mediumtext NOT NULL,
  `system_instruction` mediumtext DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data untuk tabel `ai_prompt_templates`
--

INSERT INTO `ai_prompt_templates` (`id`, `nama_template`, `step_type`, `prompt_template`, `system_instruction`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES
(1, 'Pilih Audit Template', 'select_audit', 'Selamat datang di Sistem AI Documentation Audit! \r\n\r\nSaya akan membantu Anda memahami sistem audit secara bertahap untuk menghindari overload informasi.\r\n\r\n**STEP 1: Pilih Audit**\r\nBerikut adalah daftar audit yang tersedia:\r\n\r\n{audit_list}\r\n\r\nSilakan pilih audit mana yang ingin Anda pelajari dengan menyebutkan nama atau nomor auditnya. Setelah itu, saya akan menjelaskan audit tersebut dan melanjutkan ke elemen-elemen yang ada.', 'Anda adalah AI assistant untuk sistem audit internal. Berikan penjelasan yang jelas, terstruktur, dan mudah dipahami. Selalu gunakan pendekatan step-by-step untuk menghindari overload informasi. Gunakan bahasa Indonesia yang formal namun ramah.', 1, 2, '2025-08-09 01:51:44', '2025-08-09 01:51:44'),
(2, 'Pilih Elemen Template', 'select_elemen', '**STEP 2: Pilih Elemen**\r\n\r\nAudit \"{audit_name}\" memiliki elemen-elemen berikut:\r\n\r\n{elemen_list}\r\n\r\nSilakan pilih elemen mana yang ingin Anda pelajari lebih detail. Saya akan menjelaskan:\r\n- Deskripsi elemen\r\n- Tujuan dan sasaran\r\n- Sub elemen yang ada\r\n- Cara penilaiannya\r\n\r\nKetik nomor atau nama elemen yang ingin dipelajari.', 'Fokus pada satu elemen per waktu. Berikan penjelasan yang komprehensif namun tidak overwhelming. Pastikan user memahami sebelum melanjutkan ke step berikutnya.', 1, 2, '2025-08-09 01:51:44', '2025-08-09 01:51:44'),
(3, 'Explain Detail Template', 'explain_detail', '**STEP 3: Penjelasan Detail**\r\n\r\n**Elemen: {elemen_name}**\r\n\r\n**Deskripsi:**\r\n{elemen_deskripsi}\r\n\r\n**Panduan Implementasi:**\r\n{panduan_implementasi}\r\n\r\n**Contoh Penerapan:**\r\n{contoh_penerapan}\r\n\r\n**Sub Elemen:**\r\n{sub_elemen_list}\r\n\r\n**Bobot Penilaian:** {persentase_bobot}%\r\n\r\nApakah ada aspek tertentu yang ingin Anda tanyakan lebih lanjut? Atau ingin melanjutkan ke sub elemen tertentu?', 'Berikan penjelasan yang detail namun mudah dipahami. Gunakan contoh konkret dan praktis. Siap menjawab pertanyaan follow-up dengan sabar.', 1, 2, '2025-08-09 01:51:44', '2025-08-09 01:51:44'),
(4, 'QA Session Template', 'qa_session', 'Silakan ajukan pertanyaan Anda tentang {context_topic}. Saya akan memberikan penjelasan berdasarkan dokumentasi dan deskripsi yang tersedia dalam sistem.\r\n\r\nPertanyaan Anda: {user_question}\r\n\r\n{ai_response_based_on_context}\r\n\r\nApakah ada aspek lain yang ingin ditanyakan?', 'Jawab pertanyaan berdasarkan context yang tersedia. Jika informasi tidak cukup, arahkan user untuk bertanya ke AuditSteeringCommittee atau QualitySystemCommittee yang relevan.', 1, 2, '2025-08-09 01:51:44', '2025-08-09 01:51:44');

-- --------------------------------------------------------

--
-- Struktur dari tabel `akses_audit`
--

CREATE TABLE `akses_audit` (
  `id` int(11) NOT NULL,
  `audit_id` int(11) NOT NULL,
  `departemen_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `audit`
--

CREATE TABLE `audit` (
  `id` int(11) NOT NULL,
  `nama_audit` varchar(100) NOT NULL,
  `deskripsi` mediumtext DEFAULT NULL,
  `tahun_audit` year(4) NOT NULL,
  `periode_audit` enum('tahunan','semesteran','triwulanan','bulanan','semester_1','semester_2','kuartal_1','kuartal_2','kuartal_3','kuartal_4') NOT NULL,
  `tanggal_mulai` date NOT NULL,
  `tanggal_selesai` date NOT NULL,
  `status` enum('draft','aktif','nonaktif','selesai','dibatalkan') DEFAULT 'draft',
  `akses_tipe` enum('umum','terbatas') NOT NULL DEFAULT 'umum',
  `notifikasi_whatsapp` tinyint(1) NOT NULL DEFAULT 0,
  `auto_reminder` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `activated_at` timestamp NULL DEFAULT NULL,
  `activated_by` int(11) DEFAULT NULL,
  `selesai_at` timestamp NULL DEFAULT NULL,
  `selesai_by` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_by` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `deleted_by` int(11) DEFAULT NULL,
  `total_score` decimal(5,2) DEFAULT NULL,
  `last_updated` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data untuk tabel `audit`
--

INSERT INTO `audit` (`id`, `nama_audit`, `deskripsi`, `tahun_audit`, `periode_audit`, `tanggal_mulai`, `tanggal_selesai`, `status`, `akses_tipe`, `notifikasi_whatsapp`, `auto_reminder`, `created_by`, `created_at`, `activated_at`, `activated_by`, `selesai_at`, `selesai_by`, `updated_at`, `updated_by`, `deleted_at`, `deleted_by`, `total_score`, `last_updated`) VALUES
(9, 'SMKP', '', '2024', 'tahunan', '2024-11-01', '2024-12-15', 'selesai', 'umum', 0, 0, 2, '2025-08-11 08:27:21', NULL, NULL, '2025-08-14 04:23:19', 2, '2025-11-02 11:51:33', 2, NULL, NULL, 82.00, '2025-11-02 11:51:33'),
(10, 'ISO 45001', '', '2025', 'tahunan', '2025-08-18', '2025-09-17', 'dibatalkan', 'umum', 0, 0, 2, '2025-08-11 08:49:08', NULL, NULL, NULL, NULL, '2025-08-15 20:56:06', NULL, NULL, NULL, NULL, '2025-08-15 20:56:06'),
(11, 'SMKP', '', '2025', 'tahunan', '2025-11-01', '2025-12-22', 'aktif', 'umum', 0, 0, 2, '2025-08-14 04:16:08', NULL, NULL, NULL, NULL, '2025-11-02 11:45:39', 2, NULL, NULL, NULL, '2025-11-02 11:45:39');

-- --------------------------------------------------------

--
-- Struktur dari tabel `berkas_pendukung_sub_elemen`
--

CREATE TABLE `berkas_pendukung_sub_elemen` (
  `id` int(11) NOT NULL,
  `sub_elemen_id` int(11) NOT NULL,
  `uploaded_by` int(11) NOT NULL,
  `nama_file_asli` varchar(255) NOT NULL,
  `nama_file_sistem` varchar(255) NOT NULL,
  `ukuran_file` int(11) NOT NULL,
  `mime_type` varchar(100) DEFAULT NULL,
  `path_file` varchar(500) NOT NULL,
  `deskripsi_berkas` mediumtext DEFAULT NULL,
  `keterangan` mediumtext DEFAULT NULL,
  `status_verifikasi` enum('pending','approved','rejected') DEFAULT 'pending',
  `verified_by` int(11) DEFAULT NULL,
  `catatan_verifikasi` mediumtext DEFAULT NULL,
  `verified_at` timestamp NULL DEFAULT NULL,
  `uploaded_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Trigger `berkas_pendukung_sub_elemen`
--
DELIMITER $$
CREATE TRIGGER `tr_berkas_pendukung_log_insert` AFTER INSERT ON `berkas_pendukung_sub_elemen` FOR EACH ROW BEGIN
    INSERT INTO activity_log (user_id, action, table_name, record_id, new_values, description)
    VALUES (NEW.uploaded_by, 'upload', 'berkas_pendukung_sub_elemen', NEW.id, 
           JSON_OBJECT('file_name', NEW.nama_file_asli, 'file_size', NEW.ukuran_file),
           CONCAT('Upload berkas pendukung: ', NEW.nama_file_asli));
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Struktur dari tabel `berkas_pendukung_sub_sub_elemen`
--

CREATE TABLE `berkas_pendukung_sub_sub_elemen` (
  `id` int(11) NOT NULL,
  `sub_sub_elemen_id` int(11) NOT NULL,
  `uploaded_by` int(11) NOT NULL,
  `nama_file_asli` varchar(255) NOT NULL,
  `nama_file_sistem` varchar(255) NOT NULL,
  `ukuran_file` int(11) NOT NULL,
  `mime_type` varchar(100) DEFAULT NULL,
  `path_file` varchar(500) NOT NULL,
  `deskripsi_berkas` mediumtext DEFAULT NULL,
  `keterangan` mediumtext DEFAULT NULL,
  `status_verifikasi` enum('pending','approved','rejected') DEFAULT 'pending',
  `verified_by` int(11) DEFAULT NULL,
  `catatan_verifikasi` mediumtext DEFAULT NULL,
  `verified_at` timestamp NULL DEFAULT NULL,
  `uploaded_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `departemen`
--

CREATE TABLE `departemen` (
  `id` int(11) NOT NULL,
  `kode_departemen` varchar(10) NOT NULL,
  `nama_departemen` varchar(100) NOT NULL,
  `deskripsi` mediumtext DEFAULT NULL,
  `status` enum('aktif','nonaktif') DEFAULT 'aktif',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data untuk tabel `departemen`
--

INSERT INTO `departemen` (`id`, `kode_departemen`, `nama_departemen`, `deskripsi`, `status`, `created_at`, `updated_at`) VALUES
(1, 'HFI', 'HCGS - FAT - ICT', 'Departemen Human Capital, General Service, Finance & ICT', 'aktif', '2025-08-09 01:51:44', '2025-08-13 06:55:41'),
(2, 'EP', 'ENGPROD', 'Departemen Engineering & Produksi ', 'aktif', '2025-08-09 01:51:44', '2025-08-13 06:43:30'),
(3, 'SM', 'SUPPLY MANAGEMENT', 'Departemen Supply Management', 'aktif', '2025-08-09 01:51:44', '2025-08-13 06:49:36'),
(4, 'PL', 'PLANT', 'Departemen Plant', 'aktif', '2025-08-09 01:51:44', '2025-08-13 06:50:21'),
(5, 'TT', 'TT', '', 'nonaktif', '2025-08-09 07:40:52', '2025-08-09 07:40:59'),
(6, 'SHE', 'SAFETY HEALTH ENVIRONMENT', 'Departemen Safety Health Environment', 'aktif', '2025-08-13 06:53:57', '2025-08-13 06:53:57');

-- --------------------------------------------------------

--
-- Struktur dari tabel `elemen`
--

CREATE TABLE `elemen` (
  `id` int(11) NOT NULL,
  `audit_id` int(11) NOT NULL,
  `kode_elemen` varchar(20) NOT NULL,
  `nama_elemen` varchar(200) NOT NULL,
  `deskripsi` mediumtext DEFAULT NULL,
  `panduan_implementasi` mediumtext DEFAULT NULL,
  `contoh_penerapan` mediumtext DEFAULT NULL,
  `referensi_regulasi` mediumtext DEFAULT NULL,
  `persentase_bobot` decimal(5,2) NOT NULL,
  `urutan_tampil` int(11) NOT NULL,
  `status` enum('aktif','nonaktif') DEFAULT 'aktif',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `last_scored_at` timestamp NULL DEFAULT NULL,
  `last_scored_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data untuk tabel `elemen`
--

INSERT INTO `elemen` (`id`, `audit_id`, `kode_elemen`, `nama_elemen`, `deskripsi`, `panduan_implementasi`, `contoh_penerapan`, `referensi_regulasi`, `persentase_bobot`, `urutan_tampil`, `status`, `created_at`, `updated_at`, `last_scored_at`, `last_scored_by`) VALUES
(32, 9, 'I', 'KEBIJAKAN', 'Komitmen Keselamatan Pertambangan tertulis dalam bentuk kebijakan tertulis				', 'Komitmen Keselamatan Pertambangan tertulis dalam bentuk kebijakan tertulis1			', 'Komitmen Keselamatan Pertambangan tertulis dalam bentuk kebijakan tertulis2			', 'Komitmen Keselamatan Pertambangan tertulis dalam bentuk kebijakan tertulis3', 10.00, 1, 'aktif', '2025-08-11 08:29:46', '2025-08-20 07:16:37', '2025-08-14 04:18:22', 2),
(33, 9, 'II', 'PERENCANAAN', '', '', '', '', 15.00, 2, 'aktif', '2025-08-11 08:29:46', '2025-08-14 04:18:46', '2025-08-14 04:18:46', 2),
(34, 9, 'III', 'ORGANISASI DAN PERSONEL', '', '', '', '', 17.00, 3, 'aktif', '2025-08-11 08:29:46', '2025-08-14 04:19:29', '2025-08-14 04:19:29', 2),
(35, 9, 'IV', 'IMPLEMENTASI', '', '', '', '', 35.00, 4, 'aktif', '2025-08-11 08:29:47', '2025-08-14 04:20:57', '2025-08-14 04:20:57', 2),
(36, 9, 'V', 'PEMANTAUAN, EVALUASI DAN TINDAK LANJUT', '', '', '', '', 15.00, 5, 'aktif', '2025-08-11 08:29:47', '2025-08-14 04:21:28', '2025-08-14 04:21:28', 2),
(37, 9, 'VI', 'DOKUMENTASI', '', '', '', '', 3.00, 6, 'aktif', '2025-08-11 08:29:47', '2025-08-14 04:21:45', '2025-08-14 04:21:45', 2),
(38, 9, 'VII', 'TINJAUAN MANAJEMEN DAN PENINGKATAN KINERJA', '', '', '', '', 5.00, 7, 'aktif', '2025-08-11 08:29:47', '2025-08-14 04:22:00', '2025-08-14 04:22:00', 2),
(39, 11, 'I', 'KEBIJAKAN', 'Perusahaan menyusun, menetapkan, menerapkan, memelihara dan mendokumentasikan kebijakan Keselamatan Pertambangan , serta mengomunikasikan ke seluruh pihak yg bekerja atas nama perusahaan, dan selalu melakukan tinjauan ulang secara periodik.		', '		', '', '', 10.00, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-24 09:12:14', NULL, NULL),
(40, 11, 'II', 'PERENCANAAN', 'Perencanaan Adalah Merupakan Tindak Lanjut Dan Penjabaran Dari Kebijakan Keselamatan Pertambangan Yang Telah Ditetapkan', '', '', '', 15.00, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-31 08:40:17', NULL, NULL),
(41, 11, 'III', 'ORGANISASI DAN PERSONEL', 'Organisasi adalah kesatuan (entity) sosial yang dikoordinasikan secara sadar, dengan sebuah batasan yang relatif dapat diidentifikasi, yang bekerja atas dasar yang relatif terus menerus untuk mencapai suatu tujuan bersama atau sekelompok tujuan.\r\n\r\nOrganisasi dan personel mencakup :\r\n1. Penyusunan dan penetapan struktur Organisasi, Tugas Tanggung Jawab dan Wewenang Struktur Organisasi, Tugas Tanggung Jawab dan Wewenang\r\n2. Penunjukkan KTT, KTBT, KKK KTT/PTL, KTBT, KKK (berinilai NA bagi IUJP)\r\n3. Penunjukkan  PJO Untuk Perusahaan Jasa Pertambangan\r\n4. Pembentukan dan penetapan Bagian K3 dan KO Pertambangan\r\n5. Penunjukkan Pengawas Operasional dan Teknik\r\n6. Penunjukkan Tenaga Teknik Khusus Pertambangan\r\n7. Pembentukan dan penetapan Komite Keselamatan Pertambangan\r\n8. Penunjukkan Team Tanggap Darurat\r\n9. Seleksi dan Penempatan Personel\r\n10. Penyelenggaraan dan pelaksanaan Pendidikan, Pelatihan dan Kompetensi Kerja\r\n11. Penyusunan, penetapan dan penerapan Komunikasi Keselamatan Pertambangan\r\n12. Pengelolaan Administrasi Keselamatan Pertambangan\r\n13. Penyusunan, penerapan dan pendokumentasian Partisipasi, Konsultasi, Motivasi dan Kesadaran', '', '', '', 17.00, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-24 10:00:35', NULL, NULL),
(42, 11, 'IV', 'IMPLEMENTASI', '', '', '', '', 35.00, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16', NULL, NULL),
(43, 11, 'V', 'PEMANTAUAN, EVALUASI DAN TINDAK LANJUT', '', '', '', '', 15.00, 5, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16', NULL, NULL),
(44, 11, 'VI', 'DOKUMENTASI', '', '', '', '', 3.00, 6, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16', NULL, NULL),
(45, 11, 'VII', 'TINJAUAN MANAJEMEN DAN PENINGKATAN KINERJA', '', '', '', '', 5.00, 7, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16', NULL, NULL);

-- --------------------------------------------------------

--
-- Struktur dari tabel `elemen_akses`
--

CREATE TABLE `elemen_akses` (
  `id` int(11) NOT NULL,
  `elemen_id` int(11) NOT NULL,
  `jenis_akses` enum('tunggal','terbatas','umum') NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `elemen_akses_departemen`
--

CREATE TABLE `elemen_akses_departemen` (
  `id` int(11) NOT NULL,
  `elemen_akses_id` int(11) NOT NULL,
  `departemen_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `gemini_api_keys`
--

CREATE TABLE `gemini_api_keys` (
  `id` int(11) NOT NULL,
  `api_key` varchar(255) NOT NULL,
  `nama_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quota_harian` int(11) DEFAULT 1000,
  `quota_terpakai` int(11) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `last_reset_quota` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data untuk tabel `gemini_api_keys`
--

INSERT INTO `gemini_api_keys` (`id`, `api_key`, `nama_key`, `quota_harian`, `quota_terpakai`, `is_active`, `last_used_at`, `last_reset_quota`, `created_at`, `updated_at`) VALUES
(1, 'AIzaSyDarurxInfPjtI9f7U7aKW60d3v71oUxRI', 'Primary API Key', 1500, 2, 1, '2025-11-03 05:15:34', '2025-11-03', '2025-08-09 01:51:44', '2025-11-03 05:15:34'),
(2, 'AIzaSyDarurxInfPjtI9f7U7aKW60d3v71oUxRI', 'Secondary API Key', 1200, 1, 1, '2025-11-03 00:50:11', '2025-11-03', '2025-08-09 01:51:44', '2025-11-03 00:50:11'),
(3, 'AIzaSyDarurxInfPjtI9f7U7aKW60d3v71oUxRI', 'Backup API Key', 1000, 2, 1, '2025-11-03 05:16:07', '2025-11-03', '2025-08-09 01:51:44', '2025-11-03 05:16:07');

-- --------------------------------------------------------

--
-- Struktur dari tabel `jenis_berkas`
--

CREATE TABLE `jenis_berkas` (
  `id` int(11) NOT NULL,
  `nama_berkas` varchar(100) NOT NULL,
  `deskripsi` mediumtext DEFAULT NULL,
  `format_file` varchar(50) DEFAULT NULL,
  `ukuran_maksimal` int(11) DEFAULT NULL,
  `kategori` varchar(50) DEFAULT 'dokumen',
  `template_url` varchar(255) DEFAULT NULL,
  `template_path` varchar(255) DEFAULT NULL,
  `panduan_pengisian` mediumtext DEFAULT NULL,
  `status` varchar(20) DEFAULT 'aktif',
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `departemen_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data untuk tabel `jenis_berkas`
--

INSERT INTO `jenis_berkas` (`id`, `nama_berkas`, `deskripsi`, `format_file`, `ukuran_maksimal`, `kategori`, `template_url`, `template_path`, `panduan_pengisian`, `status`, `created_by`, `updated_by`, `departemen_id`, `created_at`, `updated_at`) VALUES
(1, 'Laporan Ahh', '', 'PDF,DOC,DOCX,XLSX', 5120, 'dokumen', '', NULL, '', 'aktif', 1, 1, 1, '2025-08-09 15:25:44', '2025-08-10 05:35:47'),
(2, 'Laporan AB', 'jj', 'pdf,doc,docx,exls', 5120, 'dokumen', '', NULL, '', 'aktif', 1, NULL, 1, '2025-08-09 19:40:05', '2025-08-09 19:40:05'),
(5, 'Berkas PDF dan Foto', '', 'pdf,jpg,png', 5000, 'dokumen', '', NULL, '', 'aktif', 2, NULL, 1, '2025-08-10 09:55:20', '2025-08-10 09:55:20');

-- --------------------------------------------------------

--
-- Struktur dari tabel `learning_progress`
--

CREATE TABLE `learning_progress` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `elemen_id` int(11) NOT NULL,
  `is_read` tinyint(1) DEFAULT 0,
  `is_bookmarked` tinyint(1) DEFAULT 0,
  `last_accessed` timestamp NULL DEFAULT NULL,
  `progress_percentage` decimal(5,2) DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `penilaian_audit`
--

CREATE TABLE `penilaian_audit` (
  `id` int(11) NOT NULL,
  `audit_id` int(11) NOT NULL,
  `departemen_id` int(11) NOT NULL,
  `nilai_final` decimal(5,2) DEFAULT NULL,
  `catatan_auditor` mediumtext DEFAULT NULL,
  `auditor_id` int(11) DEFAULT NULL,
  `status` enum('draft','submitted','reviewed','final') DEFAULT 'draft',
  `submitted_at` timestamp NULL DEFAULT NULL,
  `reviewed_at` timestamp NULL DEFAULT NULL,
  `finalized_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `penilaian_sub_elemen`
--

CREATE TABLE `penilaian_sub_elemen` (
  `id` int(11) NOT NULL,
  `sub_elemen_id` int(11) NOT NULL,
  `nilai` decimal(5,2) NOT NULL DEFAULT 0.00,
  `catatan` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_by` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data untuk tabel `penilaian_sub_elemen`
--

INSERT INTO `penilaian_sub_elemen` (`id`, `sub_elemen_id`, `nilai`, `catatan`, `created_by`, `created_at`, `updated_by`, `updated_at`) VALUES
(48, 208, 4.00, NULL, 2, '2025-08-14 04:18:22', NULL, NULL),
(49, 209, 4.00, NULL, 2, '2025-08-14 04:18:22', NULL, NULL),
(50, 210, 3.00, NULL, 2, '2025-08-14 04:18:22', NULL, NULL),
(51, 211, 4.00, NULL, 2, '2025-08-14 04:18:22', NULL, NULL),
(52, 212, 4.00, NULL, 2, '2025-08-14 04:18:22', NULL, NULL),
(53, 213, 4.00, NULL, 2, '2025-08-14 04:18:46', NULL, NULL),
(54, 215, 3.00, NULL, 2, '2025-08-14 04:18:46', NULL, NULL),
(55, 216, 4.00, NULL, 2, '2025-08-14 04:18:46', NULL, NULL),
(56, 217, 3.00, NULL, 2, '2025-08-14 04:18:46', NULL, NULL),
(57, 218, 4.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(58, 220, 2.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(59, 221, 4.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(60, 222, 4.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(61, 223, 4.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(62, 224, 4.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(63, 225, 4.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(64, 226, 4.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(65, 228, 4.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(66, 230, 4.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(67, 237, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(68, 239, 3.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(69, 240, 3.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(70, 241, 3.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(71, 243, 4.00, NULL, 2, '2025-08-14 04:21:28', NULL, NULL),
(72, 244, 4.00, NULL, 2, '2025-08-14 04:21:28', NULL, NULL),
(73, 245, 4.00, NULL, 2, '2025-08-14 04:21:28', NULL, NULL),
(74, 247, 4.00, NULL, 2, '2025-08-14 04:21:28', NULL, NULL),
(75, 248, 4.00, NULL, 2, '2025-08-14 04:21:28', NULL, NULL),
(76, 249, 4.00, NULL, 2, '2025-08-14 04:21:45', NULL, NULL),
(77, 250, 3.00, NULL, 2, '2025-08-14 04:21:45', NULL, NULL),
(78, 251, 3.00, NULL, 2, '2025-08-14 04:21:45', NULL, NULL),
(79, 252, 2.00, NULL, 2, '2025-08-14 04:21:45', NULL, NULL),
(80, 253, 4.00, NULL, 2, '2025-08-14 04:22:00', NULL, NULL),
(81, 254, 2.00, NULL, 2, '2025-08-14 04:22:00', NULL, NULL),
(82, 255, 2.00, NULL, 2, '2025-08-14 04:22:00', NULL, NULL),
(83, 256, 2.00, NULL, 2, '2025-08-14 04:22:00', NULL, NULL),
(84, 257, 1.00, NULL, 2, '2025-08-14 04:22:00', NULL, NULL),
(85, 258, 2.00, NULL, 2, '2025-08-14 04:22:00', NULL, NULL);

-- --------------------------------------------------------

--
-- Struktur dari tabel `penilaian_sub_sub_elemen`
--

CREATE TABLE `penilaian_sub_sub_elemen` (
  `id` int(11) NOT NULL,
  `sub_sub_elemen_id` int(11) NOT NULL,
  `nilai` decimal(5,2) NOT NULL DEFAULT 0.00,
  `catatan` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_by` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data untuk tabel `penilaian_sub_sub_elemen`
--

INSERT INTO `penilaian_sub_sub_elemen` (`id`, `sub_sub_elemen_id`, `nilai`, `catatan`, `created_by`, `created_at`, `updated_by`, `updated_at`) VALUES
(63, 251, 4.00, NULL, 2, '2025-08-14 04:18:46', NULL, NULL),
(64, 252, 3.00, NULL, 2, '2025-08-14 04:18:46', NULL, NULL),
(65, 253, 2.00, NULL, 2, '2025-08-14 04:18:46', NULL, NULL),
(66, 254, 3.00, NULL, 2, '2025-08-14 04:18:46', NULL, NULL),
(67, 255, 3.00, NULL, 2, '2025-08-14 04:18:46', NULL, NULL),
(68, 256, 1.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(69, 257, 1.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(70, 258, 1.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(71, 259, 4.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(72, 260, 4.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(73, 261, 1.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(74, 262, 1.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(75, 263, 3.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(76, 264, 3.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(77, 265, 3.00, NULL, 2, '2025-08-14 04:19:29', NULL, NULL),
(78, 266, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(79, 267, 3.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(80, 268, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(81, 269, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(82, 270, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(83, 271, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(84, 272, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(85, 273, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(86, 274, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(87, 275, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(88, 276, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(89, 277, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(90, 278, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(91, 279, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(92, 280, 2.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(93, 281, 2.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(94, 282, 3.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(95, 283, 2.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(96, 284, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(97, 285, 2.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(98, 286, 3.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(99, 287, 2.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(100, 288, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(101, 289, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(102, 290, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(103, 291, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(104, 292, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(105, 293, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(106, 294, 1.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(107, 295, 1.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(108, 296, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(109, 297, 4.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(110, 298, 3.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(111, 299, 3.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(112, 300, 2.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(113, 301, 2.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(114, 302, 2.00, NULL, 2, '2025-08-14 04:20:57', NULL, NULL),
(115, 303, 4.00, NULL, 2, '2025-08-14 04:21:28', NULL, NULL),
(116, 304, 4.00, NULL, 2, '2025-08-14 04:21:28', NULL, NULL),
(117, 305, 4.00, NULL, 2, '2025-08-14 04:21:28', NULL, NULL),
(118, 306, 4.00, NULL, 2, '2025-08-14 04:21:28', NULL, NULL),
(119, 307, 4.00, NULL, 2, '2025-08-14 04:21:28', NULL, NULL),
(120, 308, 1.00, NULL, 2, '2025-08-14 04:21:28', NULL, NULL),
(121, 309, 1.00, NULL, 2, '2025-08-14 04:21:28', NULL, NULL),
(122, 310, 4.00, NULL, 2, '2025-08-14 04:21:28', NULL, NULL),
(123, 311, 4.00, NULL, 2, '2025-08-14 04:21:28', NULL, NULL),
(124, 312, 4.00, NULL, 2, '2025-08-14 04:21:28', NULL, NULL);

-- --------------------------------------------------------

--
-- Struktur dari tabel `sistem_log`
--

CREATE TABLE `sistem_log` (
  `id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `action` varchar(100) NOT NULL,
  `target_type` varchar(100) DEFAULT NULL,
  `target_id` bigint(20) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data untuk tabel `sistem_log`
--

INSERT INTO `sistem_log` (`id`, `user_id`, `action`, `target_type`, `target_id`, `description`, `ip_address`, `user_agent`, `created_at`) VALUES
(1, 2, 'audit_created', 'audit', 2, 'Audit \'SMKP\' berhasil dibuat', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-08 21:51:56');

-- --------------------------------------------------------

--
-- Struktur dari tabel `sub_elemen`
--

CREATE TABLE `sub_elemen` (
  `id` int(11) NOT NULL,
  `elemen_id` int(11) NOT NULL,
  `kode_sub_elemen` varchar(20) NOT NULL,
  `nama_sub_elemen` varchar(200) NOT NULL,
  `deskripsi` mediumtext DEFAULT NULL,
  `panduan_pengumpulan_data` mediumtext DEFAULT NULL,
  `standar_kualitas` mediumtext DEFAULT NULL,
  `contoh_dokumen` mediumtext DEFAULT NULL,
  `poin_maksimal` int(11) NOT NULL,
  `urutan_tampil` int(11) NOT NULL,
  `status` enum('aktif','nonaktif') DEFAULT 'aktif',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data untuk tabel `sub_elemen`
--

INSERT INTO `sub_elemen` (`id`, `elemen_id`, `kode_sub_elemen`, `nama_sub_elemen`, `deskripsi`, `panduan_pengumpulan_data`, `standar_kualitas`, `contoh_dokumen`, `poin_maksimal`, `urutan_tampil`, `status`, `created_at`, `updated_at`) VALUES
(208, 32, 'I.1', 'Penyusunan Kebijakan', 'Komitmen Keselamatan Pertambangan tertulis dalam bentuk kebijakan tertulis1			', 'Komitmen Keselamatan Pertambangan tertulis dalam bentuk kebijakan tertulis1			', 'Komitmen Keselamatan Pertambangan tertulis dalam bentuk kebijakan tertulis1			', 'Komitmen Keselamatan Pertambangan tertulis dalam bentuk kebijakan tertulis1			', 4, 1, 'aktif', '2025-08-11 08:29:46', '2025-08-20 07:17:43'),
(209, 32, 'I.2', 'lsi  Kebiiakan', '', '', '', '', 4, 2, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(210, 32, 'I.3', 'Penetapan Kebijakan', '', '', '', '', 3, 3, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(211, 32, 'I.4', 'Komunikasi Kebijakan', '', '', '', '', 4, 4, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(212, 32, 'I.5', 'Tinjauan Kebijakan', '', '', '', '', 4, 5, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(213, 33, 'II.1', 'Penelaahan Awal', '', '', '', '', 4, 1, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(214, 33, 'II.2', 'Manajemen Risiko', '', '', '', '', 15, 2, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(215, 33, 'II.3', 'Identifikasi dan Kepatuhan Terhadap Ketentuan Peraturan Perundang-undangan dan Persyaratan Lainnya yang Terkait', '', '', '', '', 3, 3, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(216, 33, 'II.4', 'Penetapan Tujuan, Sasaran, dan Program', '', '', '', '', 4, 4, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(217, 33, 'II.5', 'Rencana Kerja dan Anggaran Keselamatan Pertambangan', '', '', '', '', 3, 5, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(218, 34, 'III.1', 'Penyusunan dan Penetapan Struktur Organisasi, Tugas, Tanggung Jawab, dan Wewenang', '', '', '', '', 4, 1, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(219, 34, 'III.2', 'Penunjukan KTT, Kepala Tambang Bawah Tanah, dan/atau Kepala Kapal Keruk untuk Perusahaan Pertambangan', '', '', '', '', 3, 2, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(220, 34, 'III.3', 'Penunjukan PJO Untuk Perusahaan Jasa Pertambangan', '', '', '', '', 2, 3, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(221, 34, 'III.4', 'Pembentukan dan Penetapan Bagian K3 Pertambangan dan KO Pertambangan', '', '', '', '', 4, 4, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(222, 34, 'III.5', 'Penunjukan Pengawas Operasional dan Pengawas Teknik', '', '', '', '', 4, 5, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(223, 34, 'III.6', 'Penunjukan Tenaga Teknik Khusus Pertambangan', '', '', '', '', 4, 6, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(224, 34, 'III.7', 'Pembentukan dan Penetapan Komite Keselamatan Pertambangan', '', '', '', '', 4, 7, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(225, 34, 'III.8', 'Penunjukan Tim Tanggap Darurat', '', '', '', '', 4, 8, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(226, 34, 'III.9', 'Seleksi dan Penempatan Personel', '', '', '', '', 4, 9, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(227, 34, 'III.10', 'Penyelenggaraan dan Pelaksanaan Pendidikan dan Pelatihan Serta Kompetensi Kerja', '', '', '', '', 8, 10, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(228, 34, 'III.11', 'Penyusunan, Penetapan, dan Penerapan Komunikasi Keselamatan Pertambangan', '', '', '', '', 4, 11, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(229, 34, 'III.12', 'Pengelolaan Administrasi Keselamatan Pertambangan', '', '', '', '', 11, 12, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(230, 34, 'III.13', 'Penyusunan, Penerapan, dan Pendokumentasian Prosedur Partisipasi, Konsultasi, Motivasi, dan Kesadaran Penerapan SMKP Minerba', '', '', '', '', 4, 13, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(231, 35, 'IV.1', 'Pelaksanaan Pengelolaan Operasional', '', '', '', '', 11, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(232, 35, 'IV.2', 'Pelaksanaan Pengelolaan Lingkungan Kerja', '', '', '', '', 40, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(233, 35, 'IV.3', 'Pelaksanaan Pengelolaan Kesehatan Kerja', '', '', '', '', 28, 3, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(234, 35, 'IV.4', 'Pelaksanaan Pengelolaan KO Pertambangan', '', '', '', '', 20, 4, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(235, 35, 'IV.5', 'Pelaksanaan Pengelolaan Bahan Peledak dan Peledakan', '', '', '', '', 10, 5, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(236, 35, 'IV.6', 'Penetapan Sistem Perancangan dan Rekayasa', '', '', '', '', 6, 6, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(237, 35, 'IV.7', 'Penetapan Sistem Pembelian', '', '', '', '', 4, 7, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(238, 35, 'IV.8', 'Pemantauan dan Pengelolaan Perusahaan Jasa Pertambangan', '', '', '', '', 6, 8, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(239, 35, 'IV.9', 'Pengelolaan Keadaan Darurat', '', '', '', '', 3, 9, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(240, 35, 'IV.10', 'Penyediaan dan Penyiapan P3K', '', '', '', '', 3, 10, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(241, 35, 'IV.11', 'Pelaksanaan keselamatan di luar pekerjaan (off the job safety)', '', '', '', '', 3, 11, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(242, 36, 'V.1', 'Pemantauan dan pengukuran kinerja', '', '', '', '', 20, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(243, 36, 'V.2', 'Inspeksi Pelaksanaan Keselamatan Pertambangan	', '', '', '', '', 4, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(244, 36, 'V.3', 'Evaluasi kepatuhan Terhadap Ketentuan Peraturan Perundang-Undangan dan Persyaratan Lainnya Yang Terkait', '', '', '', '', 4, 3, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(245, 36, 'V.4', 'Penyelidikan Kecelakaan, Kejadian Berbahaya, dan Penyakit Akibat Kerja', '', '', '', '', 4, 4, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(246, 36, 'V.5', 'Evaluasi Pengelolaan Administrasi Keselamatan Pertambangan', '', '', '', '', 14, 5, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(247, 36, 'V.6', 'Audit Internal Penerapan SMKP Minerba atau SMKP Khusus untuk pengolahan dan/ atau pemurnian', '', '', '', '', 4, 6, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(248, 36, 'V.7', 'Rencana Perbaikan dan Tindak Lanjut', '', '', '', '', 4, 7, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(249, 37, 'VI.1', 'Penyusunan Penetapan dan Pendokumentasian Manual SMKP Minerba atau SMKP Khusus pada Pengolahan dan/atau Pemurnian	', '', '', '', '', 4, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(250, 37, 'VI.2', 'Penyusunan Penetapan, Penerapan dan Pendokumentasian Prosedur pengendalian Dokumen Keselamatan Pertambangan', '', '', '', '', 3, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(251, 37, 'VI.3', 'Penyusunan Penetapan, Penerapan dan Pendokumentasian Prosedur pengendalian Rekaman Keselamatan Pertambangan', '', '', '', '', 3, 3, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(252, 37, 'VI.4', 'Penetapan Jenis Dokumen dan Rekaman', '', '', '', '', 2, 4, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(253, 38, 'VII.1', 'Pelaksanaan Tinjauan Manajemen Penerapan SMKP Minerba atau SMKP Khusus pada pengolahan dan/atau Pemurnian oleh Manajemen Tertinggi Perusahaan', '', '', '', '', 4, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(254, 38, 'VII.2', 'Pendokumentasian Catatan Hasil Tinjauan Manajemen', '', '', '', '', 2, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(255, 38, 'VII.3', 'Keluaran dari Tinjauan Manajemen Keselamatan Pertambangan', '', '', '', '', 2, 3, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(256, 38, 'VII.4', 'Pencatatan, Pendokumentasian, dan Pelaporan Hasil Tinjauan Manajemen', '', '', '', '', 2, 4, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(257, 38, 'VII.5', 'Pelaksanaan Peningkatan Kinerja', '', '', '', '', 1, 5, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(258, 38, 'VII.6', 'Penggunaan Tinjauan Hasil dari Tindak Lanjut Rencana Perbaikan dalam Penentuan Kebijakan', '', '', '', '', 2, 6, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(259, 39, 'I.1', 'Penyusunan Kebijakan', 'Penyusunan kebijakan mempertimbangkan hasil tinjauan awal dan masukan dari para Pekerja, dengan ketentuan\r\nsebagai berikut:\r\n1. melakukan tinjauan awal kondisi Keselamatan Pertambangan yang paling sedikit terdiri atas:\r\na. peninjauan risiko Keselamatan Pertambangan;\r\nb. perbandingan penerapan Keselamatan Pertambangan dengan Pemegang IUP, IUPK, IUP Operasi Produksi khusus untuk Pengolahan dan/atau Pemurnian, IPR, atau IUJP lain dan/atau sektor lain yang lebih baik;\r\nc. penilaian efisiensi dan efektivitas sumber daya\r\nyang disediakan.\r\n2. melibatkan Pekerja dan/atau memperhatikan masukan dari serikat Pekerja.', '', '', '', 4, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-24 09:18:06'),
(260, 39, 'I.2', 'lsi  Kebiiakan', 'Isi kebijakan memuat : \r\n1. Terdapat visi, misi, dan tujuan Pemegang IUP, IUPK, IUP Operasi Produksi khusus untuk Pengolahan dan/atau Pemurnian, IPR, atau IUJP terkait aspek Keselamatan Pertambangan.\r\n2. Komitmen dalam melaksanakan Keselamatan Pertambangan, yang mencakup:\r\na. peningkatan berkelanjutan dalam upaya untuk mencegah kecelakaan, Penyakit Akibat Kerja, kejadian akibat penyakit tenaga kerja, dan kejadian berbahaya, serta dalam upaya untuk mencegah kerusakan aset dan terhentinya produksi, menciptakan kegiatan operasional tambang yang aman, efisien, dan produktif serta mewujudkan budaya Keselamatan Pertambangan;\r\nb. pematuhan ketentuan peraturan perundang-undangan di bidang Keselamatan Pertambangan serta persyaratan lainnya yang terkait; dan\r\nc. dorongan untuk melibatkan Pekerja dalam pengelolaan keselamatan Pertambangan.\r\n\r\nIsi kebijakan harus diturunkan menjadi program Keselamatan Pertambangan Perusahaan dalam membuat dan menetapkan program keselamatan kerja Pertambangan didasarkan pada:\r\n1) peraturan perundang-undangan dan standar terkait yang berlaku;\r\n2) persyaratan lainnya yang terkait;\r\n3) kebijakan perusahaan;\r\n4) hasil Manajemen Risiko terhadap seluruh proses, kegiatan, dan area kerja;\r\n5) evaluasi kinerja program keselamatan kerja Pertambangan\r\n6) hasil pemeriksaan terhadap kecelakaan dan Kejadian Berbahaya; dan\r\n7) ketersediaan sumber daya, antara lain manusia, finansial, peralatan. \r\n\r\nPerusahaan melakukan pengukuran pencapaian program yang ditetapkan dengan menggunakan parameter tertentu sebagai dasar penilaian keberhasilan program Keselamatan Pertambangan. Program Keselamatan Pertambangan ditetapkan dan disahkan oleh Komite Keselamatan Pertambangan. ', '1. Visi Misi Perusahaan\r\n2. Kebijakan MPKLH Perusahaan', '', '', 4, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-24 09:31:42'),
(261, 39, 'I.3', 'Penetapan Kebijakan', 'Penetapan kebijakan mengikuti ketentuan:\r\n1. tertulis, tertanggal, dan ditandatangani;\r\n2. disahkan oleh pimpinan tertinggi Pemegang IUP, IUPK, IUP Operasi Produksi khusus untuk Pengolahan dan/atau Pemurnian, IPR, dan IUJP; dan\r\n3. bersifat dinamis, yaitu menyesuaikan perubahan yang ada di Pemegang IUP, IUPK, IUP Operasi Produksi khusus untuk Pengolahan dan/atau Pemurnian, IPR, dan IUJP .', '', '', '', 3, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-24 09:33:30'),
(262, 39, 'I.4', 'Komunikasi Kebijakan', 'Kebijakan dijelaskan dan disebarluaskan kepada Pekerja dan orang yang diberi izin masuk oleh\r\nKTT, dengan ketentuan:\r\n1. menggunakan bahasa yang dapat dipahami oleh Pekerja;\r\n2. menggunakan beberapa media seperti papan pengumuman, brosur, verbal dalam apel\r\n(briefing), dan/atau media lainnya; dan\r\n3. dilakukan evaluasi pemahaman isi kebijakan.', '1. Komunikasi kebijakan melalui kuisioner\r\n2. Komunikasi kebijakan melalui verbal; general safety talk, p5m atau meeting K3LH\r\n3. Komunikasi kebijakan melalui media cetak; spanduk, poster, dll', '', '', 4, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-24 09:36:29'),
(263, 39, 'I.5', 'Tinjauan Kebijakan', 'Peninjauan dilakukan oleh manajemen secara berkala, dengan menyesuaikan kondisi yang dihadapi Pemegang IUP, IUPK, IUP Operasi Produksi khusus untuk Pengolahan dan/atau Pemurnian, IPR, dan IUJP saat ini dan tantangan ke depan, seperti:\r\n1. adanya perubahan yang terjadi di dalam Pemegang IUP, IUPK, IUP Operasi Produksi khusus untuk Pengolahan\r\ndan/atau Pemurnian, IPR, dan IUJP (internal); dan\r\n2. adanya perubahan yang terjadi di luar pemegang IUP, IUPK, IUP Operasi Produksi khusus untuk Pengolahan\r\ndan/atau Pemurnian, IPR, dan IUJP (eksternal), seperti ketentuan peraturan perundang-undangan dan standar.\r\n\r\nPenetapan dan pelaksanaan manajemen perubahan paling sedikit terhadap perubahan proses, teknologi, peralatan yang kritikal. Manajemen perubahan dilakukan apabila terjadi perubahan pada sarana, prasarana, instalasi, dan peralatan Pertambangan paling sedikit meliputi:\r\na. spesifikasi;\r\nb. fungsi; dan/atau\r\nc. peralatan keselamatan.', '', '', '', 4, 5, 'aktif', '2025-08-14 04:24:16', '2025-08-24 09:39:27'),
(264, 40, 'II.1', 'Penelaahan Awal', 'Sebelum mulai mengembangkan Sistem Manajemen Keselamatan Pertambangan perusahaan harus melakukan\r\npenelaahan awal, yang dijadikan sebagai base line assessment untuk mengetahui kondisi keselamatan pertambangan di suatu perusahaan, yang memperimbangkan beberapa faktor:\r\n1. Sistematika Proses Bisnis Dan Interaksi Proses;\r\n2. Penyesuaian Terhadap Ketentuan Peraturan Perundang-undangan Dan Standar;\r\n3. Peninjauan Terhadap Kebijakan Keselamatan Pertambangan Yang Disesuaikan Dengan\r\nAngka (1) Dan (2).', '', '0 : Tidak ada bukti telah melakukan penelaahan awal dalam perencanaan\r\n1 : Terdapat bukti telah melakukan penelaahan awal dalam perencanaan, namun belum menentukan tingkat pencapaian kinerja Keselamatan Pertambangan\r\n2 : Terdapat bukti telah melakukan penelaahan awal dalam perencanaan, dan telah menentukan tingkat pencapaian kinerja Keselamatan Pertambangan, namun tidak sesuai dengan kondisi\r\n3 : Terdapat bukti telah melakukan penelaahan awal dalam perencanaan, menentukan tingkat pencapaian kinerja Keselamatan Pertambangan yang telah sesuai dengan kondisi, namun belum sinkron dengan program Keselamatan Pertambangan yang ditetapkan\r\n4 : Terdapat bukti telah melakukan penelaahan awal dalam perencanaan, menentukan tingkat pencapaian kinerja Keselamatan Pertambangan yang telah sesuai dengan kondisi, dan telah sinkron dengan program Keselamatan Pertambangan yang ditetapkan', '', 4, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-20 05:23:15'),
(265, 40, 'II.2', 'Manajemen Risiko', 'Manajemen Risiko\r\n\r\na. Pemegang IUP, IUPK, IUP Operasi Produksi Khusus Untuk Pengolahan Dan/Atau Pemurnian, IPR, Dan IUJP Menyusun, Menetapkan, Menerapkan, Dan Mendokumentasikan Prosedur Manajemen Risiko Sesuai Dengan Jenis Dan Skala Pemegang IUP, IUPK, IUP Operasi Produksi Khusus Untuk Pengolahan Dan/Atau Pemurnian, IPR, Dan IUJP.\r\n\r\nb. Proses Manajemen Risiko Dilakukan Secara Terintegrasi Dengan Sistem Manajemen Pemegang IUP, IUPK, IUP Operasi Produksi Khusus Untuk Pengolahan Dan/Atau Pemurnian, IPR, Dan IUJP Sesuai Dengan Bisnis Proses Pemegang IUP, IUPK, IUP Operasi Produksi Khusus Untuk Pengolahan Dan/Atau Pemurnian, IPR, Dan IUJP.\r\n\r\nc. Proses Manajemen Risiko Yang Dilakukan Pemegang IUP, IUPK, IUP Operasi Produksi Khusus Untuk Pengolahan Dan/Atau Pemurnian, IPR, Dan IUJP Meliputi 5 (Lima) Kegiatan, Terdiri Atas:\r\n1. Komunikasi Dan Konsultasi Risiko\r\n2. Penetapan Konteks\r\n3. Identifikasi Bahaya\r\n4. Penilaian Dan Pengendalian Risiko\r\n5. Pemantauan Dan Peninjauan', '', '', '', 15, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-20 03:35:56'),
(266, 40, 'II.3', 'Identifikasi dan Kepatuhan Terhadap Ketentuan Peraturan Perundang-undangan dan Persyaratan Lainnya yang Terkait', 'Perusahaan Harus Mengidentifikasi, Memperoleh, Dan Memantau Ketentuan Peraturan Perundang-undangan Dan Persyaratan Lainnya Yang Terkait, Kemudian Dievaluasi Apakah Memiliki Dampak Terhadap Perusahaan Atau Menjadi Persyaratan Dalam Proses Perusahaan.\r\n\r\nIdentifikasi Dan Pemantauan Terhadap Ketentuan Peraturan Perundang-undangan Dan Persyaratan Lainnya Yang Terkait, Dengan Ketentuan:\r\na) Pemegang IUP, IUPK, IUP Operasi Produksi Khusus Untuk Pengolahan Dan/ Atau Pemurnian, IPR, Dan IUJP Menjalankan Proses Formal Untuk Mengidentifikasi, Memperoleh, Dan Memantau Ketentuan Peraturan Perundang-undangan Dan Persyaratan Lainnya Yang Terkait.\r\nb) Pemegang Iup, Lupk, IUP Operasi Produksi Khusus Untuk Pengolahan Dan/Atau Pemurnian, IPR, Dan IUJP Menentukan Kesesuaian Ketentuan Peraturan Perundang-undangan Yang Spesifik Terhadap Operasi, Proses,\r\nKegiatan, Dan Fasilitas Pemegang IUP, IUPK, IUPK Operasi Produksi Khusus Untuk Pengolahan Dan/Atau Pemurnian, IPR, Dan IUJP Dan\r\nc) Pengkajian Terhadap Ketentuan Peraturan Perundangundangan Dilakukan Jika Terdapat Perubahan Atas Ketentuan Peraturan Perundang-Undangan Tersebut Yang Berpotensi Menimbulkan Dampak Atau Pengaruh Tearhadap Operasi, Proses, Kegiatan, Dan Fasilitas Pemegang Lup, Lupk, Lup Operasi Produksi Khusus Untuk Pengolahan Darr/Atau Pemurnian, Lpr, Dan Lujp', '', '0 : Tidak ada bukti telah melakukan identifikasi dan kepatuhan ketentuan peraturan perundang-undangan\r\ndan persyaratan lainnya yang terkait\r\n1 : Terdapat bukti telah melakukan identifikasi dan pemantauan terhadap ketentuan peraturan perundang-undangan dan persyaratan lainnya, namun belum melakukan evaluasi kepatuhan terhadap ketentuan peraturan perundang-undangan dan persyaratan perizinan\r\n2 : Terdapat bukti telah melakukan identifikasi dan pemantauan terhadap ketentuan peraturan perundang-undangan dan persyaratan lainnya, namun berdasarkan hasil evaluasi masih terdapat beberapa peraturan perundang-undangan dan/atau persyaratan perizinan tidak dipatuhi\r\n3 : Terdapat bukti telah melakukan identifikasi dan pemantauan terhadap ketentuan peraturan perundang-undangan dan persyaratan lainnya, dan berdasarkan evaluasi telah mematuhi ketentuan peraturan perundang-undangan dan persyaratan perizinan', '', 3, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-20 07:30:46'),
(267, 40, 'II.4', 'Penetapan Tujuan, Sasaran, dan Program', 'Tujuan Dan Sasaran Adalah Objective Atau Misi Yang Ingin Dicapai Oleh Suatu Perusahaan Dalam Aspek Keselamatan Pertambangan\r\n\r\nProgram Keselamatan Pertambangan Adalah Cara/Langkah Untuk Mencapai Objective (Tujuan dan Sasaran)\r\n1. Ketentuan Peraturan Perundangan Yang Terkait Dengan Bisnis Organisasi, dan Hal-hal Yang Bersifat Mandatory (Wajib) Yang Akan Memberikan Dampak Kepada Perusahaan\r\n2. Kebijakan Perusahaan Secara Menyeluruh, Termasuk Kebijakan Dalam Bidang Keselamatan Pertambangan, Agar Objektif Program Pada Aspek Keselamatan Pertambangan Sejalan Dengan Objektif Perusahaan\r\n3. Dari Manajemen Risiko Akan Diketahui Risiko-Risko Yang Ada Pada Proses Rutin Aktivitas Perusahaan Terkait Aspek Keselamatan Pertambangan\r\n4. Dari Evaluasi Kinerja Program Keselamatan Pertambangan, Diketahui Strategi Yang Tepat Untuk Langkah Perbaikan Di Masa Yang Akan Datang\r\n5. Rekaman Kejadian Kecelakaan, Kejadian Berbahaya, Kejadian Akibat Penyakit Tenaga Kerja, Dan Penyakit Akibat Kerja Turut Menjadi Bahan Pembelajaran\r\n6. Sumber Daya Diperlukan Untuk Mencapai Program Kerja Yang Telah Ditetapkan\r\n7. Jangka Waktu Atau Jadwal Pelaksanaan', '', '0 : Tidak ada bukti telah melakukan penetapan tujuan, sasaran, dan program\r\n1 : Terdapat bukti telah melakukan penetapan tujuan, sasaran, dan program, namun belum selaras dengan kebijakan, belum terukur, dan belum disahkan oleh Komite Keselamatan Pertambangan\r\n2 : Terdapat bukti telah melakukan penetapan tujuan, sasaran, dan program dengan kondisi:\r\n• telah disahkan oleh Komite Keselamatan Pertambangan;\r\n• sebagian besar tujuan, sasaran, program, yang ditetapkan belum selaras dengan kebijakan dan belum terukur; dan\r\n• penyusunan program belum mempertimbangkan seluruh ketentuan penyusunan\r\n3 : Terdapat bukti telah melakukan penetapan tujuan, sasaran, dan program dengan kondisi:\r\n• telah disahkan oleh Komite Keselamatan Pertambangan;\r\n• seluruh besar tujuan, sasaran, program, yang ditetapkan telah selaras dengan kebijakan dan telah terukur; dan\r\n• penyusunan program belum seluruhnya mempertimbangkan seluruh ketentuan penyusunan\r\n4 : Terdapat bukti telah melakukan penetapan tujuan, sasaran, dan program dengan kondisi:\r\n• telah disahkan oleh Komite Keselamatan Pertambangan;\r\n• seluruh besar tujuan, sasaran, program, yang ditetapkan telah selaras dengan kebijakan dan telah terukur; dan\r\n• penyusunan program telah seluruhnya mempertimbangkan seluruh ketentuan penyusunan', '', 4, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-20 07:40:39'),
(268, 40, 'II.5', 'Rencana Kerja dan Anggaran Keselamatan Pertambangan', 'Ketentuan Rencana Kerja dan Anggaran Biaya :\r\na. Pemegang IUP, IUPK, IUP Operasi Produksi Khusus Untuk Pengolahan Dan/Atau Pemurnian Melakukan\r\nPenetapan Rencana Kerja Dan Anggaran Biaya Aspek Keselamatan Pertambangan Sesuai Dengan Rencana Kerja\r\nDan Anggaran Biaya Tahunan Yang Telah Mendapat Persetujuan Dari Direktur Jenderal Atas Nama Menteri Atau Gubernur Sesuai Dengan Kewenangannya;\r\nb. Pemegang IUJP Memiliki Rencana Kerja Dan Anggaran Biaya Aspek Keselamatan Pertambangan Yang Sesuai\r\nDengan Persetujuan Dari Pemegang IUP, IUPK, IUP Operasi Produksi Khusus Untuk Pengolahan Dan/Atau Pemurnian;\r\nc. Rencana Kerja Dan Anggaran Biaya Keselamatan Pertambangan Yang Ditetapkan Mempertimbangkan:\r\n• Skala Prioritas Sasaran Dan Program Keselamatan Pertambangan;\r\n• Kebutuhan Untuk Perbaikan Dan Peningkatan Keselamatan Pertambangan Yang Berkelanjutan; Dan\r\n• Pemenuhan Terhadap Peraturan Perundang-undangan Dan Persyaratan Lainnya Yang Terkait.', '', '0 : Tidak ada bukti telah memiliki rencana kerja anggaran dan biaya aspek Keselamatan\r\nPertambangan yang sesuai dengan persetujuan dari pemegang IUP\r\n1 : Terdapat bukti telah memiliki rencana kerja dan anggaran biaya Keselamatan Pertambangan, namun penyusunannya belum mempertimbangkan skala prioritas sasaran dan program Keselamatan Pertambangan dan kebutuhan untuk perbaikan dan peningkatan Keselamatan Pertambangan yang berkelanjutan, dan pemenuhan terhadap peraturan perundang-undangan dan persyaratan lainnya yang terkait dan belum sesuai dengan persetujuan dari pemegang IUP\r\n2 : Terdapat bukti telah memiliki rencana kerja dan anggaran biaya Keselamatan Pertambangan yang penyusunannya telah mempertimbangkan skala prioritas sasaran dan program Keselamatan Pertambangan dan kebutuhan untuk perbaikan dan peningkatan Keselamatan Pertambangan yang berkelanjutan, dan pemenuhan terhadap peraturan perundang-undangan dan persyaratan lainnya yang terkait, namun belum sesuai dengan persetujuan dari pemegang IUP\r\n3 : Terdapat bukti telah memiliki rencana kerja anggaran dan biaya aspek Keselamatan Pertambangan yang sesuai dengan persetujuan dari pemegang IUP', '', 3, 5, 'aktif', '2025-08-14 04:24:16', '2025-08-20 08:00:12'),
(269, 41, 'III.1', 'Penyusunan dan Penetapan Struktur Organisasi, Tugas, Tanggung Jawab, dan Wewenang', 'Pimpinan dan jajaran manajemen pemegang IUP, IUPK, IUP Operasi Produksi khusus untuk Pengolahan dan/atau Pemurnian, IPR, dan IUJP menunjukkan komitmen Keselamatan Pertambangan dengan cara:\r\n1. Memastikan ketersediaan dan kecukupan sumber daya yang memadai untuk menetapkan, menerapkan, dan mendokumentasikan serta terus menerus meningkatkan SMKP Minerba atau SMKP khusus pada Pengolahan dan/atau Pemurnian\r\n2. Menetapkan tugas, wewenang, tanggung jawab, dan akuntabilitas untuk memfasilitasi penerapan SMKP Minerba atau SMKP khusus pada Pengolahan dan/atau Pemurnian yang efektif dan kegiatan ini didokumentasikan secara tertulis serta dikomunikasikan\r\n3. Memasukkan Keselamatan Pertambangan dalam tugas dan tanggung jawab pimpinan dan jajaran manajemen pemegang IUP, IUPK, IUP Operasi Produksi khusus untuk Pengolahan dan/atau Pemurnian, IPR, dan IUJP; dan\r\n4. Mengkaji ulang secara berkala struktur organisasi pemegang IUP, IUPK, IUP Operasi Produksi khusus untuk Pengolahan dan/atau Pemurnian, IPR, dan IUJP, tugas, wewenang, tanggung jawab, dan akuntabilitas.', '1. Struktur organisasi, tugas, tanggung jawab dan wewenang manajemen dan personel PT KPP jobsite AGMR\r\n2. Surat pengangkatan manajemen\r\n', '', '', 4, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-24 10:07:40'),
(271, 41, 'III.3', 'Penunjukan PJO Untuk Perusahaan Jasa Pertambangan', 'PENUJUKAN PJO\r\na. penunjukan dilakukan oleh pimpinan pemegang perusahaan jasa Pertambangan dan mendapat pengesahan dari KTT atau PTL. KTT atau PTL dapat menerima, menolak, atau meminta penggantian PJO berdasarkan pertimbangan kompetensi, komitmen, dan kinerja PJO terhadap pengelolaan Keselamatan Pertambangan; dan\r\nb. PJO memenuhi persyaratan administrasi dan persyaratan teknis sesuai dengan ketentuan peraturan perundang-undangan.\r\n\r\nPenanggung Jawab Operasional yang selanjutnya disingkat PJO adalah orang yang menduduki jabatan tertinggi dalam struktur organisasi perusahaan jasa pertambangan di wilayah kegiatan usaha pertambangan, dan bertanggung jawab kepada KTT/PTL atas dilaksanakan dan ditaatinya peraturan perundang-undangan mengenai kaidah teknik pertambangan yang baik.\r\n\r\nPersyaratan Administrasi\r\n1. Pekerja perusahaan jasa pertambangan\r\n2. Riwayat hidup calon PJO\r\n3. Jabatan tertinggi di site\r\n4. Surat dukungan dari Direksi Perusahaan Jasa Pertambangan\r\n5. Surat pernyataan komitmen calon PJO\r\n6. Uji kemahiran berbahasa Indonesia (madya) untuk TKA\r\n7. Syarat lain yang ditentukan oleh KTT\r\n\r\nPersyaratan Teknis\r\n1. Memahami aspek pengelolaan usaha jasa pertambangan\r\n2. Memahami aspek teknis pertambangan, konservasi, keselamatan pertambangan, dan perlindungan lingkungan\r\n3. Memahami kewajiban dan sanksi usaha jasa pertambangan\r\n4. Jenjang sertifikat kompetensi pengawas operasional atau sertifikat kualifikasi yang diakui oleh KaIT', 'Surat penujukan dan pengesahan PJO oleh KTT', '', '', 2, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-24 11:11:51'),
(272, 41, 'III.4', 'Pembentukan dan Penetapan Bagian K3 Pertambangan dan KO Pertambangan', 'Bagian K3 dan KO bertanggung jawab langsung kepada PJO pada bisnis proses IUJP\r\n\r\nBagian K3 Pertambangan, K3 Pengolahan dan/atau Pemurnian mempunyai tugas:\r\n• mengumpulkan, menganalisis data, dan mencatat rincian dari setiap kecelakaan atau Kejadian Berbahaya,\r\nkejadian akibat penyakit tenaga kerja, Penyakit Akibat Kerja, kejadian sebelum terjadinya kecelakaan, penyebab kecelakaan, menganalisis kecelakaan, dan pencegahan kecelakaan;\r\n• mengumpulkan data mengenai area dan kegiatan yang memerlukan pengawasan yang lebih ketat dengan\r\nmaksud untuk memberi saran kepada KTT atau PTL tentang tata cara kerja dan penggunaan alat-alat deteksi\r\nserta alat-alat pelindung diri;\r\n• memberikan penerangan dan petunjuk mengenai keselamatan dan kesehatan kerja Pertambangan kepada\r\nsemua Pekerja, antara lain melalui pertemuan-pertemuan, ceramah-ceramah, diskusi-diskusi, pemutaran\r\nfilm, dan media atau alat publikasi lainnya;\r\n• membentuk dan melatih anggota tim penyelamat tambang;\r\n• menyusun statistik kecelakaan; dan\r\n• melakukan evaluasi keselamatan dan kesehatan kerja Pertambangan; dan\r\n\r\nBagian KO Pertambangan, KO Pengolahan dan/atau Pemurnian mempunyai tugas:\r\n• mengumpulkan dan mengevaluasi rekaman hasil pemeriksaan dan pemeliharaan sarana, prasarana, instalasi,\r\ndan peralatan Pertambangan;\r\n• mengumpulkan dan mengevaluasi rekaman hasil pengamanan instalasi;\r\n• mengumpulkan dan mengevaluasi rekaman hasil pengujian dan penyelidikan terhadap kelayakan sarana,\r\nprasarana, instalasi, dan peralatan Pertambangan;\r\n• mengumpulkan rekaman hasil kajian teknis Keselamatan Operasi Pertambangan, Keselamatan Operasi\r\nPengolahan dan/atau Pemurnian;\r\n• mengumpulkan data Tenaga Teknis Pertambangan yang Berkompeten; dan\r\n• mengumpulkan rekaman jadwal pemeliharaan sarana, prasarana, instalasi, dan peralatan Pertambangan; dan\r\nmelakukan analisis data dari rekaman Keselamatan Operasi Pertambangan, Keselamatan Operasi Pengolahan\r\ndan/atau Pemurnian dan memberikan rekomendasi tindak lanjut.', '1. Struktur organisasi yang mencakup bagian K3 dan bagian KO\r\n2. Surat penujukkan personal bagain K3 dan bagian KO', '', '', 4, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-24 10:22:59'),
(273, 41, 'III.5', 'Penunjukan Pengawas Operasional dan Pengawas Teknik', 'KTT atau PTL dalam melakukan tugasnya dibantu oleh pengawas operasional dan pengawas teknis. KTT atau PTL mengangkat pengawas operasional dengan menerbitkan Surat Penunjukan Pengawas Operasional, yang memenuhi syarat ketentuan peraturan perundang-undangan dan memiliki Kartu Pengawas Operasional yang disahkan oleh KaIT atau Kepala Dinas atas nama KaIT.\r\n\r\n2022 Kementerian ESDM sudah tidak lagi menerbitkan Kartu Pengawas Operasional/Teknis. Sehingga evidance yang dimaksud dapat digantikan dengan bentuk surat penunjukkan lainnya.', 'Surat penunjukkan pengawas operasional dan pengawas teknis oleh KTT terupdate.', '', '', 4, 5, 'aktif', '2025-08-14 04:24:16', '2025-08-31 08:46:56'),
(274, 41, 'III.6', 'Penunjukan Tenaga Teknik Khusus Pertambangan', 'KTT atau PTL menunjuk Tenaga Teknis Pertambangan yang Berkompeten. Tenaga Teknis Pertambangan yang Berkompeten juga mencakup juru ledak, juru ukur, juru las, juru bor, juru derek, juru rawat/paramedis, juru langsir, petugas proteksi radiasi, ahli listrik, petugas/juru ventilasi dalam hal kegiatan penambangan dilakukan dengan metode penambangan bawah tanah, petugas pertolongan pertama pada kecelakaan/first aider, petugas pemadam kebakaran, anggota tim tanggap darurat, petugas industrial hygiene, loading/berthing master, petugas bahan kimia, rigger, operator pesawat angkat/angkut, petugas gudang bahan peledak.', 'Pengajuan kepada KTT untuk membuat daftar tenaga teknis Pertambangan yang standar kompetensi kerjanya belum ditetapkan oleh Pemerintah, serta melakukan pengujian kompetensi terhadap tenaga teknis Pertambangan yang bersangkutan.', '', '', 4, 6, 'aktif', '2025-08-14 04:24:16', '2025-08-31 08:51:25'),
(275, 41, 'III.7', 'Pembentukan dan Penetapan Komite Keselamatan Pertambangan', 'IUJP membentuk dan menetapkan secara resmi Komite Keselamatan Pertambangan yang beranggotakan perwakilan dari Bagian Keselamatan dan Kesehatan Kerja, Bagian Keselamatan Operasi dan juga wakil dari Pekerja. Struktur komite Keselamatan Pertambangan paling sedikit terdiri atas; Ketua (PJO), Wakil ketua, Sekretaris, Anggota. Penetapan komite Keselamatan Pertambangan disahkan oleh KTT/PJO (/sesuai kewenangannya).', '', '', '', 4, 7, 'aktif', '2025-08-14 04:24:16', '2025-08-31 08:57:58'),
(276, 41, 'III.8', 'Penunjukan Tim Tanggap Darurat', 'KTT atau PTL menunjuk tim tanggap darurat yang memadai yang mencakup seluruh area kerja dan selalu\r\nsiap siaga setiap saat. tim tanggap darurat beranggotakan orang-orang yang memiliki keterampilan dan kompetensi yang diperlukan untuk memberikan layanan terhadap keadaan darurat. KTT atau PTL menyampaikan secara tertulis penunjukan tim tanggap darurat kepada KaIT atau Kepala Dinas atas nama KaIT. KTT atau PTL membuat program pendidikan dan pelatihan untuk menjaga dan meningkatkan keterampilan dan kompetensi anggota tim tanggap darurat.', '1. Struktur ERT yang telah di sahkan oleh KTT\r\n2. Sertifikat Training Kompetensi Personel ERT yang dikeluarkan oleh KTT.', '', '', 4, 8, 'aktif', '2025-08-14 04:24:16', '2025-08-31 09:04:39'),
(277, 41, 'III.9', 'Seleksi dan Penempatan Personel', 'a. seleksi dan penempatan personel dibuat dalam aturan tertulis;\r\nb. seleksi dan penempatan personel dilaksanakan dengan memasukkan persyaratan Keselamatan Pertambangan dan mempertimbangkan hasil identifikasi kompetensi kerja dalam proses seleksi dan penempatan personel; dan\r\nc. Kelompok Keselamatan Pertambangan Minerba setiap personel memiliki tugas dan tanggung jawab yang jelas, termasuk tugas dan tanggung jawab aspek Keselamatan Pertambangan', '', '', '', 4, 9, 'aktif', '2025-08-14 04:24:16', '2025-08-31 09:07:20'),
(278, 41, 'III.10', 'Penyelenggaraan dan Pelaksanaan Pendidikan dan Pelatihan Serta Kompetensi Kerja', 'Pendidikan dan pelatihan diberikan kepada setiap Pekerja, pengawas operasional, dan pengawas teknik, baik untuk Pekerja baru, Pekerja untuk tugas baru, pendidikan dan pelatihan untuk menghadapi bahaya, pendidikan dan pelatihan penyegaran tahunan. pendidikan dan pelatihan diberikan sesuai kebutuhan dan didasarkan pada pertimbangan KTT.\r\n1. IUJP mengidentifikasi standar kompetensi kerja Keselamatan Pertambangan dan mengembangkannya sesuai kebutuhan.\r\n2. hasil identifikasi kompetensi kerja digunakan sebagai dasar pengembangan standar kompetensi kerja Keselamatan Pertambangan, penentuan program pendidikan dan pelatihan, dan pertimbangan dalam penerimaan, seleksi, promosi, dan penilaian kinerja.\r\n3. IUJP memastikan bahwa setiap Pekerja, pengawas operasional, dan pengawas teknik memiliki kompetensi\r\nyang sesuai dengan ketentuan peraturan perundangan, standar nasional, standar internasional, dan/atau standar kompetensi kerja Keselamatan Pertambangan yang dikembangkan.', '', '', '', 8, 10, 'aktif', '2025-08-14 04:24:16', '2025-08-31 09:17:30'),
(279, 41, 'III.11', 'Penyusunan, Penetapan, dan Penerapan Komunikasi Keselamatan Pertambangan', '', '', '', '', 4, 11, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(280, 41, 'III.12', 'Pengelolaan Administrasi Keselamatan Pertambangan', '1. IUP memiliki buku tambang yang sesuai dengan ukuran dan bentuk yang ditetapkan oleh KaIT atau Kepala Dinas atas nama KaIT\r\n2. buku tambang memuat:\r\n- Larangan, perintah, dan petunjuk Inspektur Tambang yang ditindaklanjuti oleh KTT\r\n- Informasi, tindak lanjut, dan pemberitahuan dari KTT atau PTL terhadap kegiatan usaha pertambangan\r\n- buku tambang tersedia di Kantor KTT atau PTL dan isinya dapat dibaca dan dipelajari oleh para Pekerja\r\n3. IUP memiliki buku daftar kecelakaan tambang yang sesuai dengan ukuran dan bentuk yang ditetapkan oleh KaIT\r\n4. IUP mendaftarkan setiap kecelakaan tambang yang berakibat cidera ringan, berat, dan mati dalam buku daftar kecelakaan tambang\r\n5. mendaftarkan setiap kecelakaan tambang yang berakibat cidera ringan, berat, dan mati dalam buku daftar kecelakaan tambang;\r\n6. ⁠untuk Kejadian Berbahaya, kejadian akibat penyakit tenaga kerja, dan Penyakit Akibat Kerja didokumentasikan secara khusus oleh KTT atau PTL sesuai dengan format khusus yang ditentukan oleh KaIT;\r\n7. ⁠IUP menyampaikan laporan tertulis aspek Keselamatan Pertambangan kepada KaIT atau Kepala Dinas atas nama KaIT sesuai dengan ketentuan peraturan perundang-undangan, secara offline atau sistem dalam jaringan (online) melalui website yang ditentukan oleh KaIT atau Kepala Dinas atas nama KaIT; dan\r\n8. IUP mendokumentasikan, memantau, dan/atau melaporkan dokumen dan laporan pemenuhan kompetensi sesuai ketentuan peraturan perundang-undangan serta persyaratan lainnya paling sedikit mencakup:\r\n- dokumen kelayakan sarana, prasarana, dan instalasi Pertambangan\r\n- sertifikat dan laporan kompetensi tenaga kerja\r\n- lisensi antara lain Kartu Izin Meledakkan, Kartu Pekerja Peledakan, Kartu Pengawas Operasional, dan/atau surat izin mengoperasikan unit yang dikeluarkan oleh KTT\r\n- pengesahan KTT\r\n- izin kerja khusus, antara lain Izin Kerja Ruang Terbatas, Izin Kerja di Ketinggian, Izin Kerja Panas, Izin Kerja Terpapar Radioaktif.', '', '', '', 11, 12, 'aktif', '2025-08-14 04:24:16', '2025-08-31 10:21:16'),
(281, 41, 'III.13', 'Penyusunan, Penerapan, dan Pendokumentasian Prosedur Partisipasi, Konsultasi, Motivasi, dan Kesadaran Penerapan SMKP Minerba', 'Penyusunan, Penerapan, dan Pendokumentasian Prosedur Partisipasi, Konsultasi, Motivasi, dan Kesadaran Penerapan SMKP Minerba :\r\n1. KTT atau PTL menyusun, menerapkan, dan mendokumentasikan prosedur untuk partisipasi, konsultasi, motivasi, dan kesadaran Pekerja dalam penerapan SMKP Minerba\r\n2. KTT atau PTL melaksanakan program partisipasi, konsultasi, motivasi, dan kesadaran dengan melibatkan Pekerja maupun pihak lain yang terkait di dalam penerapan dan pengembangan SMKP Minerba', '', '', '', 4, 13, 'aktif', '2025-08-14 04:24:16', '2025-08-31 10:22:41'),
(282, 42, 'IV.1', 'Pelaksanaan Pengelolaan Operasional', '\r\n', '', '', '', 11, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-31 10:37:20'),
(283, 42, 'IV.2', 'Pelaksanaan Pengelolaan Lingkungan Kerja', 'IUJP menyusun, menetapkan, mensosialisasikan, menerapkan, dan mendokumentasikan prosedur pengelolaan lingkungan kerja Pertambangan yang paling sedikit terdiri atas :\r\n• Pengelolaan Debu\r\n• Pengelolaan Kebisingan\r\n• Pengelolaan Getaran\r\n• Pengelolaan Pencahayaan\r\n• Pengelolaan Kuantitas dan Kualitas Udara Kerja\r\n• ⁠Pengelolaan Iklim Kerja\r\n• ⁠Pengelolaan Radiasi\r\n• ⁠Pengelolaan Faktor Kimia\r\n• ⁠Pengelolaan Faktor Biologi\r\n• ⁠Pengelolaan Kebersihan Lingkungan Kerja\r\n\r\nPengelolaan lingkungan kerja Pertambangan dilakukan dengan cara:\r\n• antisipasi : Inventarisasi bahaya dan risiko\r\n• pengenalan : Pengenalan bahaya melalui karakteristiknya\r\n• Evaluasi : Pengukuran mengacu ketentuan & standar yg berlaku serta melibatkan petugas Hygene Industri\r\n• Pengendalian : Hierarki Pengendalian', '', '', '', 40, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-31 10:49:20'),
(284, 42, 'IV.3', 'Pelaksanaan Pengelolaan Kesehatan Kerja', 'IUJP menyusun, menetapkan, mensosialisasikan, menerapkan, dan mendokumentasikan prosedur pengelolaan kesehatan kerja Pertambangan dalam rangka menjamin kesehatan setiap Pekerja terhadap risiko kesehatan yang ditimbulkan paling sedikit oleh bahaya fisik, kimia, biologi, ergonomi, dan psikososial;\r\n\r\nIUJP membuat dan melaksanakan program kesehatan kerja Pertambangan dengan pendekatan promotif atau promosi kesehatan, preventif atau pencegahan penyakit, kuratif atau pengobatan dan rehabilitatif atau pemulihan. Dengan lebih mengutamakan pada program promotif dan preventif mengacu kepada peraturan perundang-undangan dan standar terkait yang berlaku.', '', '', '', 28, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-31 10:53:56'),
(285, 42, 'IV.4', 'Pelaksanaan Pengelolaan KO Pertambangan', 'Pelaksanaan Pengelolaan KO Pertambangan mencakup :\r\n1 Sistem dan Pelaksanaan Pemeliharaan/Perawatan Sarana, Prasarana, Instalasi, dan Peralatan Pertambangan\r\n2 Pengamanan Instalasi\r\n3 Kelayakan Sarana, Prasarana, Instalasi, dan Peralatan Pertambangan\r\n4 Kompetensi Tenaga Teknik\r\n5 Evaluasi Laporan Hasil Kajian Teknis Pertambangan', '', '', '', 20, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:29:56'),
(286, 42, 'IV.5', 'Pelaksanaan Pengelolaan Bahan Peledak dan Peledakan', '', '', '', '', 10, 5, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(287, 42, 'IV.6', 'Penetapan Sistem Perancangan dan Rekayasa', '', '', '', '', 6, 6, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(288, 42, 'IV.7', 'Penetapan Sistem Pembelian', '', '', '', '', 4, 7, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(289, 42, 'IV.8', 'Pemantauan dan Pengelolaan Perusahaan Jasa Pertambangan', '', '', '', '', 6, 8, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(290, 42, 'IV.9', 'Pengelolaan Keadaan Darurat', '', '', '', '', 3, 9, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(291, 42, 'IV.10', 'Penyediaan dan Penyiapan P3K', '', '', '', '', 3, 10, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(292, 42, 'IV.11', 'Pelaksanaan keselamatan di luar pekerjaan (off the job safety)', '', '', '', '', 3, 11, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(293, 43, 'V.1', 'Pemantauan dan pengukuran kinerja', '', '', '', '', 20, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(294, 43, 'V.2', 'Inspeksi Pelaksanaan Keselamatan Pertambangan	', '', '', '', '', 4, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(295, 43, 'V.3', 'Evaluasi kepatuhan Terhadap Ketentuan Peraturan Perundang-Undangan dan Persyaratan Lainnya Yang Terkait', '', '', '', '', 4, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(296, 43, 'V.4', 'Penyelidikan Kecelakaan, Kejadian Berbahaya, dan Penyakit Akibat Kerja', '', '', '', '', 4, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(297, 43, 'V.5', 'Evaluasi Pengelolaan Administrasi Keselamatan Pertambangan', '', '', '', '', 12, 5, 'aktif', '2025-08-14 04:24:16', '2025-08-20 08:35:38'),
(298, 43, 'V.6', 'Audit Internal Penerapan SMKP Minerba atau SMKP Khusus untuk pengolahan dan/ atau pemurnian', '', '', '', '', 4, 6, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(299, 43, 'V.7', 'Rencana Perbaikan dan Tindak Lanjut', '', '', '', '', 4, 7, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(300, 44, 'VI.1', 'Penyusunan Penetapan dan Pendokumentasian Manual SMKP Minerba atau SMKP Khusus pada Pengolahan dan/atau Pemurnian	', '', '', '', '', 4, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(301, 44, 'VI.2', 'Penyusunan Penetapan, Penerapan dan Pendokumentasian Prosedur pengendalian Dokumen Keselamatan Pertambangan', '', '', '', '', 3, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(302, 44, 'VI.3', 'Penyusunan Penetapan, Penerapan dan Pendokumentasian Prosedur pengendalian Rekaman Keselamatan Pertambangan', '', '', '', '', 3, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(303, 44, 'VI.4', 'Penetapan Jenis Dokumen dan Rekaman', '', '', '', '', 2, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(304, 45, 'VII.1', 'Pelaksanaan Tinjauan Manajemen Penerapan SMKP Minerba atau SMKP Khusus pada pengolahan dan/atau Pemurnian oleh Manajemen Tertinggi Perusahaan', '', '', '', '', 4, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(305, 45, 'VII.2', 'Pendokumentasian Catatan Hasil Tinjauan Manajemen', '', '', '', '', 2, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(306, 45, 'VII.3', 'Keluaran dari Tinjauan Manajemen Keselamatan Pertambangan', '', '', '', '', 2, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(307, 45, 'VII.4', 'Pencatatan, Pendokumentasian, dan Pelaporan Hasil Tinjauan Manajemen', '', '', '', '', 2, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(308, 45, 'VII.5', 'Pelaksanaan Peningkatan Kinerja', '', '', '', '', 1, 5, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(309, 45, 'VII.6', 'Penggunaan Tinjauan Hasil dari Tindak Lanjut Rencana Perbaikan dalam Penentuan Kebijakan', '', '', '', '', 2, 6, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16');

-- --------------------------------------------------------

--
-- Struktur dari tabel `sub_elemen_berkas`
--

CREATE TABLE `sub_elemen_berkas` (
  `id` int(11) NOT NULL,
  `sub_elemen_id` int(11) NOT NULL,
  `jenis_berkas_id` int(11) NOT NULL,
  `nomor_urut` int(11) DEFAULT 1,
  `deadline_upload` date DEFAULT NULL,
  `catatan_khusus` text DEFAULT NULL,
  `label_requirement` varchar(100) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data untuk tabel `sub_elemen_berkas`
--

INSERT INTO `sub_elemen_berkas` (`id`, `sub_elemen_id`, `jenis_berkas_id`, `nomor_urut`, `deadline_upload`, `catatan_khusus`, `label_requirement`, `is_active`, `created_by`, `created_at`) VALUES
(19, 208, 5, 1, '2025-08-12', 'aa', '', 1, 2, '2025-08-12 02:45:39'),
(20, 208, 5, 2, '2025-08-12', 'xx', 'Versi 2', 1, 2, '2025-08-12 02:46:32'),
(21, 208, 5, 3, '2025-08-13', '', 'Versi 3', 1, 2, '2025-08-12 04:10:59'),
(22, 259, 5, 1, '2025-08-15', 'Berkas Kebijakan', '', 1, 2, '2025-08-15 12:35:49');

-- --------------------------------------------------------

--
-- Struktur dari tabel `sub_sub_elemen`
--

CREATE TABLE `sub_sub_elemen` (
  `id` int(11) NOT NULL,
  `sub_elemen_id` int(11) NOT NULL,
  `kode_sub_sub_elemen` varchar(20) NOT NULL,
  `nama_sub_sub_elemen` varchar(200) NOT NULL,
  `deskripsi` mediumtext DEFAULT NULL,
  `indikator_spesifik` mediumtext DEFAULT NULL,
  `format_dokumen_diterima` mediumtext DEFAULT NULL,
  `elemen_kelayakan` mediumtext DEFAULT NULL,
  `contoh_dokumen_valid` mediumtext DEFAULT NULL,
  `contoh_dokumen_tidak_valid` mediumtext DEFAULT NULL,
  `poin_maksimal` int(11) NOT NULL,
  `urutan_tampil` int(11) NOT NULL,
  `status` enum('aktif','nonaktif') DEFAULT 'aktif',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data untuk tabel `sub_sub_elemen`
--

INSERT INTO `sub_sub_elemen` (`id`, `sub_elemen_id`, `kode_sub_sub_elemen`, `nama_sub_sub_elemen`, `deskripsi`, `indikator_spesifik`, `format_dokumen_diterima`, `elemen_kelayakan`, `contoh_dokumen_valid`, `contoh_dokumen_tidak_valid`, `poin_maksimal`, `urutan_tampil`, `status`, `created_at`, `updated_at`) VALUES
(251, 214, 'II.2.1', 'Komunikasi dan konsultasi risiko', '', '', '', '', '', '', 4, 1, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(252, 214, 'II.2.2', 'Penetapan konteks risiko', '', '', '', '', '', '', 3, 2, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(253, 214, 'II.2.3', 'Identifikasi bahaya', '', '', '', '', '', '', 2, 3, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(254, 214, 'II.2.4', 'Penilaian dan pengendalian risiko		', '', '', '', '', '', '', 3, 4, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(255, 214, 'II.2.5', 'Pemantauan dan peninjauan', '', '', '', '', '', '', 3, 5, 'aktif', '2025-08-11 08:29:46', '2025-08-11 08:29:46'),
(256, 219, 'III.2.1', 'Penunjukan KTT', '', '', '', '', '', '', 1, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(257, 219, 'III.2.2', 'Penunjukan Kepala Tambang Bawah Tanah', '', '', '', '', '', '', 1, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(258, 219, 'III.2.3', 'Penunjukan Kepala Kapal Keruk', '', '', '', '', '', '', 1, 3, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(259, 227, 'III.10.1', 'III.10.1', 'Pendidikan dan pelatihan pekerja tambang', '', '', '', '', '', 4, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(260, 227, 'III.10.2', 'Kompetensi Kerja', '', '', '', '', '', '', 4, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(261, 229, 'III.12.1', 'Buku tambang', '', '', '', '', '', '', 1, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(262, 229, 'III.12.2', 'Buku daftar kecelakaan tambang', '', '', '', '', '', '', 1, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(263, 229, 'III.12.3', 'Pelaporan pengelolaan Keselamatan Pertambangan', '', '', '', '', '', '', 3, 3, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(264, 229, 'III.12.4', 'Dokumentasi Kejadian Berbahaya, kejadian akibat penyakit tenaga kerja dan penyakit akibat kerja', '', '', '', '', '', '', 3, 4, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(265, 229, 'III.12.5', 'Dokumen dan Laporan Pemenuhan Kompetensi dan Persyaratan Lainnya', '', '', '', '', '', '', 3, 5, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(266, 231, 'IV.1.1', 'Penyusunan, Penetapan, Penerapan, Pendokumentasian, dan Evaluasi Prosedur Operasi / Kerja', '', '', '', '', '', '', 4, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(267, 231, 'IV.1.2', 'Penyusunan, Penetapan, Penerapan, Pendokumentasian, dan Evaluasi Izin kerja khusus', '', '', '', '', '', '', 3, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(268, 231, 'IV.1.3', 'Penyusunan, Penetapan, Penerapan, Pendokumentasian, dan Evaluasi Prosedur Operasi / Kerja Alat pelindung diri dan alat keselamatan', '', '', '', '', '', '', 4, 3, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(269, 232, 'IV.2.1', 'Pelaksanaan pengelolaan Bahaya Debu', '', '', '', '', '', '', 4, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(270, 232, 'IV.2.2', 'Pelaksanaan pengelolaan Bahaya Kebisingan', '', '', '', '', '', '', 4, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(271, 232, 'IV.2.3', 'Pelaksanaan pengelolaan Bahaya Getaran', '', '', '', '', '', '', 4, 3, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(272, 232, 'IV.2.4', 'Pelaksanaan pengelolaan Bahaya Pencahayaan', '', '', '', '', '', '', 4, 4, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(273, 232, 'IV.2.5', 'Pelaksanaan pengelolaan Kuantitas dan Kualitas Udara Kerja', '', '', '', '', '', '', 4, 5, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(274, 232, 'IV.2.6', 'Pelaksanaan pengelolaan Iklim Kerja', '', '', '', '', '', '', 4, 6, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(275, 232, 'IV.2.7', 'Pelaksanaan pengelolaan Bahaya Radiasi', '', '', '', '', '', '', 4, 7, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(276, 232, 'IV.2.8', 'Pelaksanaan pengelolaan Faktor Kimia', '', '', '', '', '', '', 4, 8, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(277, 232, 'IV.2.9', 'Pelaksanaan pengelolaan Faktor Biologi', '', '', '', '', '', '', 4, 9, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(278, 232, 'IV.2.10', 'Pelaksanaan Kebersihan Lingkungan Kerja', '', '', '', '', '', '', 4, 10, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(279, 233, 'IV.3.1', 'Pemeriksaan Kesehatan', '', '', '', '', '', '', 4, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(280, 233, 'IV.3.2', 'Pelayanan Kesehatan Kerja', '', '', '', '', '', '', 2, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(281, 233, 'IV.3.3', 'Pertolongan Pertama pada Kecelakaan', '', '', '', '', '', '', 2, 3, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(282, 233, 'IV.3.4', 'Pengelolaan Kelelahan Kerja (Fatigue)', '', '', '', '', '', '', 3, 4, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(283, 233, 'IV.3.5', 'Pengelolaan Pekerja pada Tempat yang Memiliki Risiko Kesehatan Tinggi', '', '', '', '', '', '', 2, 5, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(284, 233, 'IV.3.6', 'Pengelolaan Rekaman Data Kesehatan Kerja', '', '', '', '', '', '', 4, 6, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(285, 233, 'IV.3.7', 'Pengelolaan Higiene dan Sanitasi', '', '', '', '', '', '', 2, 7, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(286, 233, 'IV.3.8', 'Pengelolaan Ergonomi', '', '', '', '', '', '', 3, 8, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(287, 233, 'IV.3.9', 'Pengelolaan Makanan, Minuman dan Gizi Pekerja', '', '', '', '', '', '', 2, 9, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(288, 233, 'IV.3.10', 'Diagnosis dan Pemeriksaan Penyakit Akibat Kerja', '', '', '', '', '', '', 4, 10, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(289, 234, 'IV.4.1', 'Sistem dan pelaksanaan pemeliharaan / perawatan sarana, prasarana, instalasi, dan peralatan pertambangan', '', '', '', '', '', '', 4, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(290, 234, 'IV.4.2', 'Pengamanan instalasi', '', '', '', '', '', '', 4, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(291, 234, 'IV.4.3', 'Kelayakan sarana, prasarana, instalasi, dan peralatan pertambangan', '', '', '', '', '', '', 4, 3, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(292, 234, 'IV.4.4', 'Kompetensi tenaga teknik', '', '', '', '', '', '', 4, 4, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(293, 234, 'IV.4.5', 'Evaluasi Laporan Hasil Kajian Teknis Pertambangan', '', '', '', '', '', '', 4, 5, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(294, 235, 'IV.5.1', 'Gudang bahan peledak', '', '', '', '', '', '', 1, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(295, 235, 'IV.5.2', 'Penyimpanan bahan peledak', '', '', '', '', '', '', 1, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(296, 235, 'IV.5.3', 'Pengangkutan bahan peledak', '', '', '', '', '', '', 4, 3, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(297, 235, 'IV.5.4', 'Pekerjaan peledakan', '', '', '', '', '', '', 4, 4, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(298, 236, 'IV.6.1', 'Perancangan dan rekayasa', '', '', '', '', '', '', 3, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(299, 236, 'IV.6.2', 'Perubahan', '', '', '', '', '', '', 3, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(300, 238, 'IV.8.1', 'Persyaratan, seleksi dan penetapan perusahaan jasa pertambangan', '', '', '', '', '', '', 2, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(301, 238, 'IV.8.2', 'Tanggung jawab, pemantauan dan pelaporan perusahaan jasa pertambangan', '', '', '', '', '', '', 2, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(302, 238, 'IV.8.3', 'Evaluasi perusahaan jasa pertambangan', '', '', '', '', '', '', 2, 3, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(303, 242, 'V.1.1', 'Pemantauan dan Pengukuran Pencapaian Tujuan, Sasaran, dan program Keselamatan Pertambangan', '', '', '', '', '', '', 4, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(304, 242, 'V.1.2', 'Pemantauan dan Pengukuran Kinerja Pengelolaan lingkungan kerja', '', '', '', '', '', '', 4, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(305, 242, 'V.1.3', 'Pemantauan dan Pengukuran Kinerja Pengelolaan kesehatan kerja', '', '', '', '', '', '', 4, 3, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(306, 242, 'V.1.4', 'Pemantauan dan Pengukuran Kinerja Pengelolaan Keselamatan Operasi pertambangan	', '', '', '', '', '', '', 4, 4, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(307, 242, 'V.1.5', 'Pemantauan dan Pengukuran Kinerja Pengelolaan Bahan Peledak dan Peledakan', '', '', '', '', '', '', 4, 5, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(308, 246, 'V.5.1', 'Buku tambang', '', '', '', '', '', '', 1, 1, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(309, 246, 'V.5.2', 'Buku daftar kecelakaan tambang', '', '', '', '', '', '', 1, 2, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(310, 246, 'V.5.3', 'Pelaporan pengelolaan keselamatan pertambangan', '', '', '', '', '', '', 4, 3, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(311, 246, 'V.5.4', 'Dokumentasi Kejadian Berbahaya, kejadian akibat penyakit tenaga kerja dan penyakit akibat kerja', '', '', '', '', '', '', 4, 4, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(312, 246, 'V.5.5', 'Dokumentasi dan Laporan pemenuhan Kompetensi serta Persyaratan Lainnya', '', '', '', '', '', '', 4, 5, 'aktif', '2025-08-11 08:29:47', '2025-08-11 08:29:47'),
(313, 265, 'II.2.1', 'Komunikasi dan konsultasi risiko', 'Komunikasi dan konsutasi merupakan proses yang terus menerus dan berulang untuk menyediakan, menyebarluaskan, atau mendapatkan informasi dan untuk terlibat dalam dialog dengan para pemangku kepentingan terkait dengan manjemen risiko.\r\n\r\nKomunikasi dan Konsultasi : Dilakukan Sebelum Dan Selama Proses Manajemen Risiko Dilaksanakan\r\n\r\nTata Cara :\r\n1. Pelaksanaan Rapat Dengan Para Pemangku Kepentingan\r\n2. Penyampaian Informasi Melalui Papan Pengumuman\r\n3. Email, Sosial Media, Aplikasi atau Sarana Komunikasi\r\n4. Menyediakan Kotak Saran\r\n5. Saluran Khusus Untu Menerima Masukkan Dari Semua\r\nPemangku Kepentingan', '0 : Tidak ada bukti melakukan komunikasi dan konsultasi risiko\r\n1 : Terdapat bukti telah melakukan komunikasi dan konsultasi risiko, namun baru dengan sebagian\r\npemangku kepentingan\r\n2 : Terdapat bukti telah melakukan komunikasi dan konsultasi risiko dengan seluruh pemangku kepentingan, namun hasil dari komunikasi dan konsultasi risiko tidak menjadi bahan pertimbangan dalam Manajemen Risiko\r\n3 : Terdapat bukti elah melakukan komunikasi dan konsultasi risiko dengan seluruh pemangku kepentingan, namun baru sebagian dari hasil dari komunikasi dan konsultasi risiko menjadi bahan pertimbangan dalam Manajemen Risiko\r\n4 : Terdapat bukti telah melakukan komunikasi dan konsultasi risiko dengan seluruh pemangku kepentingan, serta seluruh hasil dari komunikasi dan konsultasi risiko menjadi bahan pertimbangan dalam Manajemen Risiko', '', '', '', '', 4, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-20 03:42:38'),
(314, 265, 'II.2.2', 'Penetapan konteks risiko', 'Penetapan konteks risiko terkait dengan pemantauan batasan- batasan risiko yang akan dikelola dan menentukan lingkup proses manajemen risiko selanjutnya, berupa faktor internal dan faktor eksternal.\r\n\r\nA. Faktor internal, paling sedikit terdiri atas:\r\n• kegiatan dan proses rutin dan tidak rutin:\r\n• perubahan-perubahan pada organisasi, lingkungan kerja, kegiatan, atau bahan/material;\r\n• modifikasi pada sistem manajemen Keselamatan Pertambangan, termasuk perubahan-perubahan sementara, serta dampak pada operasi, proses, dan kegiatan;\r\n• fasilitas yang baru dibangun, peralatan atau proses yang baru diperkenalkan, serta kegiatan dan instalasi di dalam lokasi kerja;\r\n• kondisi normal dan abnormal dan/atau kondisi proses serta potensi insiden dan keadaan darurat selama siklus pemakaian produk dan/atau siklus lamanya proses;\r\n• ketidakpatuhan terhadap rekomendasi sebelumnya, standar dan/atau prosedur Keselamatan Pertambangan yang ada, atau ketidakpatuhan terhadap tindak lanjut rekomendasi insiden;\r\n• faktor personal Pekerja;\r\n• desain area kerja, proses, instalasi, peralatan, prosedur operasi dan organisasi kerja, termasuk kemampuan adaptasi manusia;\r\n• sistem dan pelaksanaan pemeliharaan/perawatan sarana, prasarana, instalasi, dan peralatan Pertambangan;\r\n• pengamanan instalasi;\r\n• kelayakan sarana, prasarana, instalasi, serta peralatan Pertambangan;\r\n• kompetensi tenaga teknik; dan\r\n• evaluasi laporan hasil kajian teknis Pertambangan\r\n\r\nB. Faktor eksternal, paling sedikit terdiri atas:\r\n• budaya, politik, hukum, keuangan, teknologi, ekonomi, alam, dan lingkungan yang kompetitif secara lokal, nasional, regional, dan\r\ninternasional;\r\n• pendorong utama dan perkembangan isu yang berdampak signifikan terhadap tujuan organisasi;\r\n• persepsi dan nilai-nilai dari para pemangku kepentingan eksternal;\r\n• kegiatan semua orang yang memiliki akses ke tempat kerja, termasuk yang dilakukan oleh pemegang IUP, IUPK, IUP Operasi Produksi khusus untuk Pengolahan dan/atau Pemurnian, IPR, IUJP dan para tamu;\r\n• fasilitas yang baru dibangun, peralatan atau proses yang baru diperkenalkan, serta kegiatan dan instalasi pemegang IUP, IUPK, IUP Operasi Produksi khusus untuk Pengolahan dan/atau Pemurnian, IPR, dan IUJP di luar lokasi kerja;\r\n• bahaya-bahaya teridentifikasi yang berasal dari luar lokasi kerja yang dapat membahayakan keselamatan dan kesehatan orang di tempat kerja yang berada dalam kendali pemegang IUP, IUPK, dan IUP Operasi Produksi\r\nkhusus;\r\n• infrastruktur, peralatan, dan bahan-bahan di tempat kerja yang disediakan oleh pihak lain; dan\r\n• kewajiban hukum yang berkaitan dengan identifikasi bahaya dan penilaian risiko serta pengendalian yang diperlukan', '0 : Tidak ada bukti telah melakukan penetapan konteks risiko\r\n1 : Terdapat bukti telah melakukan penetapan konteks risiko, namun baru mencakup faktor internal atau faktor eksternal\r\n2 : Terdapat bukti telah melakukan penetapan konteks risiko yang telah mencakup sebagian faktor internal dan sebagian faktor eksternal (belum seluruhnya)\r\n3 : Terdapat bukti telah melakukan penetapan konteks risiko yang telah mencakup seluruh faktor internal dan faktor eksternal', '', '', '', '', 3, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-20 05:33:49'),
(315, 265, 'II.2.3', 'Identifikasi bahaya', 'Pemegang IUP, IUPK, IUP Operasi Produksi khusus untuk Pengolahan dan/atau Pemurnian, atau IPR mengidentifikasi sumber-sumber bahaya, area yang terpapar oleh bahaya, dan konsekuensi yang potensial Proses yang dilakukan disini harus mampu mengidentifikasi semua sumber, tindakan dan kondisi yang ada dalam semua proses perusahaan yang dapat menimbulkan bahaya terhadap kecelakaan maupun penyakit akibat kerja.\r\n\r\nProses identifikasi bahaya juga mempertimbangkan aktivitas perusahaan yang bersifat rutin dan non rutin (contoh kegiatan periodik, tertentu dan emergency), serta mempertimbangkan, manusia, metode, material, mesin, dan lingkungan kerja.', '0 : Tidak ada bukti telah melakukan identifikasi bahaya\r\n1 : Terdapat bukti telah melakukan identifikasi bahaya, namun belum seluruh bahaya diidentifikasi\r\n2 : Terdapat bukti telah melakukan identifikasi bahaya, dan telah seluruh bahaya diidentifikasi', '', '', '', '', 2, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-20 05:56:20'),
(316, 265, 'II.2.4', 'Penilaian dan pengendalian risiko		', 'Penilaian Risiko Dilakukan Melalui Proses Evaluasi Risiko Untuk Menentukan Risiko Dapat Diterima Atau Tidak Dengan Metodologi:\r\na)Memperhatikan Ruang Lingkup, Sifat Dan Waktu Untuk Memastikan Metode Yang Digunakan Bersifat Proaktif; Dan\r\nb)Menyediakan Cara Untuk Melakukan Identifikasi Bahaya, Penentuan Nilai Risiko, Penentuan Kriteria, Dan Prioritas Risiko, Penentuan Pengendalian Yang Sesuai, Dan Pendokumentasiannya\r\n\r\nPengendalian Risiko dilakukan dengan cara Menetapkan, Menerapkan, Dan Mendokumentasikan Langkah-langkah Pengendalian Terhadap Risiko Tersebut Dengan Mengikuti Hierarki Pengendalian Risiko, yaitu :\r\n1. Rekayasa : Eliminasi, Subtitusi dan Isolasi\r\n2. Administrasi : Rambu Peringatan, Pemilihan Pekerja, rotasi kerja, pembatasan jam kerja, serta pemilihan perusahaan jasa pertambangan.\r\n3. Praktik Kerja, Seperti Prosedur Kerja Baku (Standard Operating Procedure), Instruksi Kerja (Work Instruction), Dan Pelatihan (Training); Dan\r\n4. Alat Pelindung Diri (APD)', '0 : Tidak ada bukti telah melakukan penilaian dan pengendalian risiko\r\n1 : Terdapat bukti telah melakukan penilaian risiko atau pengendalian risiko, namun belum seluruh bahaya yang teridentifikasi telah dinilai atau belum dikendalikan sesuai dengan hirarki pengendalian\r\n2 : Terdapat bukti telah melakukan penilaian dan pengendalian risiko yang sesuai dengan hirarki pengendalian, namun implementasi pengendaliannya belum memadai\r\n3 : Terdapat bukti  telah melakukan pengendalian risiko yang sesuai dengan hirarki pengendalian, dan implementasi pengendaliannya telah memadai', '', '', '', '', 3, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-20 06:04:21'),
(317, 265, 'II.2.5', 'Pemantauan dan peninjauan', 'Pemegang IUP, IUPK, IUP Operasi Produksi Khusus Untuk Pengolahan Dan/Atau Pemurnian, Atau IPR:\r\n• Menetapkan Cara Untuk Melakukan Pemantauan Dan Peninjauan Terhadap Setiap Proses Manajemen Risiko;\r\n• Mengkomunikasikan Setiap Hasil Dari Pemantauan Dan Peninjauan Terhadap Proses Manajemen Risiko Kepada\r\nSeluruh Pihak Yang Terkait;\r\n• Memastikan Pengendalian Risiko Yang Dilakukan Telah Memadai; Dan\r\n• Melaksanakan Pemantauan Dan Peninjauan Secara Berkala Atau Apabila:\r\n1. Terjadi Kecelakaan\r\n2. Kejadian Berbahaya;\r\n3. Terjadi Kejadian Akibat Penyakit Tenaga Kerja\r\n4. Terjadi Penyakit Akibat Kerja\r\n5. Terjadi Perubahan Peralatan, Instalasi, Dan/Atau Proses Serta Kegiatan Pemegang Izin; Dan/Atau\r\n6. Ada Proses Serta Kegiatan Baru.', '0 : Tidak ada bukti telah melakukan pemantauan dan peninjauan risiko\r\n1 : Terdapat bukti  telah melakukan pemantauan dan peninjauan risiko secara periodik atau apabila terjadi kecelakaan atau kejadian berbahaya, Penyakit Akibat Kerja, perubahan dalam peralatan, instalasi dan terdapat proses kegiatan baru namun belum dilakukan pemantauan dan peninjauan\r\n2 : Terdapat bukti  telah melakukan pemantauan dan peninjauan risiko secara periodik atau apabila terjadi kecelakaan atau kejadian berbahaya, Penyakit Akibat Kerja, perubahan dalam peralatan, instalasi dan terdapat proses kegiatan baru serta sudah dilakukan pemantauan dan peninjauan, namun hasilnya belum memadai\r\n3 : Terdapat bukti  telah melakukan pemantauan dan peninjauan risiko secara periodik atau apabila terjadi kecelakaan atau kejadian berbahaya, Penyakit Akibat Kerja, perubahan dalam peralatan, instalasi dan terdapat proses kegiatan baru serta sudah dilakukan pemantauan dan peninjauan, namun hasilnya telah memadai', '', '', '', '', 3, 5, 'aktif', '2025-08-14 04:24:16', '2025-08-20 06:44:34'),
(321, 278, 'III.10.1', 'Pendidikan dan Pelatihan Pekerja Tambang', 'Dalam menyusun program pendidikan dan pelatihan keselamatan kerja Pertambangan, pemegang IUP,\r\nIUPK, IUP Operasi Produksi khusus untuk Pengolahan dan/atau Pemurnian, IPR, dan IUJP\r\nmelaksanakan hal-hal sebagai berikut:\r\n• pengumpulan data dan informasi (identifikasi pekerjaan dan identifikasi pekerja)\r\n• penyusunan analisis kebutuhan pendidikan dan pelatihan (training need analysis)\r\n• pelaksanaan pendidikan dan pelatihan (on the job & off the job)\r\n• monitoring dan evaluasi program pendidikan dan pelatihan (Reaction, Learning, Behaviour, Result)', '', '', '', '', '', 4, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-31 09:32:51'),
(322, 278, 'III.10.2', 'Kompetensi Kerja', '', '', '', '', '', '', 4, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(325, 280, 'III.12.3', 'Pelaporan pengelolaan Keselamatan Pertambangan', '', '', '', '', '', '', 3, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(326, 280, 'III.12.4', 'Dokumentasi Kejadian Berbahaya, kejadian akibat penyakit tenaga kerja dan penyakit akibat kerja', '', '', '', '', '', '', 3, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(327, 280, 'III.12.5', 'Dokumen dan Laporan Pemenuhan Kompetensi dan Persyaratan Lainnya', '', '', '', '', '', '', 3, 5, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(328, 282, 'IV.1.1', 'Penyusunan, Penetapan, Penerapan, Pendokumentasian, dan Evaluasi Prosedur Operasi / Kerja', 'IUJP menyusun, menetapkan, mensosialisasikan, menerapkan, mendokumentasikan, dan mengevaluasi prosedur operasi/kerja. Prosedur operasi/kerja tidak terbatas pada standard operating procedure, analisis\r\nkeselamatan pekerjaan (job safety analysis), instruksi kerja, dan buku manual dengan mempertimbangkan hasil pemetaan behavior based safety;\r\n- LEVEL 1 : MANUAL, PROSEDUR & DOKUMEN PENDUKUNG\r\n- LEVEL 2 : INSTRUKSI KERJA, DOKUMEN TEKNIS, STANDAR, GAMBAR DLL\r\n- LEVEL 3 & 4 : FORM, CHECKLIST', '', '', '', '', '', 4, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-31 10:37:36'),
(329, 282, 'IV.1.2', 'Penyusunan, Penetapan, Penerapan, Pendokumentasian, dan Evaluasi Izin kerja khusus', 'IUJP menyusun, menetapkan, mensosialisasikan, menerapkan, mendokumentasikan, dan mengevaluasi izin kerja khusus dengan mempertimbangkan hasil pemetaan behavior based safety;', '', '', '', '', '', 3, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-31 10:38:34'),
(330, 282, 'IV.1.3', 'Penyusunan, Penetapan, Penerapan, Pendokumentasian, dan Evaluasi Prosedur Operasi / Kerja Alat pelindung diri dan alat keselamatan', 'IUJP menyusun, menetapkan, mensosialisasikan, menerapkan, mendokumentasikan, memelihara, dan mengevaluasi prosedur untuk pengelolaan alat pelindung diri/ alat keselamatan, yang mencakup:\r\n• penilaian kebutuhan alat pelindung diri dan alat keselamatan yang sesuai dengan jenis pekerjaan dan bahaya yang timbul,\r\n• penentuan dan penyediaan alat pelindung diri dan alat keselamatan dengan jumlah yang memadai secara cuma-cuma,\r\n• pembuatan matriks alat pelindung diri untuk setiap pekerjaan dan area khusus,\r\n• evaluasi kepatuhan terhadap penggunaan dan perawatan alat pelindung diri dan alat keselamatan,\r\n• pelaksanaan pelatihan untuk Pekerja yang terkait dengan fungsi, manfaat, penggunaan, dan perawatan alat pelindung diri dan alat keselamatan.', '', '', '', '', '', 4, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-31 10:40:21'),
(331, 283, 'IV.2.1', 'Pelaksanaan pengelolaan Bahaya Debu', '', '', '', '', '', '', 4, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(332, 283, 'IV.2.2', 'Pelaksanaan pengelolaan Bahaya Kebisingan', '', '', '', '', '', '', 4, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(333, 283, 'IV.2.3', 'Pelaksanaan pengelolaan Bahaya Getaran', '', '', '', '', '', '', 4, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(334, 283, 'IV.2.4', 'Pelaksanaan pengelolaan Bahaya Pencahayaan', '', '', '', '', '', '', 4, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(335, 283, 'IV.2.5', 'Pelaksanaan pengelolaan Kuantitas dan Kualitas Udara Kerja', '', '', '', '', '', '', 4, 5, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(336, 283, 'IV.2.6', 'Pelaksanaan pengelolaan Iklim Kerja', '', '', '', '', '', '', 4, 6, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(337, 283, 'IV.2.7', 'Pelaksanaan pengelolaan Bahaya Radiasi', '', '', '', '', '', '', 4, 7, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(338, 283, 'IV.2.8', 'Pelaksanaan pengelolaan Faktor Kimia', '', '', '', '', '', '', 4, 8, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(339, 283, 'IV.2.9', 'Pelaksanaan pengelolaan Faktor Biologi', '', '', '', '', '', '', 4, 9, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(340, 283, 'IV.2.10', 'Pelaksanaan Kebersihan Lingkungan Kerja', '', '', '', '', '', '', 4, 10, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(341, 284, 'IV.3.1', 'Pemeriksaan Kesehatan', 'IUJP melaksanakan pemeriksaan kesehatan kerja Pertambangan dengan ketentuan:\r\n1. Dilaksanakan sesuai dengan pedoman pemeriksaan dan penilaian kelayakan kesehatan kerja yang disusun oleh dokter perusahaan\r\n2. Dilakukan meliputi pemeriksaan kesehatan awal, pemeriksaan kesehatan berkala, pemeriksaan kesehatan khusus, dan pemeriksaan kesehatan akhir\r\n3. ⁠Ditindaklanjuti dengan menginformasikan kepada Pekerja terkait kondisi Pekerja yang bersangkutan, melakukan pemantauan, pengobatan, atau rehabilitasi terhadap Pekerja yang bersangkutan sesuai dengan hasil pemeriksaan kesehatan, mengevaluasi penempatan Pekerja apabila diperlukan disesuaikan dengan kondisi Pekerja yang bersangkutan, dan melakukan upaya promotif dan preventif terhadap Pekerja lain yang terkait termasuk perbaikan kondisi lingkungan kerja\r\n4. ⁠Data hasil pemeriksaan kesehatan Pekerja dibuat, didokumentasikan, dan dievaluasi sesuai dengan ketentuan peraturan perundang-undangan\r\n\r\nProgram kesehatan kerja terdiri dari:\r\n1. Pemeriksaan Kesehatan Awal, dilakukan sebelum pekerja diterima untuk melakukan pekerjaab atau dipindahkan ke pekerjaan baru\r\n2. Pemeriksaan Kesehatan Berkala, dilakukan untuk mengetahui kondisi pekerja sesudah berada dalam pekerjaannya\r\n3. Pemeriksaan Kesehatan Khusus, dilakukan untuk mengetahui adanya pengaruh-pengaruh dari pekerjaan tertentu terhadap pekerja atau golongan pekerja tertentu,disesuaikan dengan pajanan risiko pekerjaannya\r\n4. Pemeriksaan Kesehatan Akhir, dilakukan kepada pekerja yang sisa masa kerjanya 1 (satu) tahun menjelang pensiun\r\n', '', '', '', '', '', 4, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:06:08'),
(342, 284, 'IV.3.2', 'Pelayanan Kesehatan Kerja', 'IUJP menyelenggarakan pelayanan kesehatan kerja Pertambangan dengan ketentuan:\r\n1. Menyediakan tenaga kesehatan kerja, yang meliputi dokter perusahaan, dokter pemeriksa kesehatan\r\ntenaga kerja, perawat; dan/atau tenaga kesehatan lainnya yang kompeten\r\n2. Menyediakan sarana dan prasarana pelayanan yang mencakup sarana dasar (perlengkapan umum, ruangan, dan peralatan medis) dan sarana penunjang (alat pelindung diri, alat evakuasi, peralatan penunjang diagnosa, peralatan pemantau atau pengukuran lingkungan kerja), sesuai dengan ketentuan peraturan perundang-undangan\r\n3. ⁠kualifikasi Pelayanan Kesehatan Kerja (Pelayanan Kegawatdaruratan, Pelayanan Pratama, Pelayanan Utama) ditetapkan berdasarkan tingkat keterisoliran lokasi tambang dan ketentuan peraturan perundang-undangan.\r\nTingkat Keterisoliran Rendah\r\n• Pelayanan kegawatdaruratan\r\n• Jarak tempuh <60 menit\r\nTingkat Keterisoliran Menengah\r\n• Pelayanan pratama\r\n• Jarak tempuh 60-120 menit\r\nTingkat Keterisoliran Tinggi\r\n• Pelayanan utama\r\n• >120 menit\r\n', '', '', '', '', '', 2, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:06:40'),
(343, 284, 'IV.3.3', 'Pertolongan Pertama pada Kecelakaan', 'IUJP melaksanakan pertolongan pertama pada kecelakaan dengan ketentuan:\r\n• KTT atau PTL menyediakan petugas yang memiliki kompetensi, fasilitas dan peralatan untuk melakukan pertolongan pertama pada kecelakaan, pada setiap kelompok kerja;\r\n• KTT atau PTL membuat program pendidikan dan pelatihan P3K secara berkala; dan\r\n• kotak P3K ditempatkan pada lokasi yang mudah dicapai, terlindungi, dan diberi tanda, dan isinya disesuaikan dengan risiko yang ada, serta diperiksa secara berkala paling sedikit setiap bulan oleh penanggung jawab kotak P3K yang namanya tertera pada kotak P3K;', '', '', '', '', '', 2, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:10:25'),
(344, 284, 'IV.3.4', 'Pengelolaan Kelelahan Kerja (Fatigue)', 'IUJP melakukan pengelolaan pencegahan kelelahan kerja (fatigue) dengan ketentuan:\r\na. melakukan identifikasi, evaluasi, dan pengendalian faktor yang dapat menimbulkan kelelahan pekerja tambang;\r\nb. memberikan pelatihan dan sosialisasi kepada semua pekerja tambang tentang pengetahuan pengelolaan dan pencegahan kelelahan khususnya bagi pekerja dengan waktu kerja bergilir (shift);\r\nc. mengatur pola gilir kerja (shift) pekerja tambang; dan\r\nd. melakukan penilaian dan pengelolaan tingkat kelelahan pada pekerja tambang sebelum awal gilir kerja (shift) dan saat pekerjaan berlangsung.', '', '', '', '', '', 3, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:11:56'),
(345, 284, 'IV.3.5', 'Pengelolaan Pekerja pada Tempat yang Memiliki Risiko Kesehatan Tinggi', 'IUJP melakukan pengelolaan Pekerja yang bekerja pada tempat yang memiliki risiko kesehatan tinggi, dengan ketentuan:\r\n• memastikan risiko yang ada telah dikendalikan secara memadai;\r\n• memberikan pemahaman cara kerja aman, konsekuensi, dan pemantauan pekerjaan di area tersebut; dan\r\n• bertanggung jawab terhadap efek yang ditimbulkan akibat pekerjaan tersebut;', '', '', '', '', '', 2, 5, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:12:54'),
(346, 284, 'IV.3.6', 'Pengelolaan Rekaman Data Kesehatan Kerja', 'IUJP mengelola rekaman data kesehatan kerja Pertambangan dengan ketentuan:\r\n• menjaga dan memelihara rekaman data kesehatan kerja Pertambangan paling sedikit meliputi data hasil pemeriksaan kesehatan awal, data hasil pemeriksaan kesehatan berkala, data hasil pemeriksaan khusus, dan data hasil pemeriksaan akhir, riwayat pekerjaan pekerja, data medis/rekam medis Pekerja, data indikator kinerja kesehatan kerja, data hasil pemeriksaan lingkungan kerja dalam rangka pengelolaan kesehatan kerja;\r\n• menganalisis dan mengevaluasi rekaman data kesehatan kerja Pertambangan sebagai bahan untuk perbaikan kinerja kesehatan kerja; dan\r\n• melakukan pengukuran kinerja kesehatan kerja dengan menggunakan 2 (dua) indikator yaitu\r\n1. indikator proses (leading indicator)\r\n2. indikator hasil akhir (lagging indicator) yang\r\nmeliputi:\r\n- Rasio Kelaikan Kerja,\r\n- Crude Morbidity Rate (CMR)\r\n- Morbidity Frequency Rate\r\n- Spell Severity Rate\r\n- Absence Severity Rate\r\n- Penyakit Akibat Kerja\r\nuntuk dilaporkan oleh KTT atau PTL kepada KaIT/Kepala Dinas atas nama KaIT sesuai dengan formulir yang ditentukan.', '', '', '', '', '', 4, 6, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:15:38'),
(347, 284, 'IV.3.7', 'Pengelolaan Higiene dan Sanitasi', 'IUJP menyediakan fasilitas untuk menunjang tercapainya higienitas, serta melakukan pengelolaan sanitasi di area kerja, paling sedikit meliputi pengelolaan tempat sampah, toilet dan wastafel, kebersihan lantai dan bangunan, dan ruang ganti pakaian dan kamar mandi sesuai dengan ketentuan peraturan perundang-undangan', '', '', '', '', '', 2, 7, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:21:50'),
(348, 284, 'IV.3.8', 'Pengelolaan Ergonomi', 'IUJP melakukan pengelolaan ergonomi dengan mengelola kesesuaian antara pekerjaan, lingkungan kerja, peralatan, dan Pekerja, antara lain meliputi\r\n• Melakukan identifikasi dan penilaian risiko ergonomi, serta pengendalian berdasarkan hasil ergonomic risk assessment;\r\n• Menyediakan sarana, prasarana, instalasi, dan peralatan yang sesuai dengan kemampuan, kondisi, dan postur pekerja;\r\n• Menyediakan prosedur kerja sesuai dengan kapasitas pekerja; dan\r\n• Menyediakan perlengkapan penunjang untuk mendukung pekerjaan.', '', '', '', '', '', 3, 8, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:22:40'),
(349, 284, 'IV.3.9', 'Pengelolaan Makanan, Minuman dan Gizi Pekerja', 'IUJP melakukan pengelolaan makanan, minuman, dan gizi Pekerja dengan melaksanakan analisis bahaya dan pengendalian titik kritis (hazard analysis and critical control points) untuk memastikan bahwa penyediaan makanan dan minuman telah memenuhi syarat keamanan, kecukupan, dan higienitas sesuai dengan ketentuan yang berlaku serta mempertimbangkan aspek keseimbangan gizi Pekerja;', '', '', '', '', '', 2, 9, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:24:19'),
(350, 284, 'IV.3.10', 'Diagnosis dan Pemeriksaan Penyakit Akibat Kerja', 'Dalam PAK, IUJP melakukan hal-hal sebagai berikut:\r\n• diagnosis Penyakit Akibat Kerja ditegakkan melalui serangkaian tahapan pemeriksaan klinis, kondisi Pekerja, lingkungan kerjanya, dan data medis/rekam medis Pekerja;\r\n• dokter perusahaan menetapkan status Penyakit Akibat Kerja berdasarkan hasil pemeriksaan sebagaimana disebutkan setelah membuktikan hubungan sebab akibat antara penyakit dengan pekerjaan dan atau lingkungan kerjanya;\r\n• dokter perusahaan membuat laporan medik dan dalam 1 × 24 jam disampaikan ke KTT atau PTL, serta kemudian KTT atau PTL segera melaporkan Penyakit Akibat Kerja yang telah ditegakkan oleh dokter perusahaan kepada KaIT atau Kepala Dinas atas nama KaIT sesuai dengan kewenangannya dengan menggunakan formulir yang ditentukan;\r\n• pemegang IUP, IUPK, IUP Operasi Produksi khusus untuk Pengolahan dan/atau Pemurnian, IPR, dan IUJP melakukan upaya kuratif dan rehabilitasi terhadap Pekerja yang didiagnosis menderita Penyakit Akibat Kerja, dan apabila setelah pengobatan penyakit akibat kerja telah dinyatakan selesai dan dijumpai adanya suatu kecacatan, maka dokter perusahaan dapat menetapkan persentase kecacatan sesuai dengan ketentuan yang berlaku; dan\r\n• setiap Penyakit Akibat Kerja yang telah ditegakkan oleh dokter perusahaan dilakukan proses penyelidikan oleh tim yang paling sedikit melibatkan dokter perusahaan dan petugas kesehatan kerja atau higiene industri, untuk menemukan faktor-faktor bahaya kesehatan di lokasi Pekerja yang terkena Penyakit Akibat Kerja yang menyebabkan timbulnya Penyakit Akibat Kerja;', '', '', '', '', '', 4, 10, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:27:28'),
(351, 285, 'IV.4.1', 'Sistem dan pelaksanaan pemeliharaan / perawatan sarana, prasarana, instalasi, dan peralatan pertambangan', 'IUJP membuat sistem dan melaksanakan pemeliharaan/perawatan sarana, prasarana, istalasi, dan peralatan\r\nPertambangan dengan paling sedikit melakukan hal-hal sebagai berikut :\r\n• membuat daftar sarana, prasarana, instalasi, dan peralatan Pertambangan;\r\n• mengidentifikasi jenis dan karakteristik atas pemeliharaan atau perawatan sarana, prasarana, instalasi, dan\r\nperalatan Pertambangan;\r\n• menyusun dan menetapkan prosedur pemeliharaan atau perawatan berdasarkan hasil identifikasi jenis dan karakteristik sarana, prasarana, instalasi, dan peralatan Pertambangan;\r\n• merencanakan program dan jadwal pemeliharaan atau perawatan sarana, prasarana, instalasi, dan peralatan Pertambangan; dan\r\n• melaksanakan pemeliharaan/perawatan sarana, prasarana, instalasi, dan peralatan Pertambangan oleh Tenaga Teknis Pertambangan yang Berkompeten di bidang Keselamatan Operasi.', '', '', '', '', '', 4, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:31:49'),
(352, 285, 'IV.4.2', 'Pengamanan instalasi', 'IUJP melakukan pengamanan instalasi dengan paling sedikit melakukan hal-hal sebagai berikut.\r\n• membuat daftar instalasi;\r\n• mengidentifikasi kebutuhan pengaman atas instalasi;\r\n• menyusun dan menetapkan prosedur pengamanan instalasi;\r\n• menyusun dan menetapkan desain pengamanan instalasi;\r\n• menyusun dan menetapkan prosedur proses pemasangan instalasi;\r\n• menyusun dan menetapkan prosedur pemeliharaan pengamanan instalasi;\r\n• menetapkan program dan jadwal pemeriksaan pengamanan instalasi; dan\r\n• menerapkan, melaksanakan pemeriksaan berkala, memantau dan mengevaluasi sistem pengamanan instalasi oleh Tenaga Teknis Pertambangan yang Berkompeten di bidang Keselamatan Operasi.', '', '', '', '', '', 4, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:32:41'),
(353, 285, 'IV.4.3', 'Kelayakan sarana, prasarana, instalasi, dan peralatan pertambangan', 'IUJP memastikan kelayakan sarana, prasarana, instalasi, dan peralatan Pertambangan dengan paling sedikit melakukan hal-hal sebagai berikut.\r\n• membuat daftar sarana, prasarana, instalasi, dan peralatan Pertambangan;\r\n• menyusun dan menetapkan prosedur pengujian kelayakan sarana, prasarana, instalasi, dan peralatan Pertambangan;\r\n• menetapkan program dan jadwal sarana, prasarana, instalasi, dan peralatan Pertambangan; dan\r\n• melaksanakan pengujian kelayakan, pengamanan dan pemeliharaan terhadap sarana, prasarana, instalasi dan peralatan Pertambangan dilakukan oleh Tenaga Teknis Pertambangan yang Berkompeten di bidang Keselamatan Operasi sesuai dengan ketentuan peraturan perundang-undangan.', '', '', '', '', '', 4, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:34:00'),
(354, 285, 'IV.4.4', 'Kompetensi tenaga teknik', 'IUJP menunjuk Tenaga Teknis Pertambangan yang Berkompeten di bidang Keselamatan Operasi yang memiliki kompetensi untuk\r\n• menyusun dan menetapkan prosedur, membuat program dan jadwal, melaksanakan pemeliharaan/perawatan sarana, prasarana, instalasi, dan peralatan Pertambangan, serta mengevaluasi dan mendokumentasikan hasilnya;\r\n• menyusun dan menetapkan prosedur, membuat program dan jadwal, melaksanakan pemeriksaan pengamanan instalasi, serta mengevaluasi dan mendokumentasikan hasilnya;\r\n• menyusun dan menetapkan prosedur, membuat program dan jadwal, melaksanakan pengujian kelayakan sarana, prasarana, instalasi, dan peralatan Pertambangan, serta mengevaluasi dan mendokumentasikan hasilnya; dan\r\n• menyusun dan menetapkan prosedur, membuat program dan jadwal, melaksanakan evaluasi laporan hasil kajian teknis Pertambangan, serta mengevaluasi dan mendokumentasikan hasilnya.', '', '', '', '', '', 4, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:37:56'),
(355, 285, 'IV.4.5', 'Evaluasi Laporan Hasil Kajian Teknis Pertambangan', 'Kajian teknis dilakukan pada saat awal kegiatan atau sebelum dimulainya kegiatan Pertambangan.\r\nApabila terjadi perubahan atau modifikasi terhadap proses, sarana, prasarana, instalasi, dan peralatan Pertambangan maka hasil evaluasinya disampaikan kepada KaIT atau Kepala Dinas atas nama KaIT.', '', '', '', '', '', 4, 5, 'aktif', '2025-08-14 04:24:16', '2025-08-31 11:39:09'),
(356, 286, 'IV.5.1', 'Gudang bahan peledak', '', '', '', '', '', '', 0, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-31 08:35:05'),
(357, 286, 'IV.5.2', 'Penyimpanan bahan peledak', '', '', '', '', '', '', 0, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-31 08:34:50'),
(358, 286, 'IV.5.3', 'Pengangkutan bahan peledak', '', '', '', '', '', '', 4, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(359, 286, 'IV.5.4', 'Pekerjaan peledakan', '', '', '', '', '', '', 4, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(360, 287, 'IV.6.1', 'Perancangan dan rekayasa', '', '', '', '', '', '', 3, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(361, 287, 'IV.6.2', 'Perubahan', '', '', '', '', '', '', 3, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(362, 289, 'IV.8.1', 'Persyaratan, seleksi dan penetapan perusahaan jasa pertambangan', '', '', '', '', '', '', 2, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(363, 289, 'IV.8.2', 'Tanggung jawab, pemantauan dan pelaporan perusahaan jasa pertambangan', '', '', '', '', '', '', 2, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(364, 289, 'IV.8.3', 'Evaluasi perusahaan jasa pertambangan', '', '', '', '', '', '', 2, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(365, 293, 'V.1.1', 'Pemantauan dan Pengukuran Pencapaian Tujuan, Sasaran, dan program Keselamatan Pertambangan', '', '', '', '', '', '', 4, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(366, 293, 'V.1.2', 'Pemantauan dan Pengukuran Kinerja Pengelolaan lingkungan kerja', '', '', '', '', '', '', 4, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(367, 293, 'V.1.3', 'Pemantauan dan Pengukuran Kinerja Pengelolaan kesehatan kerja', '', '', '', '', '', '', 4, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(368, 293, 'V.1.4', 'Pemantauan dan Pengukuran Kinerja Pengelolaan Keselamatan Operasi pertambangan	', '', '', '', '', '', '', 4, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(369, 293, 'V.1.5', 'Pemantauan dan Pengukuran Kinerja Pengelolaan Bahan Peledak dan Peledakan', '', '', '', '', '', '', 4, 5, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(370, 297, 'V.5.1', 'Buku tambang', '', '', '', '', '', '', 1, 1, 'aktif', '2025-08-14 04:24:16', '2025-08-20 08:36:23'),
(371, 297, 'V.5.2', 'Buku daftar kecelakaan tambang', '', '', '', '', '', '', 1, 2, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(372, 297, 'V.5.3', 'Pelaporan pengelolaan keselamatan pertambangan', '', '', '', '', '', '', 4, 3, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(373, 297, 'V.5.4', 'Dokumentasi Kejadian Berbahaya, kejadian akibat penyakit tenaga kerja dan penyakit akibat kerja', '', '', '', '', '', '', 4, 4, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16'),
(374, 297, 'V.5.5', 'Dokumentasi dan Laporan pemenuhan Kompetensi serta Persyaratan Lainnya', '', '', '', '', '', '', 4, 5, 'aktif', '2025-08-14 04:24:16', '2025-08-14 04:24:16');

-- --------------------------------------------------------

--
-- Struktur dari tabel `sub_sub_elemen_berkas`
--

CREATE TABLE `sub_sub_elemen_berkas` (
  `id` int(11) NOT NULL,
  `sub_sub_elemen_id` int(11) NOT NULL,
  `jenis_berkas_id` int(11) NOT NULL,
  `nomor_urut` int(11) DEFAULT 1,
  `deadline_upload` date DEFAULT NULL,
  `catatan_khusus` text DEFAULT NULL,
  `label_requirement` varchar(100) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `upload_sub_elemen`
--

CREATE TABLE `upload_sub_elemen` (
  `id` int(11) NOT NULL,
  `sub_elemen_berkas_id` int(11) NOT NULL,
  `uploaded_by` int(11) NOT NULL,
  `nama_file_asli` varchar(255) NOT NULL,
  `nama_file_sistem` varchar(255) NOT NULL,
  `ukuran_file` int(11) NOT NULL,
  `mime_type` varchar(100) DEFAULT NULL,
  `path_file` varchar(500) NOT NULL,
  `deskripsi_berkas` mediumtext DEFAULT NULL,
  `metadata` longtext DEFAULT NULL CHECK (json_valid(`metadata`)),
  `status_verifikasi_dept` enum('pending','approved','rejected','actived') DEFAULT 'pending',
  `verified_by_dept` int(11) DEFAULT NULL,
  `catatan_dept` mediumtext DEFAULT NULL,
  `verified_at_dept` timestamp NULL DEFAULT NULL,
  `status_verifikasi_kantor` enum('pending','approved','rejected','actived') DEFAULT 'pending',
  `verified_by_kantor` int(11) DEFAULT NULL,
  `catatan_kantor` mediumtext DEFAULT NULL,
  `verified_at_kantor` timestamp NULL DEFAULT NULL,
  `uploaded_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `is_active` tinyint(1) DEFAULT 1,
  `archived_at` timestamp NULL DEFAULT NULL,
  `archive_reason` varchar(500) DEFAULT NULL,
  `replaced_upload_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data untuk tabel `upload_sub_elemen`
--

INSERT INTO `upload_sub_elemen` (`id`, `sub_elemen_berkas_id`, `uploaded_by`, `nama_file_asli`, `nama_file_sistem`, `ukuran_file`, `mime_type`, `path_file`, `deskripsi_berkas`, `metadata`, `status_verifikasi_dept`, `verified_by_dept`, `catatan_dept`, `verified_at_dept`, `status_verifikasi_kantor`, `verified_by_kantor`, `catatan_kantor`, `verified_at_kantor`, `uploaded_at`, `updated_at`, `is_active`, `archived_at`, `archive_reason`, `replaced_upload_id`) VALUES
(14, 19, 2, 'Tambahkan subjudul.pdf', '689aaaece9a39_1754966764.pdf', 38572, 'application/pdf', 'uploads/berkas-audit/2025/08/689aaaece9a39_1754966764.pdf', '', NULL, 'pending', NULL, NULL, NULL, 'pending', NULL, NULL, NULL, '2025-08-12 02:46:04', '2025-08-12 02:46:04', 1, NULL, NULL, NULL),
(15, 20, 2, 'Tambahkan subjudul.pdf', '689aab1127020_1754966801.pdf', 38572, 'application/pdf', 'uploads/berkas-audit/2025/08/689aab1127020_1754966801.pdf', '', NULL, 'pending', NULL, NULL, NULL, 'pending', NULL, NULL, NULL, '2025-08-12 02:46:41', '2025-08-12 02:46:41', 1, NULL, NULL, NULL),
(16, 21, 2, 'Tambahkan subjudul.pdf', '689abedc7801c_1754971868.pdf', 38572, 'application/pdf', 'uploads/berkas-audit/2025/08/689abedc7801c_1754971868.pdf', '', NULL, 'pending', NULL, NULL, NULL, 'rejected', 2, 'kkk', '2025-08-12 04:11:37', '2025-08-12 04:11:08', '2025-08-14 04:04:00', 0, '2025-08-14 04:04:00', 'Diganti dengan upload ulang karena ditolak', NULL),
(17, 21, 2, 'Tambahkan subjudul.pdf', '689d603029df0_1755144240.pdf', 38572, 'application/pdf', 'uploads/berkas-audit/2025/08/689d603029df0_1755144240.pdf', ' (Upload ulang: )', NULL, 'pending', NULL, NULL, NULL, 'pending', NULL, NULL, NULL, '2025-08-14 04:04:00', '2025-08-14 04:04:00', 1, NULL, NULL, 16),
(18, 22, 2, 'Tambahkan subjudul.pdf', '689f29b595e3d_1755261365.pdf', 38572, 'application/pdf', 'uploads/berkas-audit/2025/08/689f29b595e3d_1755261365.pdf', '', NULL, 'pending', NULL, NULL, NULL, 'pending', NULL, NULL, NULL, '2025-08-15 12:36:05', '2025-08-15 12:36:05', 1, NULL, NULL, NULL);

--
-- Trigger `upload_sub_elemen`
--
DELIMITER $$
CREATE TRIGGER `tr_audit_log_insert` AFTER INSERT ON `upload_sub_elemen` FOR EACH ROW BEGIN
    INSERT INTO activity_log (user_id, action, table_name, record_id, new_values, description)
    VALUES (NEW.uploaded_by, 'upload', 'upload_sub_elemen', NEW.id, 
           JSON_OBJECT('file_name', NEW.nama_file_asli, 'file_size', NEW.ukuran_file),
           CONCAT('Upload berkas: ', NEW.nama_file_asli));
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Struktur dari tabel `upload_sub_sub_elemen`
--

CREATE TABLE `upload_sub_sub_elemen` (
  `id` int(11) NOT NULL,
  `sub_sub_elemen_berkas_id` int(11) NOT NULL,
  `uploaded_by` int(11) NOT NULL,
  `nama_file_asli` varchar(255) NOT NULL,
  `nama_file_sistem` varchar(255) NOT NULL,
  `ukuran_file` int(11) NOT NULL,
  `mime_type` varchar(100) DEFAULT NULL,
  `path_file` varchar(500) NOT NULL,
  `deskripsi_berkas` mediumtext DEFAULT NULL,
  `metadata` longtext DEFAULT NULL CHECK (json_valid(`metadata`)),
  `status_verifikasi_dept` enum('pending','approved','rejected','actived') DEFAULT 'pending',
  `verified_by_dept` int(11) DEFAULT NULL,
  `catatan_dept` mediumtext DEFAULT NULL,
  `verified_at_dept` timestamp NULL DEFAULT NULL,
  `status_verifikasi_kantor` enum('pending','approved','rejected') DEFAULT 'pending',
  `verified_by_kantor` int(11) DEFAULT NULL,
  `catatan_kantor` mediumtext DEFAULT NULL,
  `verified_at_kantor` timestamp NULL DEFAULT NULL,
  `uploaded_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `is_active` tinyint(1) DEFAULT 1,
  `archived_at` timestamp NULL DEFAULT NULL,
  `archive_reason` varchar(500) DEFAULT NULL,
  `replaced_upload_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `nama_lengkap` varchar(100) NOT NULL,
  `role` enum('QualitySystemCommittee','AuditSteeringCommittee','AuditCommittee','Programmer') NOT NULL,
  `departemen_id` int(11) DEFAULT NULL,
  `nomor_whatsapp` varchar(20) DEFAULT NULL,
  `status` enum('aktif','nonaktif','suspended') DEFAULT 'aktif',
  `last_login` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data untuk tabel `users`
--

INSERT INTO `users` (`id`, `username`, `email`, `password`, `nama_lengkap`, `role`, `departemen_id`, `nomor_whatsapp`, `status`, `last_login`, `created_at`, `updated_at`) VALUES
(1, 'qms', 'auditpro.kppagmr@gmail.com', '$2y$10$cw1R8M0VABZNXS6zcoBzH./I.jW9e/9HVK3YrKThmTO8YIlHP86uu', 'Quality Management System', 'QualitySystemCommittee', NULL, '6285826177472', 'aktif', '2025-11-03 04:52:23', '2025-08-09 01:51:44', '2025-11-03 04:52:23'),
(2, 'programmer', 'programmer@audit.com', '$2y$10$cw1R8M0VABZNXS6zcoBzH./I.jW9e/9HVK3YrKThmTO8YIlHP86uu', 'System Programmer', 'Programmer', NULL, '085173333433', 'aktif', '2025-11-03 00:50:05', '2025-08-09 01:51:44', '2025-11-03 00:50:05'),
(6, 'ivy', 'tsana.alivy@kppmining.com', '$2y$10$YWmKtRVINB8AaFo5Ox4hLeVAuII6U7sXBi.Fo5FfayecI3zTfdEsq', 'Tsana Febiska Alivy', 'AuditCommittee', 6, '6285826177472', 'aktif', '2025-11-02 12:10:17', '2025-08-20 07:11:49', '2025-11-02 12:10:17');

-- --------------------------------------------------------

--
-- Struktur dari tabel `v_audit_structure`
--

CREATE TABLE `v_audit_structure` (
  `audit_id` int(11) DEFAULT NULL,
  `nama_audit` varchar(100) DEFAULT NULL,
  `elemen_id` int(11) DEFAULT NULL,
  `kode_elemen` varchar(20) DEFAULT NULL,
  `nama_elemen` varchar(200) DEFAULT NULL,
  `persentase_bobot` decimal(5,2) DEFAULT NULL,
  `sub_elemen_id` int(11) DEFAULT NULL,
  `kode_sub_elemen` varchar(20) DEFAULT NULL,
  `nama_sub_elemen` varchar(200) DEFAULT NULL,
  `sub_elemen_poin` int(11) DEFAULT NULL,
  `sub_sub_elemen_id` int(11) DEFAULT NULL,
  `kode_sub_sub_elemen` varchar(20) DEFAULT NULL,
  `nama_sub_sub_elemen` varchar(200) DEFAULT NULL,
  `sub_sub_elemen_poin` int(11) DEFAULT NULL,
  `upload_level` varchar(16) DEFAULT NULL,
  `info_berkas_utama` varbinary(64) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `v_elemen_scores`
--

CREATE TABLE `v_elemen_scores` (
  `elemen_id` int(11) DEFAULT NULL,
  `audit_id` int(11) DEFAULT NULL,
  `kode_elemen` varchar(20) DEFAULT NULL,
  `nama_elemen` varchar(200) DEFAULT NULL,
  `persentase_bobot` decimal(5,2) DEFAULT NULL,
  `total_nilai` decimal(28,2) DEFAULT NULL,
  `total_maksimal` decimal(33,0) DEFAULT NULL,
  `last_scored_at` timestamp NULL DEFAULT NULL,
  `last_scored_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `v_nilai_otomatis_departemen`
--

CREATE TABLE `v_nilai_otomatis_departemen` (
  `audit_id` int(11) DEFAULT NULL,
  `nama_audit` varchar(100) DEFAULT NULL,
  `departemen_id` int(11) DEFAULT NULL,
  `nama_departemen` varchar(100) DEFAULT NULL,
  `nilai_otomatis` decimal(5,2) DEFAULT NULL,
  `total_berkas_approved` bigint(22) DEFAULT NULL,
  `progress_percentage` decimal(27,2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `v_progress_penilaian`
--

CREATE TABLE `v_progress_penilaian` (
  `audit_id` int(11) DEFAULT NULL,
  `departemen_id` int(11) DEFAULT NULL,
  `nama_departemen` varchar(100) DEFAULT NULL,
  `nilai_final` decimal(5,2) DEFAULT NULL,
  `catatan_auditor` mediumtext DEFAULT NULL,
  `auditor_id` int(11) DEFAULT NULL,
  `status` enum('draft','submitted','reviewed','final') DEFAULT NULL,
  `nilai_otomatis` decimal(5,2) DEFAULT NULL,
  `submitted_at` timestamp NULL DEFAULT NULL,
  `reviewed_at` timestamp NULL DEFAULT NULL,
  `finalized_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `whatsapp_config`
--

CREATE TABLE `whatsapp_config` (
  `id` int(11) NOT NULL,
  `api_key` varchar(100) NOT NULL,
  `sender_number` varchar(20) NOT NULL,
  `gateway_url` varchar(255) NOT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

--
-- Dumping data untuk tabel `whatsapp_config`
--

INSERT INTO `whatsapp_config` (`id`, `api_key`, `sender_number`, `gateway_url`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'cWvP1ZNoFMoMxJwshWecOHPk1Bd3ou', '628388150457', 'https://wa.baznaskotabjm.org/send-message', 1, '2025-08-09 01:51:44', '2025-11-02 12:51:25');

-- --------------------------------------------------------

--
-- Struktur dari tabel `whatsapp_log`
--

CREATE TABLE `whatsapp_log` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `nomor_tujuan` varchar(20) NOT NULL,
  `pesan` mediumtext NOT NULL,
  `jenis_notifikasi` enum('upload_berkas','verifikasi','mingguan','deadline','reminder','nilai_otomatis','nilai_final','ai_learning','ai_summary','berkas_wajib_ditambahkan','berkas_uploaded','berkas_dept_verified','berkas_final_approved','berkas_rejected','berkas_reupload') DEFAULT NULL,
  `status_pengiriman` enum('pending','sent','failed') DEFAULT 'pending',
  `response_gateway` mediumtext DEFAULT NULL,
  `audit_id` int(11) DEFAULT NULL,
  `departemen_id` int(11) DEFAULT NULL,
  `ai_session_id` int(11) DEFAULT NULL,
  `sent_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Indexes for dumped tables
--

--
-- Indeks untuk tabel `activity_log`
--
ALTER TABLE `activity_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user_action` (`user_id`,`action`),
  ADD KEY `idx_table_record` (`table_name`,`record_id`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indeks untuk tabel `ai_chat_messages`
--
ALTER TABLE `ai_chat_messages`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_session_id` (`session_id`),
  ADD KEY `idx_is_user` (`is_user`),
  ADD KEY `idx_created_at` (`created_at`),
  ADD KEY `idx_chat_message_session_created` (`session_id`,`created_at`);

--
-- Indeks untuk tabel `ai_chat_sessions`
--
ALTER TABLE `ai_chat_sessions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `session_id` (`session_id`),
  ADD KEY `idx_session_id` (`session_id`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_created_at` (`created_at`),
  ADD KEY `fk_chat_session_audit` (`audit_id`),
  ADD KEY `fk_chat_session_elemen` (`elemen_id`),
  ADD KEY `idx_chat_session_user_status` (`user_id`,`status`),
  ADD KEY `idx_chat_session_updated` (`updated_at` DESC);

--
-- Indeks untuk tabel `ai_conversations`
--
ALTER TABLE `ai_conversations`
  ADD PRIMARY KEY (`id`),
  ADD KEY `gemini_api_key_id` (`gemini_api_key_id`),
  ADD KEY `idx_ai_conversations_session` (`session_id`,`created_at`);

--
-- Indeks untuk tabel `ai_knowledge_base`
--
ALTER TABLE `ai_knowledge_base`
  ADD PRIMARY KEY (`id`),
  ADD KEY `audit_id` (`audit_id`),
  ADD KEY `elemen_id` (`elemen_id`),
  ADD KEY `sub_elemen_id` (`sub_elemen_id`),
  ADD KEY `sub_sub_elemen_id` (`sub_sub_elemen_id`);
ALTER TABLE `ai_knowledge_base` ADD FULLTEXT KEY `ft_question_pattern` (`question_pattern`);
ALTER TABLE `ai_knowledge_base` ADD FULLTEXT KEY `ft_cached_response` (`cached_response`);

--
-- Indeks untuk tabel `ai_learning_sessions`
--
ALTER TABLE `ai_learning_sessions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `session_token` (`session_token`),
  ADD KEY `audit_id` (`audit_id`),
  ADD KEY `elemen_id` (`elemen_id`),
  ADD KEY `sub_elemen_id` (`sub_elemen_id`),
  ADD KEY `sub_sub_elemen_id` (`sub_sub_elemen_id`),
  ADD KEY `idx_ai_sessions_active` (`user_id`,`is_active`,`current_step`),
  ADD KEY `idx_ai_sessions_token` (`session_token`);

--
-- Indeks untuk tabel `ai_prompt_templates`
--
ALTER TABLE `ai_prompt_templates`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `idx_ai_prompt_templates_active` (`step_type`,`is_active`);

--
-- Indeks untuk tabel `akses_audit`
--
ALTER TABLE `akses_audit`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_audit_dept` (`audit_id`,`departemen_id`),
  ADD KEY `departemen_id` (`departemen_id`);

--
-- Indeks untuk tabel `audit`
--
ALTER TABLE `audit`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `deleted_by` (`deleted_by`),
  ADD KEY `fk_audit_activated_by` (`activated_by`),
  ADD KEY `fk_audit_selesai_by` (`selesai_by`),
  ADD KEY `idx_audit_status` (`status`),
  ADD KEY `idx_audit_updated_by` (`updated_by`);

--
-- Indeks untuk tabel `berkas_pendukung_sub_elemen`
--
ALTER TABLE `berkas_pendukung_sub_elemen`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uploaded_by` (`uploaded_by`),
  ADD KEY `verified_by` (`verified_by`),
  ADD KEY `idx_berkas_pendukung_sub` (`sub_elemen_id`,`uploaded_by`);

--
-- Indeks untuk tabel `berkas_pendukung_sub_sub_elemen`
--
ALTER TABLE `berkas_pendukung_sub_sub_elemen`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uploaded_by` (`uploaded_by`),
  ADD KEY `verified_by` (`verified_by`),
  ADD KEY `idx_berkas_pendukung_sub_sub` (`sub_sub_elemen_id`,`uploaded_by`);

--
-- Indeks untuk tabel `departemen`
--
ALTER TABLE `departemen`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `kode_departemen` (`kode_departemen`);

--
-- Indeks untuk tabel `elemen`
--
ALTER TABLE `elemen`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_kode_per_audit` (`audit_id`,`kode_elemen`),
  ADD KEY `idx_audit_persentase` (`audit_id`,`persentase_bobot`),
  ADD KEY `idx_elemen_audit` (`audit_id`,`status`),
  ADD KEY `idx_last_scored_by` (`last_scored_by`);

--
-- Indeks untuk tabel `elemen_akses`
--
ALTER TABLE `elemen_akses`
  ADD PRIMARY KEY (`id`),
  ADD KEY `elemen_id` (`elemen_id`),
  ADD KEY `created_by` (`created_by`);

--
-- Indeks untuk tabel `elemen_akses_departemen`
--
ALTER TABLE `elemen_akses_departemen`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_akses_departemen` (`elemen_akses_id`,`departemen_id`),
  ADD KEY `departemen_id` (`departemen_id`);

--
-- Indeks untuk tabel `gemini_api_keys`
--
ALTER TABLE `gemini_api_keys`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_gemini_api_active` (`is_active`,`quota_terpakai`,`quota_harian`);

--
-- Indeks untuk tabel `jenis_berkas`
--
ALTER TABLE `jenis_berkas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `departemen_id` (`departemen_id`);

--
-- Indeks untuk tabel `learning_progress`
--
ALTER TABLE `learning_progress`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_user_elemen` (`user_id`,`elemen_id`),
  ADD KEY `elemen_id` (`elemen_id`);

--
-- Indeks untuk tabel `penilaian_audit`
--
ALTER TABLE `penilaian_audit`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_audit_dept` (`audit_id`,`departemen_id`),
  ADD KEY `departemen_id` (`departemen_id`),
  ADD KEY `auditor_id` (`auditor_id`),
  ADD KEY `idx_penilaian_audit_dept` (`audit_id`,`departemen_id`);

--
-- Indeks untuk tabel `penilaian_sub_elemen`
--
ALTER TABLE `penilaian_sub_elemen`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_sub_elemen` (`sub_elemen_id`),
  ADD KEY `idx_sub_elemen` (`sub_elemen_id`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `idx_updated_by` (`updated_by`);

--
-- Indeks untuk tabel `penilaian_sub_sub_elemen`
--
ALTER TABLE `penilaian_sub_sub_elemen`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_sub_sub_elemen` (`sub_sub_elemen_id`),
  ADD KEY `idx_sub_sub_elemen` (`sub_sub_elemen_id`),
  ADD KEY `idx_created_by` (`created_by`),
  ADD KEY `idx_updated_by` (`updated_by`);

--
-- Indeks untuk tabel `sistem_log`
--
ALTER TABLE `sistem_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_target_type` (`target_type`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indeks untuk tabel `sub_elemen`
--
ALTER TABLE `sub_elemen`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_kode_per_elemen` (`elemen_id`,`kode_sub_elemen`),
  ADD KEY `idx_sub_elemen_parent` (`elemen_id`,`status`);

--
-- Indeks untuk tabel `sub_elemen_berkas`
--
ALTER TABLE `sub_elemen_berkas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `jenis_berkas_id` (`jenis_berkas_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `idx_is_active` (`is_active`),
  ADD KEY `idx_sub_elemen_jenis` (`sub_elemen_id`,`jenis_berkas_id`);

--
-- Indeks untuk tabel `sub_sub_elemen`
--
ALTER TABLE `sub_sub_elemen`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_kode_per_sub_elemen` (`sub_elemen_id`,`kode_sub_sub_elemen`),
  ADD KEY `idx_sub_sub_elemen_parent` (`sub_elemen_id`,`status`);

--
-- Indeks untuk tabel `sub_sub_elemen_berkas`
--
ALTER TABLE `sub_sub_elemen_berkas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `jenis_berkas_id` (`jenis_berkas_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `idx_is_active` (`is_active`),
  ADD KEY `idx_sub_sub_elemen_jenis` (`sub_sub_elemen_id`,`jenis_berkas_id`);

--
-- Indeks untuk tabel `upload_sub_elemen`
--
ALTER TABLE `upload_sub_elemen`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sub_elemen_berkas_id` (`sub_elemen_berkas_id`),
  ADD KEY `uploaded_by` (`uploaded_by`),
  ADD KEY `verified_by_dept` (`verified_by_dept`),
  ADD KEY `verified_by_kantor` (`verified_by_kantor`),
  ADD KEY `idx_upload_verifikasi` (`status_verifikasi_dept`,`status_verifikasi_kantor`),
  ADD KEY `idx_is_active` (`is_active`),
  ADD KEY `idx_replaced_upload_id` (`replaced_upload_id`);

--
-- Indeks untuk tabel `upload_sub_sub_elemen`
--
ALTER TABLE `upload_sub_sub_elemen`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sub_sub_elemen_berkas_id` (`sub_sub_elemen_berkas_id`),
  ADD KEY `uploaded_by` (`uploaded_by`),
  ADD KEY `verified_by_dept` (`verified_by_dept`),
  ADD KEY `verified_by_kantor` (`verified_by_kantor`),
  ADD KEY `idx_upload_sub_sub_verifikasi` (`status_verifikasi_dept`,`status_verifikasi_kantor`),
  ADD KEY `idx_is_active` (`is_active`),
  ADD KEY `idx_replaced_upload_id` (`replaced_upload_id`);

--
-- Indeks untuk tabel `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD UNIQUE KEY `email` (`email`),
  ADD KEY `departemen_id` (`departemen_id`),
  ADD KEY `idx_users_role_dept` (`role`,`departemen_id`);

--
-- Indeks untuk tabel `whatsapp_config`
--
ALTER TABLE `whatsapp_config`
  ADD PRIMARY KEY (`id`);

--
-- Indeks untuk tabel `whatsapp_log`
--
ALTER TABLE `whatsapp_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `audit_id` (`audit_id`),
  ADD KEY `departemen_id` (`departemen_id`),
  ADD KEY `idx_whatsapp_log_ai` (`ai_session_id`,`jenis_notifikasi`);

--
-- AUTO_INCREMENT untuk tabel yang dibuang
--

--
-- AUTO_INCREMENT untuk tabel `activity_log`
--
ALTER TABLE `activity_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=400;

--
-- AUTO_INCREMENT untuk tabel `ai_chat_messages`
--
ALTER TABLE `ai_chat_messages`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=25;

--
-- AUTO_INCREMENT untuk tabel `ai_chat_sessions`
--
ALTER TABLE `ai_chat_sessions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT untuk tabel `ai_conversations`
--
ALTER TABLE `ai_conversations`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=23;

--
-- AUTO_INCREMENT untuk tabel `ai_knowledge_base`
--
ALTER TABLE `ai_knowledge_base`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT untuk tabel `ai_learning_sessions`
--
ALTER TABLE `ai_learning_sessions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=104;

--
-- AUTO_INCREMENT untuk tabel `ai_prompt_templates`
--
ALTER TABLE `ai_prompt_templates`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT untuk tabel `akses_audit`
--
ALTER TABLE `akses_audit`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT untuk tabel `audit`
--
ALTER TABLE `audit`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT untuk tabel `berkas_pendukung_sub_elemen`
--
ALTER TABLE `berkas_pendukung_sub_elemen`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT untuk tabel `berkas_pendukung_sub_sub_elemen`
--
ALTER TABLE `berkas_pendukung_sub_sub_elemen`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT untuk tabel `departemen`
--
ALTER TABLE `departemen`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT untuk tabel `elemen`
--
ALTER TABLE `elemen`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=46;

--
-- AUTO_INCREMENT untuk tabel `elemen_akses`
--
ALTER TABLE `elemen_akses`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT untuk tabel `elemen_akses_departemen`
--
ALTER TABLE `elemen_akses_departemen`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT untuk tabel `gemini_api_keys`
--
ALTER TABLE `gemini_api_keys`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT untuk tabel `jenis_berkas`
--
ALTER TABLE `jenis_berkas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT untuk tabel `learning_progress`
--
ALTER TABLE `learning_progress`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT untuk tabel `penilaian_audit`
--
ALTER TABLE `penilaian_audit`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT untuk tabel `penilaian_sub_elemen`
--
ALTER TABLE `penilaian_sub_elemen`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=86;

--
-- AUTO_INCREMENT untuk tabel `penilaian_sub_sub_elemen`
--
ALTER TABLE `penilaian_sub_sub_elemen`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=125;

--
-- AUTO_INCREMENT untuk tabel `sistem_log`
--
ALTER TABLE `sistem_log`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT untuk tabel `sub_elemen`
--
ALTER TABLE `sub_elemen`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=310;

--
-- AUTO_INCREMENT untuk tabel `sub_elemen_berkas`
--
ALTER TABLE `sub_elemen_berkas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=23;

--
-- AUTO_INCREMENT untuk tabel `sub_sub_elemen`
--
ALTER TABLE `sub_sub_elemen`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=375;

--
-- AUTO_INCREMENT untuk tabel `sub_sub_elemen_berkas`
--
ALTER TABLE `sub_sub_elemen_berkas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT untuk tabel `upload_sub_elemen`
--
ALTER TABLE `upload_sub_elemen`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19;

--
-- AUTO_INCREMENT untuk tabel `upload_sub_sub_elemen`
--
ALTER TABLE `upload_sub_sub_elemen`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT untuk tabel `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT untuk tabel `whatsapp_config`
--
ALTER TABLE `whatsapp_config`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT untuk tabel `whatsapp_log`
--
ALTER TABLE `whatsapp_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=42;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
