<?php
require_once __DIR__ . "/vendor/autoload.php";
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

// Buat spreadsheet baru
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set judul sheet
$sheet->setTitle("Template Import Berkas Audit");

// Set header kolom
$headers = [
	"A" => "NO",
	"B" => "KODE SUB ELEMEN",
	"C" => "KODE SUB SUB ELEMEN",
	"D" => "KRITERIA",
	"E" => "METODE AUDIT",
	"F" => "(MERGE - ISI DI KOLOM G)",
	"G" => "SAMPLE / CATATAN KHUSUS",
];

// Set header
foreach ($headers as $col => $value) {
	$sheet->setCellValue($col . "1", $value);

	// Style header
	$sheet
		->getStyle($col . "1")
		->getFont()
		->setBold(true);
	$sheet
		->getStyle($col . "1")
		->getAlignment()
		->setHorizontal(Alignment::HORIZONTAL_CENTER)
		->setVertical(Alignment::VERTICAL_CENTER);
	$sheet
		->getStyle($col . "1")
		->getFill()
		->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
	$sheet
		->getStyle($col . "1")
		->getFill()
		->getStartColor()
		->setARGB("FFD3D3D3");
	$sheet
		->getStyle($col . "1")
		->getBorders()
		->getAllBorders()
		->setBorderStyle(Border::BORDER_THIN);
}

// Set width kolom
$sheet->getColumnDimension("A")->setWidth(8);
$sheet->getColumnDimension("B")->setWidth(15);
$sheet->getColumnDimension("C")->setWidth(18);
$sheet->getColumnDimension("D")->setWidth(35);
$sheet->getColumnDimension("E")->setWidth(25);
$sheet->getColumnDimension("F")->setWidth(20);
$sheet->getColumnDimension("G")->setWidth(80);

// Set height untuk header
$sheet->getRowDimension(1)->setRowHeight(25);

// Tambahkan contoh data sesuai format pada gambar
$contohData = [
	[
		"A" => 1,
		"B" => "I.1",
		"C" => "",
		"D" => "Penyusunan Kebijakan",
		"E" => "Tinjauan dokumen & Rekaman, Wawancara",
		"F" => "",
		"G" => "- Dokumen SOP Kebijakan yang menunjukkan tatacara penyusunan Kebijakan",
	],
	[
		"A" => 2,
		"B" => "I.2",
		"C" => "",
		"D" => "Penetapan Kebijakan",
		"E" => "Tinjauan dokumen & Rekaman",
		"F" => "",
		"G" => "- Dokumen Kebijakan Keselamatan Pertambangan yang ditandatangani",
	],
	[
		"A" => 3,
		"B" => "",
		"C" => "I.2.1",
		"D" => "Sub Sub Elemen dari Penetapan Kebijakan",
		"E" => "Tinjauan dokumen & Rekaman, Wawancara",
		"F" => "",
		"G" => "- Dokumen bukti penetapan kebijakan",
	],
];

// Isi contoh data
$row = 2;
foreach ($contohData as $data) {
	foreach ($headers as $col => $value) {
		if (isset($data[$col])) {
			$sheet->setCellValue($col . $row, $data[$col]);

			// Style data
			$sheet
				->getStyle($col . $row)
				->getBorders()
				->getAllBorders()
				->setBorderStyle(Border::BORDER_THIN);
			$sheet
				->getStyle($col . $row)
				->getAlignment()
				->setVertical(Alignment::VERTICAL_TOP);

			// Wrap text untuk kolom yang panjang
			if (in_array($col, ["B", "D", "E", "F", "G"])) {
				$sheet
					->getStyle($col . $row)
					->getAlignment()
					->setWrapText(true);
			}
		}
	}
	$row++;
}

// Tambahkan notes di bawah tabel
$notesRow = $row + 2;
$sheet->mergeCells("A" . $notesRow . ":G" . $notesRow);
$sheet->setCellValue("A" . $notesRow, "NOTES:");
$sheet
	->getStyle("A" . $notesRow)
	->getFont()
	->setBold(true);

$notes = [
	"1. Kolom A: Isi nomor urut (opsional)",
	"2. Kolom B-E: Bisa di-merge, sistem akan otomatis mendeteksi kode dan kriteria",
	"3. Kolom B: Isi KODE SUB ELEMEN (contoh: I.1, II.1, III.1, dll) - WAJIB DIISI jika tidak ada sub sub elemen",
	"4. Kolom C: Isi KODE SUB SUB ELEMEN (contoh: I.1.1, II.2.1, dll) - akan diprioritaskan jika diisi",
	"5. Kolom D: Isi nama kriteria/elemen (opsional)",
	"6. Kolom E: Isi metode audit yang digunakan (opsional)",
	"7. Kolom G: Isi sample/catatan khusus/dokumen yang dibutuhkan - WAJIB DIISI (kolom utama)",
	"8. Format KODE YANG VALID:",
	"   - Sub Elemen: I.1, I.2, II.1, II.2, III.1, dst",
	"   - Sub Sub Elemen: I.1.1, I.1.2, II.2.1, II.2.2, dst",
	"9. Jika kolom B-F di-merge, sistem akan membaca semua data dan mengidentifikasi secara otomatis",
	"10. Sistem akan otomatis mendeteksi apakah data termasuk sub_elemen atau sub_sub_elemen berdasarkan kode yang ada",
	"11. Pastikan kode sub elemen dan sub sub elemen sesuai dengan yang ada di sistem",
	"12. Jika kode tidak ditemukan di database, data akan dilewati",
];

$noteRow = $notesRow + 1;
foreach ($notes as $note) {
	$sheet->mergeCells("A" . $noteRow . ":G" . $noteRow);
	$sheet->setCellValue("A" . $noteRow, $note);
	$sheet
		->getStyle("A" . $noteRow)
		->getAlignment()
		->setWrapText(true);
	$noteRow++;
}

// Freeze pane untuk header
$sheet->freezePane("A2");

// Set active sheet
$spreadsheet->setActiveSheetIndex(0);

// Save file
$filename = "Template_Import_Berkas_Audit_" . date("Y-m-d") . ".xlsx";

header(
	"Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
);
header('Content-Disposition: attachment;filename="' . $filename . '"');
header("Cache-Control: max-age=0");

$writer = new Xlsx($spreadsheet);
$writer->save("php://output");
exit();
?>
